/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.common.composite;

import java.util.List;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import com.clustercontrol.bean.JobImageConstant;
import com.clustercontrol.jobmanagement.bean.JobConstant;
import com.clustercontrol.jobmanagement.util.JobPropertyUtil;
import com.clustercontrol.util.LoginManager;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobManagementUserInfo;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;

/**
 * ジョブツリーLabelProviderクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
class JobTreeLabelProvider extends LabelProvider {


	@Override
	public String getText(Object element) {
		JobInfo info = ((JobTreeItem) element).getData();

		int type = info.getType();
		if (type == JobConstant.TYPE_COMPOSITE) {
			return info.getName();
		} else {
			return info.getName() + " (" + info.getId() + ")";
		}
	}

	@Override
	public Image getImage(Object element) {

		boolean isReferableJobunit = false;

		JobTreeItem item = (JobTreeItem) element;
		int type = item.getData().getType();

		//ジョブユニットの場合、参照可能かチェックする
		if (type == JobConstant.TYPE_JOBUNIT) {
			JobPropertyUtil.setJobFull(item.getData());
			List<JobManagementUserInfo> userInfo = item.getData().getManagementUser();
			if (userInfo == null || userInfo.size() == 0) {
				isReferableJobunit = true;
			} else {
				for (JobManagementUserInfo i : userInfo) {
					String loginUser = LoginManager.getContextManager().getUserId();
					if (loginUser.equals(i.getUserId())) {
						isReferableJobunit = true;
						break;
					}
				}
			}
		} else {
			isReferableJobunit = true;
		}

		// ログインユーザで参照できないジョブユニットの場合はアイコンを変える
		if (!isReferableJobunit) {
			return JobImageConstant.typeToImage(JobConstant.TYPE_JOBUNIT_UNREFERABLE);
		} else {
			return JobImageConstant.typeToImage(type);
		}
	}
}