/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.composite;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.bean.SizeConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.composite.NumberVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.action.GetWaitRuleTableDefine;
import com.clustercontrol.jobmanagement.bean.ConditionTypeConstant;
import com.clustercontrol.jobmanagement.bean.JudgmentObjectConstant;
import com.clustercontrol.jobmanagement.composite.action.WaitRuleSelectionChangedListener;
import com.clustercontrol.jobmanagement.dialog.WaitRuleDialog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.JobObjectInfo;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.clustercontrol.ws.jobmanagement.JobWaitRuleInfo;

/**
 * 待ち条件タブ用のコンポジットクラスです。
 * 
 * @version 2.1.0
 * @since 1.0.0
 */
public class WaitRuleComposite extends Composite {
	/** テーブルビューア */
	protected CommonTableViewer m_viewer = null;
	/** 判定対象の条件関係 AND用ラジオボタン */
	protected Button m_andCondition = null;
	/** 判定対象の条件関係 OR用ラジオボタン */
	protected Button m_orCondition = null;
	/** 条件を満たさなければ終了する用チェックボタン */
	protected Button m_endCondition = null;
	/** 条件を満たさなければ終了する用グループ */
	protected Group m_endConditionGroup = null;
	/** 条件を満たさない時の終了値用テキスト */
	protected Text m_endValue = null;
	/** 追加用ボタン */
	protected Button m_createCondition = null;
	/** 変更用ボタン */
	protected Button m_modifyCondition = null;
	/** 削除用ボタン */
	protected Button m_deleteCondition = null;
	/** ジョブ待ち条件情報 */
	protected JobWaitRuleInfo m_waitRule = null;
	/** シェル */
	protected Shell m_shell = null;
	/** 選択アイテム */
	protected ArrayList m_selectItem = null;

	private JobTreeItem m_jobTreeItem = null;

	/**
	 * コンストラクタ
	 * 
	 * @param parent 親のコンポジット
	 * @param style スタイル
	 * 
	 * @see org.eclipse.swt.SWT
	 * @see org.eclipse.swt.widgets.Composite#Composite(Composite parent, int style)
	 * @see #initialize()
	 */
	public WaitRuleComposite(Composite parent, int style) {
		super(parent, style);
		initialize();
		m_shell = this.getShell();
	}

	/**
	 * コンポジットを構築します。
	 */
	private void initialize() {
		RowLayout layout = new RowLayout();
		layout.type = SWT.VERTICAL;
		layout.spacing = 1;
		layout.marginWidth = 5;
		layout.marginHeight = 5;
		layout.fill = true;
		this.setLayout(layout);

		Composite composite = null;
		RowLayout rowLayout = null;

		composite = new Composite(this, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		composite.setLayout(rowLayout);

		Label tableTitle = new Label(composite, SWT.NONE);
		tableTitle.setText(Messages.getString("object.list"));

		Table table = new Table(composite, SWT.BORDER | SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.SINGLE);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		table.setLayoutData(new RowData(430, 80));

		composite = new Composite(composite, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 5;
		composite.setLayout(rowLayout);

		//判定対象の追加
		Label dummy1 = new Label(composite, SWT.NONE);
		dummy1.setLayoutData(new RowData(190, SizeConstant.SIZE_LABEL_HEIGHT));
		m_createCondition = new Button(composite, SWT.NONE);
		m_createCondition.setText(Messages.getString("add"));
		m_createCondition.setLayoutData(new RowData(80,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_createCondition.addSelectionListener(new SelectionAdapter() {
			@Override
			@SuppressWarnings("unchecked")
			public void widgetSelected(SelectionEvent e) {
				WaitRuleDialog dialog = new WaitRuleDialog(m_shell, m_jobTreeItem);
				if (dialog.open() == IDialogConstants.OK_ID) {

					// 待ち条件を追加するかどうかを示すフラグ
					boolean addWaitRule = true;

					ArrayList info = dialog.getInputData();
					ArrayList list = (ArrayList) m_viewer.getInput();
					if (list == null) {
						list = new ArrayList();

					} else {

						//待ち条件として複数の時刻を設定しようとした場合はフラグをfalseとする
						int newWaitRuleType = (Integer) info.get(GetWaitRuleTableDefine.JUDGMENT_OBJECT);
						if (newWaitRuleType == JudgmentObjectConstant.TYPE_TIME){

							Iterator itr = list.iterator();
							while (itr.hasNext()) {
								ArrayList waitRule = (ArrayList) itr.next();
								int rule = (Integer) waitRule.get(GetWaitRuleTableDefine.JUDGMENT_OBJECT);
								if (rule == JudgmentObjectConstant.TYPE_TIME) {
									addWaitRule = false;

									MessageDialog.openWarning(
											null,
											Messages.getString("warning"),
											Messages.getString("message.job.61"));
								}
							}
						}
					}

					if (addWaitRule) list.add(info);
					m_viewer.setInput(list);
				}
			}
		});

		//判定対象の変更
		m_modifyCondition = new Button(composite, SWT.NONE);
		m_modifyCondition.setText(Messages.getString("modify"));
		m_modifyCondition.setLayoutData(new RowData(80,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_modifyCondition.addSelectionListener(new SelectionAdapter() {
			@Override
			@SuppressWarnings("unchecked")
			public void widgetSelected(SelectionEvent e) {
				WaitRuleDialog dialog = new WaitRuleDialog(m_shell, m_jobTreeItem);
				if (m_selectItem instanceof ArrayList) {
					dialog.setInputData(m_selectItem);
					if (dialog.open() == IDialogConstants.OK_ID) {

						ArrayList info = dialog.getInputData();
						ArrayList list = (ArrayList) m_viewer.getInput();

						list.remove(m_selectItem);
						list.add(info);

						m_selectItem = null;
						m_viewer.setInput(list);
					}
				} else {

				}
			}
		});

		//判定対象の削除
		m_deleteCondition = new Button(composite, SWT.NONE);
		m_deleteCondition.setText(Messages.getString("delete"));
		m_deleteCondition.setLayoutData(new RowData(80,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_deleteCondition.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if (m_selectItem instanceof ArrayList) {
					ArrayList list = (ArrayList) m_viewer.getInput();
					list.remove(m_selectItem);
					m_selectItem = null;
					m_viewer.setInput(list);
				} else {

				}
			}
		});

		//判定対象の条件関係
		Group group = new Group(this, SWT.NONE);
		group.setText(Messages.getString("condition.between.objects"));
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		rowLayout.marginWidth = 5;
		rowLayout.marginHeight = 5;
		rowLayout.spacing = 1;
		group.setLayout(rowLayout);

		composite = new Composite(group, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		composite.setLayout(rowLayout);
		m_andCondition = new Button(composite, SWT.RADIO);
		m_andCondition.setText(Messages.getString("and"));
		m_andCondition.setLayoutData(new RowData(100,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_orCondition = new Button(composite, SWT.RADIO);
		m_orCondition.setText(Messages.getString("or"));
		m_orCondition.setLayoutData(new RowData(100,
				SizeConstant.SIZE_BUTTON_HEIGHT));

		composite = new Composite(this, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		composite.setLayout(rowLayout);

		//条件を満たさないときに終了
		Label dummy2 = new Label(composite, SWT.NONE);
		dummy2.setLayoutData(new RowData(190, SizeConstant.SIZE_LABEL_HEIGHT));
		m_endCondition = new Button(composite, SWT.CHECK);
		m_endCondition
		.setText(Messages.getString("end.if.condition.unmatched"));
		m_endCondition.setLayoutData(new RowData(220,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_endCondition.addSelectionListener(new SelectionListener() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				Button check = (Button) e.getSource();
				if (check.getSelection()) {
					m_endConditionGroup.setEnabled(true);
					m_endValue.setEnabled(true);
				} else {
					m_endConditionGroup.setEnabled(false);
					m_endValue.setEnabled(false);
				}
				update();
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {

			}
		});

		m_endConditionGroup = new Group(this, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		rowLayout.marginWidth = 5;
		rowLayout.marginHeight = 5;
		rowLayout.spacing = 1;
		m_endConditionGroup.setLayout(rowLayout);

		composite = new Composite(m_endConditionGroup, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		composite.setLayout(rowLayout);
		Label endValueTitle = new Label(composite, SWT.LEFT);
		endValueTitle.setText(Messages.getString("end.value") + " : ");
		endValueTitle.setLayoutData(new RowData(80,
				SizeConstant.SIZE_LABEL_HEIGHT));
		m_endValue = new Text(composite, SWT.BORDER);
		m_endValue
		.setLayoutData(new RowData(100, SizeConstant.SIZE_TEXT_HEIGHT));
		m_endValue.addVerifyListener(
				new NumberVerifyListener(DataRangeConstant.SMALLINT_LOW, DataRangeConstant.SMALLINT_HIGH));
		m_endValue.addModifyListener(
				new ModifyListener(){
					@Override
					public void modifyText(ModifyEvent arg0) {
						update();
					}
				}
		);

		m_viewer = new CommonTableViewer(table);
		m_viewer.createTableColumn(GetWaitRuleTableDefine.get(),
				GetWaitRuleTableDefine.SORT_COLUMN_INDEX,
				GetWaitRuleTableDefine.SORT_ORDER);
		m_viewer
		.addSelectionChangedListener(new WaitRuleSelectionChangedListener(
				this));
	}

	@Override
	public void update() {
		if(m_endCondition.getSelection() && "".equals(this.m_endValue.getText())){
			this.m_endValue.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
		}else{
			this.m_endValue.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
		}
	}

	/**
	 * ジョブ待ち条件情報をコンポジットに反映します。
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo
	 */
	@SuppressWarnings("unchecked")
	public void reflectWaitRuleInfo() {

		// 初期値
		m_andCondition.setSelection(true);
		m_endCondition.setSelection(false);
		m_endValue.setText(String
				.valueOf(EndStatusConstant.INITIAL_VALUE_NORMAL));

		if (m_waitRule != null) {
			//判定対象と開始条件値設定
			List<JobObjectInfo> list = m_waitRule.getObject();
			if(list != null){
				ArrayList tableData = new ArrayList();
				for (int i = 0; i < list.size(); i++) {
					JobObjectInfo info = list.get(i);
					ArrayList tableLineData = new ArrayList();
					tableLineData.add(new Integer(info.getType()));
					if (info.getType() == JudgmentObjectConstant.TYPE_JOB_END_STATUS) {
						tableLineData.add(info.getJobId());
						tableLineData.add(EndStatusConstant.typeToString(info.getValue()));
					}
					else if (info.getType() == JudgmentObjectConstant.TYPE_JOB_END_VALUE) {
						tableLineData.add(info.getJobId());
						tableLineData.add(new Integer(info.getValue()));
					}
					else {
						tableLineData.add("");
						if (info.getTime() != null) {
							tableLineData.add(new Date(info.getTime()));
						} else {
							tableLineData.add("");
						}
					}
					tableData.add(tableLineData);
				}
				m_viewer.setInput(tableData);
			}

			//条件関係設定
			if (m_waitRule.getCondition() == ConditionTypeConstant.TYPE_AND) {
				m_andCondition.setSelection(true);
				m_orCondition.setSelection(false);
			} else {
				m_andCondition.setSelection(false);
				m_orCondition.setSelection(true);
			}

			//開始条件を満たさないとき終了 設定
			m_endCondition.setSelection(YesNoConstant.typeToBoolean(m_waitRule
					.getEndCondition()));

			//終了値
			m_endValue.setText(String.valueOf(m_waitRule.getEndValue()));
		}

		//開始条件を満たさないとき終了
		if (m_endCondition.getSelection()) {
			m_endConditionGroup.setEnabled(true);
			m_endValue.setEnabled(true);
		} else {
			m_endConditionGroup.setEnabled(false);
			m_endValue.setEnabled(false);
		}
	}

	/**
	 * ジョブ待ち条件情報を設定します。
	 * 
	 * @param start ジョブ待ち条件情報
	 */
	public void setWaitRuleInfo(JobWaitRuleInfo start) {
		m_waitRule = start;
	}

	/**
	 * ジョブ待ち条件情報を返します。
	 * 
	 * @return ジョブ待ち条件情報
	 */
	public JobWaitRuleInfo getWaitRuleInfo() {
		return m_waitRule;
	}

	public static JobObjectInfo array2JobObjectInfo(ArrayList tableLineData) {
		Integer type = (Integer) tableLineData
		.get(GetWaitRuleTableDefine.JUDGMENT_OBJECT);
		JobObjectInfo info = new JobObjectInfo();
		info.setValue(0);
		info.setType(type.intValue());
		if (info.getType() == JudgmentObjectConstant.TYPE_JOB_END_STATUS) {
			info.setJobId((String) tableLineData
					.get(GetWaitRuleTableDefine.JOB_ID));
			String value = (String) tableLineData
			.get(GetWaitRuleTableDefine.START_VALUE);
			info.setValue(EndStatusConstant.stringToType(value));
		}
		else if (info.getType() == JudgmentObjectConstant.TYPE_JOB_END_VALUE) {
			info.setJobId((String) tableLineData
					.get(GetWaitRuleTableDefine.JOB_ID));
			Integer value = (Integer) tableLineData
			.get(GetWaitRuleTableDefine.START_VALUE);
			info.setValue(value.intValue());
		}
		else {
			Date value = (Date) tableLineData
			.get(GetWaitRuleTableDefine.START_VALUE);
			info.setTime(value.getTime());
		}
		return info;
	}

	/**
	 * コンポジットの情報から、ジョブ待ち条件情報を作成します。
	 * 
	 * @return 入力値の検証結果
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo
	 */
	@SuppressWarnings("unchecked")
	public ValidateResult createWaitRuleInfo() {
		ValidateResult result = null;

		//実行内容情報クラスのインスタンスを作成・取得
		if (m_waitRule == null) {
			m_waitRule = new JobWaitRuleInfo();
			m_waitRule.setSuspend(YesNoConstant.TYPE_NO);
			m_waitRule.setSkip(YesNoConstant.TYPE_NO);
			m_waitRule.setSkipEndValue(EndStatusConstant.INITIAL_VALUE_NORMAL);
			m_waitRule.setCondition(ConditionTypeConstant.TYPE_AND);
			m_waitRule.setEndCondition(YesNoConstant.TYPE_NO);
			m_waitRule.setEndValue(EndStatusConstant.INITIAL_VALUE_NORMAL);
			m_waitRule.setCalendar(YesNoConstant.TYPE_NO);
			m_waitRule.setCalendarEndValue(EndStatusConstant.INITIAL_VALUE_NORMAL);
			m_waitRule.setStartDelay(YesNoConstant.TYPE_NO);
			m_waitRule.setStartDelaySession(YesNoConstant.TYPE_NO);
			m_waitRule.setStartDelaySessionValue(1);
			m_waitRule.setStartDelayTime(YesNoConstant.TYPE_NO);
			m_waitRule.setStartDelayConditionType(ConditionTypeConstant.TYPE_AND);
			m_waitRule.setStartDelayNotify(YesNoConstant.TYPE_NO);
			m_waitRule.setStartDelayOperation(YesNoConstant.TYPE_NO);
			m_waitRule.setStartDelayOperationEndValue(EndStatusConstant.INITIAL_VALUE_NORMAL);
			m_waitRule.setEndDelay(YesNoConstant.TYPE_NO);
			m_waitRule.setEndDelaySession(YesNoConstant.TYPE_NO);
			m_waitRule.setEndDelaySessionValue(1);
			m_waitRule.setEndDelayJob(YesNoConstant.TYPE_NO);
			m_waitRule.setEndDelayJobValue(1);
			m_waitRule.setEndDelayTime(YesNoConstant.TYPE_NO);
			m_waitRule.setEndDelayConditionType(ConditionTypeConstant.TYPE_AND);
			m_waitRule.setEndDelayNotify(YesNoConstant.TYPE_NO);
			m_waitRule.setEndDelayOperation(YesNoConstant.TYPE_NO);
			m_waitRule.setEndDelayOperationEndValue(EndStatusConstant.INITIAL_VALUE_NORMAL);
			m_waitRule.setSkipEndStatus(0);
			m_waitRule.setEndStatus(0);
			m_waitRule.setStartDelayNotifyPriority(0);
			m_waitRule.setStartDelayOperationType(0);
			m_waitRule.setEndDelayNotifyPriority(0);
			m_waitRule.setEndDelayOperationType(0);
		}
		//判定対象と開始条件値取得
		ArrayList<JobObjectInfo> list = new ArrayList<JobObjectInfo>();
		ArrayList tableData = (ArrayList) m_viewer.getInput();
		HashMap<String, Integer> map = new HashMap<String, Integer>();
		if (tableData instanceof ArrayList) {
			for (int i = 0; i < tableData.size(); i++) {
				ArrayList tableLineData = (ArrayList) tableData.get(i);
				JobObjectInfo info = array2JobObjectInfo(tableLineData);
				// 重複チェックをしてから、リストに追加する。
				if (info.getType() == JudgmentObjectConstant.TYPE_JOB_END_STATUS) {
					Integer checkValue = map.get(info.getJobId() + info.getType());
					if (checkValue == null
							|| checkValue.intValue() != info.getValue()) {
						list.add(info);
						map.put(info.getJobId() + info.getType(), new Integer(info.getValue()));
					}
				}
				else if (info.getType() == JudgmentObjectConstant.TYPE_JOB_END_VALUE) {
					Integer checkValue = map.get(info.getJobId() + info.getType());
					if (checkValue == null
							|| checkValue.intValue() != info.getValue()) {
						list.add(info);
						map.put(info.getJobId() + info.getType(), new Integer(info.getValue()));
					}
				}
				else {
					if (map.get("TIME") == null) {
						list.add(info);
						map.put("TIME", 1);
					}
				}
			}
		}
		List<JobObjectInfo> jobObjectInfoList = m_waitRule.getObject();
		jobObjectInfoList.clear();
		jobObjectInfoList.addAll(list);

		//条件関係取得
		if (m_andCondition.getSelection()) {
			m_waitRule.setCondition(ConditionTypeConstant.TYPE_AND);
		} else {
			m_waitRule.setCondition(ConditionTypeConstant.TYPE_OR);
		}

		//開始条件を満たさないとき終了 設定
		m_waitRule.setEndCondition(YesNoConstant.booleanToType(m_endCondition
				.getSelection()));

		//終了値取得
		try {
			m_waitRule.setEndValue(Integer.parseInt(m_endValue.getText()));
		} catch (NumberFormatException e) {
			if (m_waitRule.getEndCondition() == YesNoConstant.TYPE_YES) {
				result = new ValidateResult();
				result.setValid(false);
				result.setID(Messages.getString("message.hinemos.1"));
				result.setMessage(Messages.getString("message.job.21"));
				return result;
			}
		}

		return null;
	}

	/**
	 * 選択アイテムを返します。
	 * 
	 * @return 選択アイテム
	 */
	public ArrayList getSelectItem() {
		return m_selectItem;
	}

	/**
	 * 選択アイテムを設定します。
	 * 
	 * @param selectItem 選択アイテム
	 */
	public void setSelectItem(ArrayList selectItem) {
		m_selectItem = selectItem;
	}

	public JobTreeItem getJobTreeItem() {
		return m_jobTreeItem;
	}

	public void setJobTreeItem(JobTreeItem jobTreeItem) {
		m_jobTreeItem = jobTreeItem;
	}

}