/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.jobmanagement.bean.ConditionTypeConstant;
import com.clustercontrol.jobmanagement.bean.JobConstant;
import com.clustercontrol.jobmanagement.composite.JobTreeComposite;
import com.clustercontrol.jobmanagement.dialog.JobDialog;
import com.clustercontrol.jobmanagement.util.JobTreeItemUtil;
import com.clustercontrol.jobmanagement.util.JobPropertyUtil;
import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.clustercontrol.ws.jobmanagement.JobWaitRuleInfo;

/**
 * ジョブ[一覧]ビューの「ファイル転送ジョブの作成」のクライアント側アクションクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class CreateFileJobAction implements IViewActionDelegate {
	/** アクションID */
	public static final String ID = "com.clustercontrol.jobmanagement.view.action.CreateFileJobAction";
	/** ビュー */
	protected IViewPart m_view;

	/**
	 * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
	 * 
	 * @param view ビューのインスタンス
	 * 
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	@Override
	public void init(IViewPart view) {
		m_view = view;
	}

	/**
	 * ジョブ[一覧]ビューの「ファイル転送ジョブの作成」が押された場合に、ファイル転送ジョブを作成します。
	 * <p>
	 * <ol>
	 * <li>ジョブ[一覧]ビューから親となるジョブツリーアイテムを取得します。</li>
	 * <li>ファイル転送ジョブ用のジョブ情報を作成し、親のジョブツリーアイテムの子として追加します。</li>
	 * <li>ジョブ[ファイル転送ジョブの作成・変更]ダイアログを表示します。</li>
	 * <li>ジョブ[一覧]ビューを更新します。</li>
	 * </ol>
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 * @see com.clustercontrol.jobmanagement.dialog.JobDialog
	 * @see com.clustercontrol.jobmanagement.view.JobListView
	 * @see com.clustercontrol.jobmanagement.composite.JobTreeComposite
	 */
	@Override
	public void run(IAction action) {
		JobTreeItem item = null;
		JobTreeItem parent = null;

		if (m_view instanceof JobListView) {
			JobListView view = (JobListView) m_view
			.getAdapter(JobListView.class);
			JobTreeComposite tree = view.getJobTreeComposite();
			parent = view.getSelectJobTreeItem();

			if (parent instanceof JobTreeItem) {
				JobInfo jobInfo = new JobInfo();
				jobInfo.setJobunitId(parent.getData().getJobunitId());
				jobInfo.setId("");
				jobInfo.setName("");
				jobInfo.setType(JobConstant.TYPE_FILEJOB);
				item = new JobTreeItem();
				item.setData(jobInfo);
				JobPropertyUtil.setJobFull(item.getData()); // 不要？
				item.getData().setUpdate(true);

				JobWaitRuleInfo jobWaitRuleInfo = new JobWaitRuleInfo();
				jobWaitRuleInfo.setSuspend(YesNoConstant.TYPE_NO);
				jobWaitRuleInfo.setSkip(YesNoConstant.TYPE_NO);
				jobWaitRuleInfo.setSkipEndValue(EndStatusConstant.INITIAL_VALUE_NORMAL);
				jobWaitRuleInfo.setCondition(ConditionTypeConstant.TYPE_AND);
				jobWaitRuleInfo.setEndCondition(YesNoConstant.TYPE_NO);
				jobWaitRuleInfo.setEndValue(EndStatusConstant.INITIAL_VALUE_NORMAL);
				jobWaitRuleInfo.setCalendar(YesNoConstant.TYPE_NO);
				jobWaitRuleInfo.setCalendarEndValue(EndStatusConstant.INITIAL_VALUE_NORMAL);
				jobWaitRuleInfo.setStartDelay(YesNoConstant.TYPE_NO);
				jobWaitRuleInfo.setStartDelaySession(YesNoConstant.TYPE_NO);
				jobWaitRuleInfo.setStartDelaySessionValue(1);
				jobWaitRuleInfo.setStartDelayTime(YesNoConstant.TYPE_NO);
				jobWaitRuleInfo.setStartDelayConditionType(ConditionTypeConstant.TYPE_AND);
				jobWaitRuleInfo.setStartDelayNotify(YesNoConstant.TYPE_NO);
				jobWaitRuleInfo.setStartDelayOperation(YesNoConstant.TYPE_NO);
				jobWaitRuleInfo.setStartDelayOperationEndValue(EndStatusConstant.INITIAL_VALUE_NORMAL);
				jobWaitRuleInfo.setEndDelay(YesNoConstant.TYPE_NO);
				jobWaitRuleInfo.setEndDelaySession(YesNoConstant.TYPE_NO);
				jobWaitRuleInfo.setEndDelaySessionValue(1);
				jobWaitRuleInfo.setEndDelayJob(YesNoConstant.TYPE_NO);
				jobWaitRuleInfo.setEndDelayJobValue(1);
				jobWaitRuleInfo.setEndDelayTime(YesNoConstant.TYPE_NO);
				jobWaitRuleInfo.setEndDelayConditionType(ConditionTypeConstant.TYPE_AND);
				jobWaitRuleInfo.setEndDelayNotify(YesNoConstant.TYPE_NO);
				jobWaitRuleInfo.setEndDelayOperation(YesNoConstant.TYPE_NO);
				jobWaitRuleInfo.setEndDelayOperationEndValue(EndStatusConstant.INITIAL_VALUE_NORMAL);
				jobWaitRuleInfo.setSkipEndStatus(0);
				jobWaitRuleInfo.setEndStatus(0);
				jobWaitRuleInfo.setStartDelayNotifyPriority(0);
				jobWaitRuleInfo.setStartDelayOperationType(0);
				jobWaitRuleInfo.setEndDelayNotifyPriority(0);
				jobWaitRuleInfo.setEndDelayOperationType(0);
				item.getData().setWaitRule(jobWaitRuleInfo);

				JobTreeItemUtil.addChildren(parent, item);

				JobDialog dialog = new JobDialog(
						PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),
						false);
				dialog.setJobTreeItem(item);

				//ダイアログ表示
				if (dialog.open() == IDialogConstants.OK_ID) {
					view.setUpdate(true);
				} else {
					JobTreeItemUtil.removeChildren(parent, item);
				}
				tree.getTreeViewer().refresh(parent);
				tree.getTreeViewer().setSelection(
						new StructuredSelection(parent), true);
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {

	}
}