/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.composite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.notify.action.GetNotify;
import com.clustercontrol.notify.action.GetNotifyTableDefine;
import com.clustercontrol.ws.notify.NotifyInfo;
import com.clustercontrol.ws.notify.NotifyRelationInfo;

/**
 * 通知一覧コンポジットクラス<BR>
 * 
 * TODO
 * com.clustercontrol.notify.composite.NotifyListCompositeと
 * com.clustercontrol.monitor.composite.NotifyListCompositeは
 * ほとんど同じコードなので、集約すること。
 * 
 * @version 3.0.0
 * @since 2.0.0
 */
public class NotifyListComposite extends Composite {

	/** テーブルビューアー。 */
	private CommonTableViewer tableViewer = null;

	/***/
	private boolean isSelect = false;

	private int notifyIdType = 0;

	/**/
	private List<NotifyRelationInfo> notify;

	/**
	 * インスタンスを返します。
	 * <p>
	 * 初期処理を呼び出し、コンポジットを配置します。
	 * 
	 * @param parent 親のコンポジット
	 * @param style スタイル
	 * 
	 * @see org.eclipse.swt.SWT
	 * @see org.eclipse.swt.widgets.Composite#Composite(Composite parent, int style)
	 * @see #initialize()
	 */
	public NotifyListComposite(Composite parent, int style ){
		super(parent, style);

		this.initialize(false);
	}

	/**
	 * インスタンスを返します。
	 * <p>
	 * 初期処理を呼び出し、コンポジットを配置します。
	 * 
	 * @param parent 親のコンポジット
	 * @param style スタイル
	 * 
	 * @see org.eclipse.swt.SWT
	 * @see org.eclipse.swt.widgets.Composite#Composite(Composite parent, int style)
	 * @see #initialize()
	 */
	public NotifyListComposite(Composite parent, int style,boolean flg) {
		super(parent, style);

		this.initialize(flg);
	}

	public NotifyListComposite(Composite parent, int style,boolean flg, int notifyIdType) {
		super(parent, style);

		this.notifyIdType = notifyIdType;
		this.initialize(flg);
	}

	/**
	 * コンポジットを配置します。
	 * 
	 * @see com.clustercontrol.notify.action.GetNotifyTableDefine#get()
	 * @see #update()
	 */
	private void initialize(boolean flg) {
		GridLayout layout = new GridLayout(1, true);
		this.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;

		final Table table = new Table(this, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL
				| SWT.FULL_SELECTION);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		table.setLayoutData(gridData);

		// テーブルビューアの作成
		this.tableViewer = new CommonTableViewer(table);
		this.tableViewer.createTableColumn(GetNotifyTableDefine.get(),
				GetNotifyTableDefine.SORT_COLUMN_INDEX,
				GetNotifyTableDefine.SORT_ORDER);

		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;


		if(flg){

			isSelect =flg;

			/**テーブルのレコードを選択するリスナー*/
			table.addSelectionListener(new SelectionAdapter(){
				@Override
				public void widgetSelected(SelectionEvent e) {

					ArrayList al;
					//選択されたTableColumnを取得します。
					TableItem[] ti = table.getSelection();
					String notifyId;
					for (int i = 0; i<ti.length; i++){
						al = (ArrayList)ti[i].getData();
						if((Boolean)al.get(0)){
							//YESならNO
							al.set(GetNotifyTableDefine.SELECTION, YesNoConstant.BOOLEAN_NO);
						}else{
							//NOならYES
							al.set(GetNotifyTableDefine.SELECTION, YesNoConstant.BOOLEAN_YES);

						}
					}
					//チェックボックスが入るので、再描画。
					tableViewer.refresh();
				}
			});
		}

		this.update();
	}

	/**
	 * このコンポジットが利用するテーブルビューアーを返します。
	 * 
	 * @return テーブルビューアー
	 */
	public CommonTableViewer getTableViewer() {
		return this.tableViewer;
	}

	/**
	 * コンポジットを更新します。<BR>
	 * 通知一覧情報を取得し、テーブルビューアーにセットします。
	 * 
	 * @see com.clustercontrol.notify.action.GetNotify#getNotifyList()
	 */
	@Override
	public void update() {

		// 通知一覧をマネージャから取得
		List<NotifyInfo> list = null;
		ArrayList<ArrayList<Object>> listInput = new ArrayList<ArrayList<Object>>();

		list = new GetNotify().getNotifyList();
		for(NotifyInfo info : list){
			ArrayList<Object> a = new ArrayList<Object>();
			a.add(YesNoConstant.BOOLEAN_NO);
			a.add(info.getValidFlg());
			a.add(info.getNotifyId());
			a.add(info.getDescription());
			a.add(info.getNotifyType());
			a.add(info.getRegUser());
			a.add(new Date(info.getRegDate()));
			a.add(info.getUpdateUser());
			a.add(new Date(info.getUpdateDate()));
			listInput.add(a);
		}

		if(notify == null){
			//変更でない場合などはnotifyを初期化する。
			notify = new ArrayList<NotifyRelationInfo>();
		}


		if(list == null)
		{
			//通知一覧に設定されている通知がない場合
			list = new ArrayList<NotifyInfo>();

		}else if(isSelect){
			//素の通知一覧ではなく、監視から選択可能な通知一覧の場合
			String tableNotifyId;
			boolean flg = false;

			//変更の通知を通知一覧のチェックボックスに表示させる。
			Iterator<NotifyRelationInfo> it = notify.iterator();
			NotifyRelationInfo nri = null ;
			while(it.hasNext()){
				nri = it.next();
				nri.setNotifyGroupId(null);
				flg = false;

				for(int i = 0; i < list.size(); i++){
					NotifyInfo info = list.get(i);
					ArrayList<Object> objList = listInput.get(i);
					tableNotifyId = info.getNotifyId();

					if(tableNotifyId.equals(nri.getNotifyId())){
						objList.set(GetNotifyTableDefine.SELECTION, YesNoConstant.BOOLEAN_YES);
						flg=true;
					}
					objList.set(GetNotifyTableDefine.VALID_FLG, info.getValidFlg());
					objList.set(GetNotifyTableDefine.NOTIFY_ID, info.getNotifyId());
					objList.set(GetNotifyTableDefine.DESCRIPTION, info.getDescription());
					objList.set(GetNotifyTableDefine.NOTIFY_TYPE, info.getNotifyType());
					objList.set(GetNotifyTableDefine.CREATE_USER, info.getRegUser());
					objList.set(GetNotifyTableDefine.CREATE_TIME, new Date(info.getRegDate()));
					objList.set(GetNotifyTableDefine.UPDATE_USER, info.getUpdateUser());
					objList.set(GetNotifyTableDefine.UPDATE_TIME, new Date(info.getUpdateDate()));
					listInput.set(i, objList);
				}

				if(!flg){
					//通知一覧になければ、設定済み通知からも削除
					if(nri != null){
						notify.remove(nri);
					}
				}
			}
		}
		// テーブル更新
		this.tableViewer.setInput(listInput);
	}


	/**
	 * 監視に設定されている通知情報をセットします。
	 * 
	 * @param notify
	 */
	public void setSelectNotify(List<NotifyRelationInfo> notify){

		if(notify != null){
			this.notify =  new ArrayList<NotifyRelationInfo>();
		}
		this.notify = notify;
	}

	/**
	 * 監視に設定する通知情報を返します。
	 * 
	 * @return 通知情報のコレクション
	 */
	public List<NotifyRelationInfo> getSelectNotify(){
		return notify;
	}

	/**
	 * OKが押されたときに監視に設定する通知情報を
	 * 生成します。
	 * 
	 */
	public boolean makeNotifyData(){

		TableItem[] ti = this.tableViewer.getTable().getItems();
		ArrayList<Object> al;
		Collection<NotifyRelationInfo> ct = new ArrayList<NotifyRelationInfo>();;

		for (int i = 0; i<ti.length; i++){
			al = (ArrayList<Object>)ti[i].getData();

			if((Boolean)al.get(GetNotifyTableDefine.SELECTION)){

				NotifyRelationInfo nri = new NotifyRelationInfo();
				nri.setNotifyGroupId(null);
				nri.setNotifyId((String)al.get(GetNotifyTableDefine.NOTIFY_ID));
				nri.setNotifyType((Integer)al.get(GetNotifyTableDefine.NOTIFY_TYPE));
				nri.setNotifyFlg(0);

				ct.add(nri);
			}
		}

		// 通知情報の設定
		notify.clear();
		notify.addAll(ct);
		return true;

	}

	/**
	 * 選択された行の通知IDを取得する
	 * 
	 * @return
	 */
	public ArrayList<String> getSelectionData() {

		ArrayList<String> data = new ArrayList<String>();

		//選択されたアイテムを取得
		StructuredSelection selection =
			(StructuredSelection)tableViewer.getSelection();
		List list = selection.toList();

		if (list != null) {

			for(int index = 0; index < list.size(); index++){

				ArrayList info = (ArrayList)list.get(index);
				if (info != null && info.size() > 0) {
					String notifyId = (String)info.get(GetNotifyTableDefine.NOTIFY_ID);
					data.add(notifyId);
				}
			}
		}

		return data;
	}
}