/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.view.action;

import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.monitor.action.NotifyTableDefineNoCheckBox;
import com.clustercontrol.monitor.composite.NotifyListComposite;
import com.clustercontrol.notify.action.DeleteNotify;
import com.clustercontrol.notify.view.NotifyListView;
import com.clustercontrol.util.Messages;

/**
 * 通知[一覧]ビューの削除アクションクラス<BR>
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class NotifyDeleteAction implements IViewActionDelegate {

	/** アクションID */
	public static final String ID = "com.clustercontrol.monitor.view.action.NotifyDeleteAction";

	/** ビュー */
	private IViewPart viewPart;


	@Override
	public void run(IAction action) {
		// 選択アイテムの取得
		NotifyListView view = (NotifyListView) this.viewPart.getAdapter(NotifyListView.class);

		NotifyListComposite composite = (NotifyListComposite) view.getListComposite();
		StructuredSelection selection = (StructuredSelection) composite.getTableViewer().getSelection();

		List list = (List) selection.getFirstElement();
		String notifyId = null;
		if(list != null && list.size() > 0){
			notifyId = (String) list.get(NotifyTableDefineNoCheckBox.NOTIFY_ID);
		}

		String[] args = { notifyId };

		// 選択アイテムがある場合に、削除処理を呼び出す
		if(notifyId != null){
			DeleteNotify deleteNotify = new DeleteNotify();

			if(deleteNotify.useCheck(notifyId) == Window.OK){ // 対象の通知IDがどの監視で使用されているかを確認

				if (MessageDialog.openConfirm(
						null,
						Messages.getString("confirmed"),
						Messages.getString("message.notify.7", args))) {

					boolean result = deleteNotify.delete(notifyId);
					if(result){
						composite.update();
					}
				}
			}
		}
		else{
			MessageDialog.openWarning(
					null,
					Messages.getString("warning"),
					Messages.getString("message.notify.9"));
		}
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		// TODO Auto-generated method stub

	}

	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

}
