/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.bean;

import com.clustercontrol.util.Messages;

/**
 * Hinemosの機能を定数として格納するクラス<BR>
 *
 * @version 4.0.0
 * @since 2.1.2
 */
public class HinemosModuleConstant {


	/** 共通プラットフォーム*/
	public static final String PLATFORM  = "PLT";
	/** 通知 */
	public static final String PLATFORM_NOTIFY = "PLT_NTF";
	/** メールテンプレート*/
	public static final String PLATFORM_MAIL_TEMPLATE = "PLT_MIL_TMP";
	/** ログ転送 */
	public static final String PLATFORM_LOG_TRANSFER = "PLT_LOG_TRF";
	/** カレンダ */
	public static final String PLATFORM_CALENDAR = "PLT_CAL";
	/** アクセス */
	public static final String PLATFORM_ACCESS 	= "PLT_ACC";
	/** 重要度判定 */
	public static final String PLATFORM_PRIORITY_JUDGMENT = "PLT_PRI_JMT";
	/** リポジトリ */
	public static final String PLATFORM_REPOSITORY = "PLT_REP";

	/** リポジトリ */
	public static final String PLATFORM_REPSITORY_NODE = "PLT_REP_NOD";
	/** リポジトリ */
	public static final String PLATFORM_REPSITORY_SCOPE = "PLT_REP_SCP";

	/** 一括制御 */
	public static final String COLLECTIVERUN ="CRN";
	/** 一括制御 */
	public static final String COLLECTIVERUN_MST = "CRN_MST";
	/** 一括制御 */
	public static final String COLLECTIVERUN_PARAM = "CRN_PRM";
	/** 一括制御 */
	public static final String COLLECTIVERUN_SESSION = "CRN_SES";
	/** 一括制御 */
	public static final String COLLECTIVERUN_SESSION_DETAIL = "CRN_SES_DTL";

	/** 監視管理 */
	public static final String MONITOR = "MON";
	/** Hinemosエージェント監視 */
	public static final String MONITOR_AGENT = "MON_AGT";
	/** カスタム監視 */
	public static final String MONITOR_CUSTOM = "MON_CUSTOM";
	/** HTTP監視 */
	public static final String MONITOR_HTTP = "MON_HTP";
	/** リソース監視 */
	public static final String MONITOR_PERFORMANCE = "MON_PRF";
	/** PING監視 */
	public static final String MONITOR_PING = "MON_PNG";
	/** サービス・ポート監視 */
	public static final String MONITOR_PORT = "MON_PRT";
	/** プロセス監視 */
	public static final String MONITOR_PROCESS = "MON_PRC";
	/** SNMP監視 */
	public static final String MONITOR_SNMP = "MON_SNMP";
	/** SNMPTRAP監視 */
	public static final String MONITOR_SNMPTRAP = "MON_SNMP_TRP";
	/** SQL監視 */
	public static final String MONITOR_SQL = "MON_SQL";
	/** システムログ監視 */
	public static final String MONITOR_SYSTEMLOG = "MON_SYSLOG";
	/** ログファイル監視 */
	public static final String MONITOR_LOGFILE = "MON_LOGFILE";
	/** Windowsサービス監視 */
	public static final String MONITOR_WINSERVICE = "MON_WINSERVICE";
	/** スコープ */
	public static final String MONITOR_SCOPE = "MON_SCP";
	/** ステータス */
	public static final String MONITOR_STATUS = "MON_STA";
	/** イベント */
	public static final String MONITOR_EVENT = "MON_EVT";

	/** 性能管理 */
	public static final String PERFORMANCE = "PRF";
	/** 性能管理 */
	public static final String PERFORMANCE_RECORD = "PRF_REC";
	/** 性能管理 */
	public static final String PERFORMANCE_REALTIME = "PRT_RT";

	/** ジョブ管理 */
	public static final String JOB = "JOB";
	/** ジョブ管理 */
	public static final String JOB_MST  = "JOB_MST";
	/** ジョブ管理 */
	public static final String JOB_SESSION = "JOB_SES";
	/** ジョブ管理 */
	public static final String JOB_SESSION_DETAIL = "JOB_SES_DTL";
	/** ジョブ管理 */
	public static final String JOB_SESSION_NODE = "JOB_SES_NOD";
	/** ジョブ管理 */
	public static final String JOB_SCHEDULE  = "JOB_SCH";
	/** ジョブ管理 */
	public static final String JOB_SCHEDULE_RUN  = "JOB_SCH_RUN";
	/** ジョブ管理 */
	public static final String JOB_SCHEDULE_RUN_DETAIL  = "JOB_SCH_RUN_DTL";
	/** ジョブ管理 */
	public static final String JOB_SESSION_FILE = "JOB_SES_FIL";

	/**Hinemos自身の処理*/
	public static final String SYSYTEM = "SYS";
	/** 障害検知 */
	public static final String SYSYTEM_TROUBLE_DETECTION = "SYS_TD";
	/** メンテナンス */
	public static final String SYSYTEM_MAINTENANCE = "SYS_MTN";
	/** セルフチェック */
	public static final String SYSYTEM_SELFCHECK = "SYS_SFC";
	/** セルフチェックのデフォルトID */
	public static final String SYSYTEM_SELFCHECK_ID = "DEFAULT";


	/** 共通プラットフォーム*/
	public static final int TYPE_PLATFORM  = 100;
	/** 通知 */
	public static final int TYPE_PLATFORM_NOTIFY = 101;
	/** メールテンプレート*/
	public static final int TYPE_PLATFORM_MAIL_TEMPLATE = 102;
	/** ログ転送 */
	public static final int TYPE_PLATFORM_LOG_TRANSFER = 103;
	/** カレンダ */
	public static final int TYPE_PLATFORM_CALENDAR = 104;
	/** アクセス */
	public static final int TYPE_PLATFORM_ACCESS 	= 105;
	/** 重要度判定 */
	public static final int TYPE_PLATFORM_PRIORITY_JUDGMENT = 106;
	/** リポジトリ */
	public static final int TYPE_PLATFORM_REPOSITORY = 107;

	/** リポジトリ */
	public static final int TYPE_PLATFORM_REPSITORY_NODE = 111;
	/** リポジトリ */
	public static final int TYPE_PLATFORM_REPSITORY_SCOPE = 112;

	/** 一括制御 */
	public static final int TYPE_COLLECTIVERUN = 200;
	/** 一括制御 */
	public static final int TYPE_COLLECTIVERUN_MST = 201;
	/** 一括制御 */
	public static final int TYPE_COLLECTIVERUN_PARAM = 202;
	/** 一括制御 */
	public static final int TYPE_COLLECTIVERUN_SESSION = 203;
	/** 一括制御 */
	public static final int TYPE_COLLECTIVERUN_SESSION_DETAIL = 204;

	/** 監視管理 */
	public static final int TYPE_MONITOR = 300;
	/** Hinemosエージェント監視 */
	public static final int TYPE_MONITOR_AGENT = 301;
	/** カスタム監視 */
	public static final int TYPE_MONITOR_CUSTOM = 311;
	/** HTTP監視 */
	public static final int TYPE_MONITOR_HTTP = 302;
	/** リソース監視 */
	public static final int TYPE_MONITOR_PERFORMANCE = 303;
	/** PING監視 */
	public static final int TYPE_MONITOR_PING = 304;
	/** サービス・ポート監視 */
	public static final int TYPE_MONITOR_PORT = 305;
	/** プロセス監視 */
	public static final int TYPE_MONITOR_PROCESS = 306;
	/** SNMP監視 */
	public static final int TYPE_MONITOR_SNMP = 307;
	/** SNMPTRAP監視 */
	public static final int TYPE_MONITOR_SNMPTRAP = 308;
	/** SQL監視 */
	public static final int TYPE_MONITOR_SQL = 309;
	/** システムログ監視 */
	public static final int TYPE_MONITOR_SYSTEMLOG = 310;
	/** ログファイル監視 */
	public static final int TYPE_MONITOR_LOGFILE = 311;
	/** Windowsサービス監視 */
	public static final int TYPE_MONITOR_WINSERVICE = 312;
	/** スコープ */
	public static final int TYPE_MONITOR_SCOPE = 391;
	/** ステータス */
	public static final int TYPE_MONITOR_STATUS = 392;
	/** イベント */
	public static final int TYPE_MONITOR_EVENT = 393;

	/** 性能管理 */
	public static final int TYPE_PERFORMANCE = 400;
	/** 性能管理 */
	public static final int TYPE_PERFORMANCE_RECORD = 401;
	/** 性能管理 */
	public static final int TYPE_PERFORMANCE_REALTIME = 402;

	/** ジョブ管理 */
	public static final int TYPE_JOB = 500;
	/** ジョブ管理 */
	public static final int TYPE_JOB_MST  = 501;
	/** ジョブ管理 */
	public static final int TYPE_JOB_SESSION = 502;
	/** ジョブ管理 */
	public static final int TYPE_JOB_SESSION_DETAIL = 503;
	/** ジョブ管理 */
	public static final int TYPE_JOB_SESSION_NODE = 504;
	/** ジョブ管理 */
	public static final int TYPE_JOB_SCHEDULE  = 505;
	/** ジョブ管理 */
	public static final int TYPE_JOB_SCHEDULE_RUN  = 506;
	/** ジョブ管理 */
	public static final int TYPE_JOB_SCHEDULE_DETAIL  = 507;
	/** ジョブ管理 */
	public static final int TYPE_JOB_SESSION_FILE = 508;

	/**Hinemos自身の書処理*/
	public static final int TYPE_SYSYTEM =600;
	/** 障害検知 */
	public static final int TYPE_SYSYTEM_TROUBLE_DETECTION = 601;
	/** メンテナンス */
	public static final int TYPE_SYSYTEM_MAINTENANCE = 602;
	/** セルフチェック */
	public static final int TYPE_SYSYTEM_SELFCHECK = 603;


	/** リポジトリ */
	public static final String STRING_PLATFORM_REPOSITORY = Messages.getString("repository");
	/** アクセス */
	public static final String STRING_PLATFORM_ACCESS = Messages.getString("accesscontrol");
	/** カレンダ */
	public static final String STRING_PLATFORM_CALENDAR = Messages.getString("calendar");
	/** 通知 */
	public static final String STRING_PLATFORM_NOTIFY = Messages.getString("notify.id");
	/** 重要度判定 */
	public static final String STRING_PLATFORM_PRIORITY_JUDGMENT = Messages.getString("priority.judgment");
	/** ログ転送 */
	public static final String STRING_PLATFORM_LOG_TRANSFER = Messages.getString("logtransfer");
	/** 一括制御 */
	public static final String STRING_COLLECTIVERUN = Messages.getString("collective.run");
	/** 監視管理 */
	public static final String STRING_MONITOR = Messages.getString("monitor");
	/** システムログ監視 */
	public static final String STRING_MONITOR_SYSTEMLOG = Messages.getString("systemlog.monitor");
	/** ログファイル監視 */
	public static final String STRING_MONITOR_LOGFILE = Messages.getString("logfile.monitor");
	/** Hinemosエージェント監視 */
	public static final String STRING_MONITOR_AGENT = Messages.getString("agent.monitor");
	/** コマンド監視 */
	public static final String STRING_MONITOR_CUSTOM = Messages.getString("command.monitor");
	/** HTTP監視 */
	public static final String STRING_MONITOR_HTTP = Messages.getString("http.monitor");
	/** プロセス監視 */
	public static final String STRING_MONITOR_PROCESS = Messages.getString("process.monitor");
	/** SQL監視 */
	public static final String STRING_MONITOR_SQL = Messages.getString("sql.monitor");
	/** SNMP監視 */
	public static final String STRING_MONITOR_SNMP = Messages.getString("snmp.monitor");
	/** PING監視 */
	public static final String STRING_MONITOR_PING = Messages.getString("ping.monitor");
	/** SNMPTRAP監視 */
	public static final String STRING_MONITOR_SNMPTRAP = Messages.getString("snmptrap.monitor");
	/** リソース監視 */
	public static final String STRING_MONITOR_PERFORMANCE = Messages.getString("performance.monitor");
	/** サービス・ポート監視 */
	public static final String STRING_MONITOR_PORT = Messages.getString("port.monitor");
	/** Windowsサービス監視 */
	public static final String STRING_MONITOR_WINSERVICE = Messages.getString("winservice.monitor");
	/** 性能管理 */
	public static final String STRING_PERFORMANCE = Messages.getString("performance");
	/** ジョブ管理 */
	public static final String STRING_JOB = Messages.getString("job.management");
	/** ジョブ管理 */
	public static final String STRING_JOB_MST = Messages.getString("job.management");

	/** 障害検知 */
	public static final String STRING_SYSYTEM_TROUBLE_DETECTION = Messages.getString("trouble.detection");
	/** メンテナンス */
	public static final String STRING_SYSYTEM_MAINTENANCE = Messages.getString("maintenance.name");
	/** セルフチェック */
	public static final String STRING_SYSYTEM_SELFCHECK = Messages.getString("selfcheck.name");

	/** マネージャ操作ログタイトル */
	/** リポジトリ */
	public static final String LOG_PREFIX_REPOSITORY = "[Repository]";
	/** アクセス */
	public static final String LOG_PREFIX_ACCESS = "[Access]";
	/** カレンダ */
	public static final String LOG_PREFIX_CALENDAR = "[Calendar]";
	/** 通知 */
	public static final String LOG_PREFIX_NOTIFY = "[Notify]";
	/** 一括制御 */
	public static final String LOG_PREFIX_COLLECTIVERUN = "[CollectiveRun]";
	/** 監視管理 */
	public static final String LOG_PREFIX_MONITOR = "[Monitor]";
	/** システムログ監視 */
	public static final String LOG_PREFIX_MONITOR_SYSTEMLOG = "[Systemlog]";
	/** ログファイル監視 */
	public static final String LOG_PREFIX_MONITOR_LOGFILE = "[Logfile]";
	/** Hinemosエージェント監視 */
	public static final String LOG_PREFIX_MONITOR_AGENT = "[Agent]";
	/** コマンド監視 */
	public static final String LOG_PREFIX_MONITOR_CUSTOM = "[Custom]";
	/** HTTP監視 */
	public static final String LOG_PREFIX_MONITOR_HTTP = "[Http]";
	/** プロセス監視 */
	public static final String LOG_PREFIX_MONITOR_PROCESS = "[Process]";
	/** SQL監視 */
	public static final String LOG_PREFIX_MONITOR_SQL = "[Sql]";
	/** SNMP監視 */
	public static final String LOG_PREFIX_MONITOR_SNMP = "[Snmp]";
	/** PING監視 */
	public static final String LOG_PREFIX_MONITOR_PING = "[Ping]";
	/** SNMPTRAP監視 */
	public static final String LOG_PREFIX_MONITOR_SNMPTRAP = "[Snmptrap]";
	/** リソース監視 */
	public static final String LOG_PREFIX_MONITOR_PERFORMANCE = "[Resource]";
	/** サービス・ポート監視 */
	public static final String LOG_PREFIX_MONITOR_PORT = "[Port]";
	/** Windowsサービス監視 */
	public static final String LOG_PREFIX_MONITOR_WINSERVICE = "[WinService]";
	/** 性能管理 */
	public static final String LOG_PREFIX_PERFORMANCE = "[Collector]";
	/** ジョブ管理 */
	public static final String LOG_PREFIX_JOB = "[Job]";
	/** メンテナンス */
	public static final String LOG_PREFIX_MAINTENANCE = "[Maintenance]";
	/** メールテンプレート */
	public static final String LOG_PREFIX_MAIL_TEMPLATE = "[MailTemplate]";
	/** ノードマップ */
	public static final String LOG_PREFIX_NODEMAP = "[NodeMap]";
	/** 仮想化管理 */
	public static final String LOG_PREFIX_VM = "[VM]";


	/**
	 * 機能略記が存在するかチェックします。
	 * 
	 * 
	 */
	public static boolean isExist(String typeId){

		if(typeId.equals(PLATFORM) ||
				typeId.equals(PLATFORM_NOTIFY) ||
				typeId.equals(PLATFORM_MAIL_TEMPLATE) ||
				typeId.equals(PLATFORM_LOG_TRANSFER) ||
				typeId.equals(PLATFORM_CALENDAR) ||
				typeId.equals(PLATFORM_ACCESS) ||
				typeId.equals(PLATFORM_PRIORITY_JUDGMENT) ||
				typeId.equals(PLATFORM_REPOSITORY) ||
				typeId.equals(PLATFORM_REPSITORY_NODE) ||
				typeId.equals(PLATFORM_REPSITORY_SCOPE) ||
				typeId.equals(COLLECTIVERUN) ||
				typeId.equals(COLLECTIVERUN_MST) ||
				typeId.equals(COLLECTIVERUN_PARAM) ||
				typeId.equals(COLLECTIVERUN_SESSION ) ||
				typeId.equals(COLLECTIVERUN_SESSION_DETAIL) ||
				typeId.equals(MONITOR) ||
				typeId.equals(MONITOR_AGENT ) ||
				typeId.equals(MONITOR_CUSTOM) ||
				typeId.equals(MONITOR_HTTP) ||
				typeId.equals(MONITOR_LOGFILE) ||
				typeId.equals(MONITOR_PERFORMANCE) ||
				typeId.equals(MONITOR_PING) ||
				typeId.equals(MONITOR_PORT ) ||
				typeId.equals(MONITOR_PROCESS) ||
				typeId.equals(MONITOR_SNMP ) ||
				typeId.equals(MONITOR_SNMPTRAP) ||
				typeId.equals(MONITOR_SQL ) ||
				typeId.equals(MONITOR_SYSTEMLOG) ||
				typeId.equals(MONITOR_SCOPE) ||
				typeId.equals(MONITOR_STATUS) ||
				typeId.equals(MONITOR_EVENT) ||
				typeId.equals(MONITOR_WINSERVICE) ||
				typeId.equals(PERFORMANCE) ||
				typeId.equals(PERFORMANCE_RECORD) ||
				typeId.equals(PERFORMANCE_REALTIME) ||
				typeId.equals(JOB ) ||
				typeId.equals(JOB_MST ) ||
				typeId.equals(JOB_SESSION) ||
				typeId.equals(JOB_SESSION_DETAIL) ||
				typeId.equals(JOB_SESSION_NODE) ||
				typeId.equals(JOB_SCHEDULE) ||
				typeId.equals(JOB_SCHEDULE_RUN_DETAIL) ||
				typeId.equals(JOB_SESSION_FILE ) ||
				typeId.equals(SYSYTEM ) ||
				typeId.equals(SYSYTEM_TROUBLE_DETECTION ) ||
				typeId.equals(SYSYTEM_MAINTENANCE) ||
				typeId.equals(SYSYTEM_SELFCHECK)){

			return true;
		}else
			return false;

	}


	/**
	 * 種別から文字列に変換します。<BR>
	 * 
	 * @param type
	 * @return
	 */
	public static String typeToString(int type) {
		if (type == TYPE_PLATFORM_ACCESS) {
			return STRING_PLATFORM_ACCESS;
		} else if (type == TYPE_PLATFORM_NOTIFY) {
			return STRING_PLATFORM_NOTIFY;
		} else if (type == TYPE_PLATFORM_CALENDAR) {
			return STRING_PLATFORM_CALENDAR;
		} else if (type == TYPE_PLATFORM_PRIORITY_JUDGMENT) {
			return STRING_PLATFORM_PRIORITY_JUDGMENT;
		} else if (type == TYPE_PLATFORM_LOG_TRANSFER) {
			return STRING_PLATFORM_LOG_TRANSFER;
		} else if (type == TYPE_PLATFORM_REPOSITORY) {
			return STRING_PLATFORM_REPOSITORY;
		} else if (type == TYPE_COLLECTIVERUN) {
			return STRING_COLLECTIVERUN;
		} else if (type == TYPE_MONITOR) {
			return STRING_MONITOR;
		} else if (type == TYPE_MONITOR_AGENT) {
			return STRING_MONITOR_AGENT;
		} else if (type == TYPE_MONITOR_CUSTOM) {
			return STRING_MONITOR_CUSTOM;
		} else if (type == TYPE_MONITOR_HTTP) {
			return STRING_MONITOR_HTTP;
		} else if (type == TYPE_MONITOR_LOGFILE) {
			return STRING_MONITOR_LOGFILE;
		} else if (type == TYPE_MONITOR_PING) {
			return STRING_MONITOR_PING;
		} else if (type == TYPE_MONITOR_PROCESS) {
			return STRING_MONITOR_PROCESS;
		} else if (type == TYPE_MONITOR_SNMP) {
			return STRING_MONITOR_SNMP;
		} else if (type == TYPE_MONITOR_SNMPTRAP) {
			return STRING_MONITOR_SNMPTRAP;
		} else if (type == TYPE_MONITOR_SQL) {
			return STRING_MONITOR_SQL;
		} else if (type == TYPE_MONITOR_SYSTEMLOG) {
			return STRING_MONITOR_SYSTEMLOG;
		} else if (type == TYPE_MONITOR_PERFORMANCE) {
			return STRING_MONITOR_PERFORMANCE;
		} else if (type == TYPE_MONITOR_PORT) {
			return STRING_MONITOR_PORT;
		} else if (type == TYPE_MONITOR_WINSERVICE) {
			return STRING_MONITOR_WINSERVICE;
		} else if (type == TYPE_PERFORMANCE) {
			return STRING_PERFORMANCE;
		} else if (type == TYPE_JOB) {
			return STRING_JOB;
		} else if (type == TYPE_JOB_MST) {
			return STRING_JOB_MST;
		} else if (type == TYPE_SYSYTEM_TROUBLE_DETECTION) {
			return STRING_SYSYTEM_TROUBLE_DETECTION;
		} else if (type == TYPE_SYSYTEM_MAINTENANCE) {
			return STRING_SYSYTEM_MAINTENANCE;
		} else if (type == TYPE_SYSYTEM_SELFCHECK) {
			return STRING_SYSYTEM_SELFCHECK;
		}
		return "";
	}

	/**
	 * 文字列から種別に変換します。<BR>
	 * 
	 * @param type
	 * @return
	 */
	public static int stringToType(String string) {
		if (string.equals(STRING_PLATFORM_ACCESS)) {
			return TYPE_PLATFORM_ACCESS;
		} else if (string.equals(STRING_PLATFORM_PRIORITY_JUDGMENT)) {
			return TYPE_PLATFORM_PRIORITY_JUDGMENT;
		} else if (string.equals(STRING_PLATFORM_CALENDAR)) {
			return TYPE_PLATFORM_CALENDAR;
		} else if (string.equals(STRING_PLATFORM_LOG_TRANSFER)) {
			return TYPE_PLATFORM_LOG_TRANSFER;
		} else if (string.equals(STRING_PLATFORM_REPOSITORY)) {
			return TYPE_PLATFORM_REPOSITORY;
		} else if (string.equals(STRING_PLATFORM_NOTIFY)) {
			return TYPE_PLATFORM_NOTIFY;
		} else if (string.equals(STRING_COLLECTIVERUN)) {
			return TYPE_COLLECTIVERUN;
		} else if (string.equals(STRING_MONITOR)) {
			return TYPE_MONITOR;
		} else if (string.equals(STRING_MONITOR_AGENT)) {
			return TYPE_MONITOR_AGENT;
		} else if (string.equals(STRING_MONITOR_CUSTOM)) {
			return TYPE_MONITOR_CUSTOM;
		} else if (string.equals(STRING_MONITOR_HTTP)) {
			return TYPE_MONITOR_HTTP;
		} else if (string.equals(STRING_MONITOR_LOGFILE)) {
			return TYPE_MONITOR_LOGFILE;
		} else if (string.equals(STRING_MONITOR_PING)) {
			return TYPE_MONITOR_PING;
		} else if (string.equals(STRING_MONITOR_PROCESS)) {
			return TYPE_MONITOR_PROCESS;
		} else if (string.equals(STRING_MONITOR_SNMP)) {
			return TYPE_MONITOR_SNMP;
		} else if (string.equals(STRING_MONITOR_SNMPTRAP)) {
			return TYPE_MONITOR_SNMPTRAP;
		} else if (string.equals(STRING_MONITOR_SQL)) {
			return TYPE_MONITOR_SQL;
		} else if (string.equals(STRING_MONITOR_PERFORMANCE)) {
			return TYPE_MONITOR_PERFORMANCE;
		} else if (string.equals(STRING_MONITOR_PORT)) {
			return TYPE_MONITOR_PORT;
		} else if (string.equals(STRING_MONITOR_WINSERVICE)) {
			return TYPE_MONITOR_WINSERVICE;
		} else if (string.equals(STRING_MONITOR_SYSTEMLOG)) {
			return TYPE_MONITOR_SYSTEMLOG;
		} else if (string.equals(STRING_PERFORMANCE)) {
			return TYPE_PERFORMANCE;
		} else if (string.equals(STRING_JOB)) {
			return TYPE_JOB;
		} else if (string.equals(STRING_JOB_MST)) {
			return TYPE_JOB_MST;
		} else if (string.equals(STRING_SYSYTEM_TROUBLE_DETECTION)) {
			return TYPE_SYSYTEM_TROUBLE_DETECTION;
		} else if (string.equals(STRING_SYSYTEM_MAINTENANCE)) {
			return TYPE_SYSYTEM_MAINTENANCE;
		} else if (string.equals(STRING_SYSYTEM_SELFCHECK)) {
			return TYPE_SYSYTEM_SELFCHECK;
		}
		return -1;
	}


	/**
	 * 名前から文字列に変換します。<BR>
	 * 
	 * @param string
	 * @return
	 */
	public static String nameToString(String string) {
		if (string.equals(PLATFORM_ACCESS)) {
			return STRING_PLATFORM_ACCESS;
		} else if (string.equals(PLATFORM_PRIORITY_JUDGMENT)) {
			return STRING_PLATFORM_PRIORITY_JUDGMENT;
		} else if (string.equals(PLATFORM_CALENDAR)) {
			return STRING_PLATFORM_CALENDAR;
		} else if (string.equals(PLATFORM_LOG_TRANSFER)) {
			return STRING_PLATFORM_LOG_TRANSFER;
		} else if (string.equals(PLATFORM_REPOSITORY)) {
			return STRING_PLATFORM_REPOSITORY;
		} else if (string.equals(PLATFORM_NOTIFY)) {
			return STRING_PLATFORM_NOTIFY;
		} else if (string.equals(COLLECTIVERUN)) {
			return STRING_COLLECTIVERUN;
		} else if (string.equals(MONITOR)) {
			return STRING_MONITOR;
		} else if (string.equals(MONITOR_AGENT)) {
			return STRING_MONITOR_AGENT;
		} else if (string.equals(MONITOR_CUSTOM)) {
			return STRING_MONITOR_CUSTOM;
		} else if (string.equals(MONITOR_HTTP)) {
			return STRING_MONITOR_HTTP;
		} else if (string.equals(MONITOR_PING)) {
			return STRING_MONITOR_PING;
		} else if (string.equals(MONITOR_PROCESS)) {
			return STRING_MONITOR_PROCESS;
		} else if (string.equals(MONITOR_SNMP)) {
			return STRING_MONITOR_SNMP;
		} else if (string.equals(MONITOR_SNMPTRAP)) {
			return STRING_MONITOR_SNMPTRAP;
		} else if (string.equals(MONITOR_SQL)) {
			return STRING_MONITOR_SQL;
		} else if (string.equals(MONITOR_PERFORMANCE)) {
			return STRING_MONITOR_PERFORMANCE;
		} else if (string.equals(MONITOR_PORT)) {
			return STRING_MONITOR_PORT;
		} else if (string.equals(MONITOR_WINSERVICE)) {
			return STRING_MONITOR_WINSERVICE;
		} else if (string.equals(MONITOR_SYSTEMLOG)) {
			return STRING_MONITOR_SYSTEMLOG;
		} else if (string.equals(PERFORMANCE)) {
			return STRING_PERFORMANCE;
		} else if (string.equals(JOB)) {
			return STRING_JOB;
		} else if (string.equals(JOB_MST)) {
			return STRING_JOB_MST;
		} else if (string.equals(SYSYTEM_TROUBLE_DETECTION)) {
			return STRING_SYSYTEM_TROUBLE_DETECTION;
		} else if (string.equals(SYSYTEM_MAINTENANCE)) {
			return STRING_SYSYTEM_MAINTENANCE;
		} else if (string.equals(SYSYTEM_SELFCHECK)) {
			return STRING_SYSYTEM_SELFCHECK;
		}
		return "";
	}
}
