/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.bean;

import java.util.ArrayList;


/**
 * 通知で利用するキューの定義を定数として格納するクラス<BR>
 * 
 * 通知では1つのQueueから5つのQueueに処理を振り分けます。
 * 
 * <li>
 * 　通知振り分け用キュー
 * 　ステータス出力用キュー
 *　 イベント出力キュー
 *  メール送信用キュー
 *  ジョブ実行用キュー
 *  ログエスカレーション用キュー
 * </li>
 * 
 * 
 * @version 3.0.0
 * @since 3.0.0
 */
public class QueueConstant {

	/** 通知振り分け用キュー */
	public static final String QUEUE_NAME_NOTIFYCONTROL = "queue/clustercontrolNotifyControl";

	/** 通知振り分け用キュー(Non Persistence) */
	public static final String QUEUE_NAME_NOTIFYCONTROL_NON_PERSISTENCE = "queue/clustercontrolNotifyControlNonPersistence";

	/** ステータス出力用キュー */
	public static final String QUEUE_NAME_STATUS = "queue/clustercontrolNotifyStatus";

	/** イベント出力用キュー */
	public static final String QUEUE_NAME_EVENT = "queue/clustercontrolNotifyEvent";

	/** メール送信用キュー */
	public static final String QUEUE_NAME_MAIL = "queue/clustercontrolNotifyMail";

	/** ジョブ実行用キュー */
	public static final String QUEUE_NAME_JOB = "queue/clustercontrolNotifyJob";

	/** ログエスカレーション用キュー */
	public static final String QUEUE_NAME_LOGESCALATION = "queue/clustercontrolNotifyLogEscalation";

	/** コマンド通知用キュー */
	public static final String QUEUE_NAME_COMMAND = "queue/clustercontrolNotifyCommand";

	/** syslog-ng監視 HA構成時重複チェック用 キュー */
	public static final String QUEUE_NAME_SYSLOGNGDUP = "queue/clustercontrolSyslogngDup";

	/** 通知用キュー */
	private static final ArrayList<ArrayList<Object>> queueNotifyList = new ArrayList<ArrayList<Object>>();
	static {
		ArrayList<Object> list = null;
		list = new ArrayList<Object>();
		list.add(NotifyTypeConstant.TYPE_STATUS);
		list.add(QUEUE_NAME_STATUS);
		queueNotifyList.add(list);
		list = new ArrayList<Object>();
		list.add(NotifyTypeConstant.TYPE_EVENT);
		list.add(QUEUE_NAME_EVENT);
		queueNotifyList.add(list);
		list = new ArrayList<Object>();
		list.add(NotifyTypeConstant.TYPE_MAIL);
		list.add(QUEUE_NAME_MAIL);
		queueNotifyList.add(list);
		list = new ArrayList<Object>();
		list.add(NotifyTypeConstant.TYPE_JOB);
		list.add(QUEUE_NAME_JOB);
		queueNotifyList.add(list);
		list = new ArrayList<Object>();
		list.add(NotifyTypeConstant.TYPE_LOG_ESCALATE);
		list.add(QUEUE_NAME_LOGESCALATION);
		queueNotifyList.add(list);
		list = new ArrayList<Object>();
		list.add(NotifyTypeConstant.TYPE_COMMAND);
		list.add(QUEUE_NAME_COMMAND);
		queueNotifyList.add(list);
	}
	public static ArrayList<ArrayList<Object>> getQueueList() {
		return queueNotifyList;
	}
}
