/*

Copyright (C) since 2009 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.calendar.bean;

import java.io.Serializable;
import java.util.ArrayList;

import javax.xml.bind.annotation.XmlType;

/**
 * カレンダー実行予定情報のDTOです。
 * @since 0.1
 */
@XmlType(namespace = "http://calendar.ws.clustercontrol.com")
public class ScheduleInfo implements Serializable{

	private static final long serialVersionUID = -3250798577679896984L;

	private String id = null;
	private ArrayList<Long> dates = new ArrayList<Long>();

	public void setId(String id) {
		this.id = id;
	}
	public String getId() {
		return id;
	}
	public void setDates(ArrayList<Long> dates) {
		this.dates = dates;
	}
	public void addDate(Long date) {
		this.dates.add(date);
	}
	public ArrayList<Long> getDates() {
		return dates;
	}
}
