/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.ejb.entity;


/**
 *
 * 一括制御セッションで使用されたパラメータ情報を持つEntity Beanです。
 * 
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="CRunSessionParam"
 *    jndi-name="CRunSessionParam"
 *    type="CMP"
 *    view-type="local"
 *    schema="CRunSessionParam"
 *    cmp-version="2.x"
 *    data-source="java:/DefaultDS"
 * 
 * @ejb.persistence
 *    table-name="cc_crun_session_param"
 * 
 * @ejb.pk
 *    class="com.clustercontrol.collectiverun.ejb.entity.CRunSessionParamPK"
 * 
 * @jboss.persistence
 *    datasource="java:/DefaultDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_crun_session_param"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Log CMP 2.x EntityBean"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @ejb.finder
 *    query="SELECT OBJECT(a) FROM CRunSessionParam as a"
 *    signature="java.util.Collection findAll()"
 * 
 * <!-- end-xdoclet-definition -->
 * @generated
 **/
public abstract class CRunSessionParamBean implements javax.ejb.EntityBean {

	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.create-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public CRunSessionParamPK ejbCreate(
			String session_id,
			String param_id,
			String param_value) throws javax.ejb.CreateException {
		setSession_id(session_id);
		setParam_id(param_id);
		setParam_value(param_value);
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field session_id
	 *
	 * Returns the session_id
	 * @return the session_id
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="session_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 * @ejb.pk-field
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getSession_id();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the session_id
	 * 
	 * @param java.lang.String the new session_id value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setSession_id(java.lang.String session_id);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field param_id
	 *
	 * Returns the param_id
	 * @return the param_id
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="param_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 * @ejb.pk-field
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getParam_id();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the param_id
	 * 
	 * @param java.lang.String the new param_id value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setParam_id(java.lang.String param_id);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field param_value
	 *
	 * Returns the param_value
	 * @return the param_value
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="param_value"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getParam_value();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the param_value
	 * 
	 * @param java.lang.String the new param_value value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setParam_value(java.lang.String param_value);

	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation
	 * name="CRunSession-CRunSessionParam"
	 * role-name="CRunSessionParam-CRunSession(multi)"
	 * 
	 * @jboss.relation
	 * related-pk-field="session_id"
	 * fk-column="session_id"
	 */
	public abstract CRunSessionLocal getSession();

	/**
	 * 
	 * @ejb.interface-method view-type="local"
	 */
	public abstract void setSession(CRunSessionLocal session);
}
