/*

Copyright (C) 2011 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.commons.scheduler;

import com.clustercontrol.bean.ScheduleConstant;
import com.clustercontrol.commons.bean.Schedule;

public class QuartzUtil {
	/**
	 * スケジュール情報を基にcron文字列を作成します。
	 * 
	 * @param scheduleId スケジュールID
	 * @throws NamingException
	 * @throws SchedulerException
	 * 
	 * @see com.clustercontrol.bean.ScheduleConstant
	 */
	public static String getCronString(Schedule schedule){
		//cron形式でスケジュールを作成する
		StringBuffer cron = new StringBuffer();

		int second = 0;
		if (schedule.getType() == ScheduleConstant.TYPE_DAY) {
			if (schedule.getMinute() == null) {

			} else if (schedule.getHour() == null){
				cron.append(second);
				cron.append(" ");
				cron.append(schedule.getMinute());
				cron.append(" * * * ? *");
			} else if (schedule.getDay() == null) {
				cron.append(second);
				cron.append(" ");
				cron.append(schedule.getMinute());
				cron.append(" ");
				cron.append(schedule.getHour());
				cron.append(" * * ? *");
			} else if (schedule.getMonth() == null) {
				cron.append(second);
				cron.append(" ");
				cron.append(schedule.getMinute());
				cron.append(" ");
				cron.append(schedule.getHour());
				cron.append(" ");
				cron.append(schedule.getDay());
				cron.append(" * ? *");
			} else {
				cron.append(second);
				cron.append(" ");
				cron.append(schedule.getMinute());
				cron.append(" ");
				cron.append(schedule.getHour());
				cron.append(" ");
				cron.append(schedule.getDay());
				cron.append(" ");
				cron.append(schedule.getMonth());
				cron.append(" ? *");
			}
		} else {
			cron.append(second);
			cron.append(" ");
			cron.append(schedule.getMinute());
			cron.append(" ");
			if (schedule.getHour() == null) {
				cron.append("*");
			} else {
				cron.append(schedule.getHour());
			}
			cron.append(" ? * ");
			cron.append(schedule.getWeek());
			cron.append(" *");
		}
		return cron.toString();
	}
}
