/*

Copyright (C) 2011 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.commons.util;

import javax.management.ObjectName;
import javax.naming.InitialContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

public class EntityCacheUtil {
	private static Log m_log = LogFactory.getLog( EntityCacheUtil.class );

	/**
	 * RMIAdaptorのルックアップ名。<BR>
	 * イベント情報のキャッシュをフラッシュするために使用します。
	 */
	private static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
	/**
	 * 操作名。<BR>
	 * キャッシュをフラッシュする操作名を指定します。
	 */
	private static final String OPERATION_NAME = "flushCache";


	public static void clear(String objectName[]) {

		m_log.debug("cacheReflesh() objectName[] size : " + objectName.length);

		//Flush Entity Cache
		try{
			InitialContext ic = new InitialContext();

			//RMIAdaptorを取得
			RMIAdaptor server = (RMIAdaptor) ic.lookup(LOOKUP_NAME);

			for (String obj : objectName) {
				m_log.debug("cacheReflesh() objectName : " + obj);
				//ObjectNameを設定
				ObjectName name = new ObjectName(obj);

				//ObjectNameのOperationNameのメソッドを実行
				server.invoke(name, OPERATION_NAME, null, null);
			}

		} catch (Exception e) {
			m_log.warn("cacheReflesh() Unknown Error ", e);
		}
	}
}
