/*

Copyright (C) 2011 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.custom.factory;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import com.clustercontrol.commons.scheduler.TriggerScheduler;
import com.clustercontrol.custom.bean.CustomCheckInfo;
import com.clustercontrol.custom.ejb.entity.MonitorCustomInfoUtil;
import com.clustercontrol.monitor.run.factory.AddMonitorNumericValueType;

/**
 * コマンド監視の特有設定に対する登録処理実装クラス<br/>
 * @since 4.0
 * @author Tomoya Takahata
 */
public class AddCustom extends AddMonitorNumericValueType {

	/**
	 * コマンド監視特有の設定情報を登録する。<br/>
	 */
	@Override
	protected boolean addCheckInfo() throws CreateException, NamingException {
		// Local Variables
		CustomCheckInfo checkInfo = null;

		// MAIN
		// コマンド監視設定を登録する
		checkInfo = m_monitorInfo.getCustomCheckInfo();
		MonitorCustomInfoUtil.getLocalHome().create(m_monitorInfo.getMonitorId(),
				checkInfo.getCommandExecType(), checkInfo.getSelectedFacilityId(),
				checkInfo.getEffectiveUser(), checkInfo.getCommand(), checkInfo.getTimeout());

		return true;
	}

	/**
	 * スケジュール実行の遅延時間を返します。
	 */
	@Override
	protected int getDelayTime() {
		return 0;
	}

	/**
	 * スケジュール実行種別を返します。
	 */
	@Override
	protected String getTriggerType() {
		return TriggerScheduler.TRIGGER_TYPE_NONE;
	}

}
