/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.http.util;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import com.clustercontrol.http.bean.HttpCheckInfo;
import com.clustercontrol.http.ejb.entity.MonitorHttpInfoLocal;
import com.clustercontrol.http.ejb.entity.MonitorHttpInfoUtil;

/**
 * HTTP監視 判定情報を管理するクラス<BR>
 *
 * @version 4.0.0
 * @since 2.1.0
 */
public class ControlHttpInfo {

	/** 監視対象ID */
	private String m_monitorTypeId;

	/** 監視ID */
	private String m_monitorId;

	/**
	 * コンストラクタ
	 * 
	 * @param monitorId 監視項目ID
	 * @param monitorTypeId 監視対象ID
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public ControlHttpInfo(String monitorId, String monitorTypeId) {
		m_monitorId = monitorId;
		m_monitorTypeId = monitorTypeId;
	}

	/**
	 * HTTP監視情報を取得します。<BR>
	 * 
	 * @return HTTP監視情報
	 * @throws FinderException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public HttpCheckInfo get() throws FinderException, NamingException{

		// HTTP監視情報を取得
		MonitorHttpInfoLocal httpLocal = MonitorHttpInfoUtil.getLocalHome().findByPrimaryKey(m_monitorId);

		HttpCheckInfo http = new HttpCheckInfo();
		http.setMonitorTypeId(m_monitorTypeId);
		http.setMonitorId(m_monitorId);
		http.setRequestUrl(httpLocal.getRequestUrl());
		http.setTimeout(httpLocal.getTimeout().intValue());
		http.setUrlReplace(httpLocal.getUrlReplace().intValue());
		http.setProxySet(httpLocal.getProxySet().intValue());
		http.setProxyHost(httpLocal.getProxyHost());
		http.setProxyPort(httpLocal.getProxyPort().intValue());

		return http;
	}

	/**
	 * HTTP監視情報を追加します。<BR>
	 * 
	 * @param http HTTP監視情報
	 * @return 成功した場合、true
	 * @throws CreateException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public boolean add(HttpCheckInfo http) throws CreateException, NamingException {

		// HTTP監視情報を追加
		MonitorHttpInfoUtil.getLocalHome().create(
				m_monitorId,
				http.getRequestUrl(),
				Integer.valueOf(http.getTimeout()),
				Integer.valueOf(http.getUrlReplace()),
				Integer.valueOf(http.getProxySet()),
				http.getProxyHost(),
				Integer.valueOf(http.getProxyPort())
		);

		return true;
	}

	/**
	 * HTTP監視情報を変更します。<BR>
	 * 
	 * @param http HTTP監視情報
	 * @return 成功した場合、true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public boolean modify(HttpCheckInfo http) throws CreateException, FinderException, NamingException {

		// HTTP監視情報を取得
		MonitorHttpInfoLocal httpLocal = MonitorHttpInfoUtil.getLocalHome().findByPrimaryKey(m_monitorId);

		// HTTP監視情報を設定
		httpLocal.setRequestUrl(http.getRequestUrl());
		httpLocal.setUrlReplace(Integer.valueOf(http.getUrlReplace()));
		httpLocal.setTimeout(Integer.valueOf(http.getTimeout()));
		httpLocal.setProxySet(Integer.valueOf(http.getProxySet()));
		httpLocal.setProxyHost(http.getProxyHost());
		httpLocal.setProxyPort(Integer.valueOf(http.getProxyPort()));

		return true;
	}

	/**
	 * HTTP監視情報を削除します。<BR>
	 * 
	 * @return 成功した場合、true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public boolean delete() throws FinderException, RemoveException, NamingException {

		// HTTP監視情報を取得
		MonitorHttpInfoLocal httpLocal = MonitorHttpInfoUtil.getLocalHome().findByPrimaryKey(m_monitorId);

		// HTTP監視情報を削除
		httpLocal.remove();

		return true;
	}
}
