/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;

/**
 * ジョブのファイル転送に関する情報を保持するクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
@XmlType(namespace = "http://jobmanagement.ws.clustercontrol.com")
public class JobFileInfo implements Serializable, Cloneable {
	/** シリアライズ可能クラスに定義するUID */
	private static final long serialVersionUID = 6448926354392693297L;

	/** スコープ処理方法 */
	private Integer m_processingMethod = new Integer(0);

	/** 転送ファシリティID */
	private String m_srcFacilityID;

	/** 受信ファシリティID */
	private String m_destFacilityID;

	/** 転送スコープ */
	private String m_srcScope;

	/** 受信スコープ */
	private String m_destScope;

	/** ファイル */
	private String m_srcFile;

	/** 転送作業ディレクトリ */
	private String m_srcWorkDir = "";

	/** 受信ディレクトリ */
	private String m_destDirectory;

	/** 受信作業ディレクトリ */
	private String m_destWorkDir = "";

	/** ファイル圧縮 */
	private Integer m_compressionFlg = new Integer(0);

	/** ファイルチェック */
	private Integer m_checkFlg = new Integer(0);

	/** 実効ユーザ */
	private String m_user;

	/**
	 * ファイル圧縮をするかしないかを返す。<BR>
	 * @return ファイル圧縮のするかしないか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public Integer getCompressionFlg() {
		return m_compressionFlg;
	}

	/**
	 * ファイル圧縮をするかしないかを設定する。<BR>
	 * @param compressionFlg ファイル圧縮をするかしないか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setCompressionFlg(Integer compressionFlg) {
		this.m_compressionFlg = compressionFlg;
	}

	/**
	 * ファイルチェックをするかしないかを返す。<BR>
	 * @return ファイルチェックをするかしないか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public Integer getCheckFlg() {
		return m_checkFlg;
	}

	/**
	 * ファイルチェックをするかしないかを設定する。<BR>
	 * @param checkFlg ファイルチェックをするかしないか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setCheckFlg(Integer checkFlg) {
		this.m_checkFlg = checkFlg;
	}

	/**
	 * 転送元のスコープを返す。<BR>
	 * @return 転送元のスコープ
	 */
	public String getSrcScope() {
		return m_srcScope;
	}

	/**
	 * 転送元のスコープを設定する。<BR>
	 * @param srcScope 転送元のスコープ
	 */
	public void setSrcScope(String srcScope) {
		this.m_srcScope = srcScope;
	}

	/**
	 * 受信スコープを返す。<BR>
	 * @return 受信スコープ
	 */
	public String getDestScope() {
		return m_destScope;
	}

	/**
	 * 受信スコープを設定する。<BR>
	 * @param destScope 受信スコープ
	 */
	public void setDestScope(String destScope) {
		this.m_destScope = destScope;
	}

	/**
	 * 転送元のファシリティIDを返す。<BR>
	 * @return 転送元のファシリティID
	 */
	public String getSrcFacilityID() {
		return m_srcFacilityID;
	}

	/**
	 * 転送元のファシリティIDを設定する。<BR>
	 * @param srcFacilityID 転送元のファシリティID
	 */
	public void setSrcFacilityID(String srcFacilityID) {
		this.m_srcFacilityID = srcFacilityID;
	}

	/**
	 * 受信ファシリティIDを返す。<BR>
	 * @return 受信ファシリティID
	 */
	public String getDestFacilityID() {
		return m_destFacilityID;
	}

	/**
	 * 受信ファシリティIDを設定する。<BR>
	 * @param destFacilityID 受信ファシリティID
	 */
	public void setDestFacilityID(String destFacilityID) {
		this.m_destFacilityID = destFacilityID;
	}

	/**
	 * 転送するファイルのパスを返す。<BR>
	 * @return 転送するファイルのパス
	 */
	public String getSrcFile() {
		return m_srcFile;
	}

	/**
	 * 転送するファイルのパスを設定する。<BR>
	 * @param srcFile ファイル
	 */
	public void setSrcFile(String srcFile) {
		this.m_srcFile = srcFile;
	}

	/**
	 * 転送作業ディレクトリを返す。<BR>
	 * @return 転送作業ディレクトリ
	 */
	public String getSrcWorkDir() {
		return m_srcWorkDir;
	}

	/**
	 * 転送作業ディレクトリを設定する。<BR>
	 * @param srcWorkDir 転送作業ディレクトリ
	 */
	public void setSrcWorkDir(String srcWorkDir) {
		this.m_srcWorkDir = srcWorkDir;
	}

	/**
	 * 受信するディレクトリのパスを返す。<BR>
	 * @return 受信ディレクトリ
	 */
	public String getDestDirectory() {
		return m_destDirectory;
	}

	/**
	 * 受信するディレクトリのパスを設定する。<BR>
	 * @param destDirectory 受信ディレクトリ
	 */
	public void setDestDirectory(String destDirectory) {
		this.m_destDirectory = destDirectory;
	}

	/**
	 * 受信作業ディレクトリを返す
	 * @return 受信作業ディレクトリ
	 */
	public String getDestWorkDir() {
		return m_destWorkDir;
	}

	/**
	 * 受信作業ディレクトリを設定する
	 * @param destWorkDir 受信作業ディレクトリ
	 */
	public void setDestWorkDir(String destWorkDir) {
		this.m_destWorkDir = destWorkDir;
	}

	/**
	 * スコープの処理方法を返す。<BR>
	 * @return スコープ処理方法
	 * @see com.clustercontrol.bean.ProcessingMethodConstant
	 */
	public Integer getProcessingMethod() {
		return m_processingMethod;
	}

	/**
	 * スコープの処理方法を設定する。<BR>
	 * @param processingMethod スコープ処理方法
	 * @see com.clustercontrol.bean.ProcessingMethodConstant
	 */
	public void setProcessingMethod(Integer processingMethod) {
		this.m_processingMethod = processingMethod;
	}

	/**
	 * 実効ユーザを返す。<BR>
	 * @return 実効ユーザ
	 */
	public String getUser() {
		return m_user;
	}

	/**
	 * 実効ユーザを設定する。<BR>
	 * @param user 実効ユーザ
	 */
	public void setUser(String user) {
		this.m_user = user;
	}

	/**
	 * ジョブファイル転送情報のクローンを作成する。<BR>
	 * @return ジョブファイル転送情報のクローン
	 * @see java.lang.Object#clone()
	 */
	@Override
	protected Object clone() {
		try {
			JobFileInfo clone = (JobFileInfo)super.clone();

			clone.setProcessingMethod(this.getProcessingMethod());
			clone.setSrcFacilityID(this.getSrcFacilityID());
			clone.setDestFacilityID(this.getDestFacilityID());
			clone.setSrcScope(this.getSrcScope());
			clone.setDestScope(this.getDestScope());
			clone.setSrcFile(this.getSrcFile());
			clone.setSrcWorkDir(this.getSrcWorkDir());
			clone.setDestDirectory(this.getDestDirectory());
			clone.setDestWorkDir(this.getDestWorkDir());
			clone.setCompressionFlg(this.getCompressionFlg());
			clone.setCheckFlg(this.getCheckFlg());
			clone.setUser(this.getUser());

			return clone;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}
}