/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.jobmanagement.dao.JobEndInfoDAOImpl;

/**
 * ジョブ終了状態情報のBMP Entity Bean クラス<BR>
 * 
 * @ejb.bean name="JobEndInfo"
 *    jndi-name="JobEndInfo"
 *    type="BMP"
 *    view-type="local"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Log BMP EntityBean"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @ejb.dao
 *    class="com.clustercontrol.jobmanagement.dao.JobEndInfoDAO"
 *    impl-class="com.clustercontrol.jobmanagement.dao.JobEndInfoDAOImpl"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @see com.clustercontrol.jobmanagement.dao.JobEndInfoDAO
 * @see com.clustercontrol.jobmanagement.dao.JobEndInfoDAOImpl
 */
public abstract class JobEndInfoBean implements javax.ejb.EntityBean {
	/** セッションID */
	protected String session_id;
	/** 所属ジョブユニットのジョブID */
	protected String jobunit_id;
	/** ジョブID */
	protected String job_id;
	/** 終了状態 */
	protected Integer end_status;
	/** 終了値 */
	protected Integer end_value;
	/** 終了値範囲(開始) */
	protected Integer end_value_from;
	/** 終了値範囲(終了) */
	protected Integer end_value_to;

	/**
	 * ジョブ終了状態情報を生成します。<BR>
	 * 
	 * @ejb.create-method
	 * 
	 * @param session_id セッションID
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 * @param job_id ジョブID
	 * @param end_status 終了状態
	 * @param end_value 終了値
	 * @param end_value_from 終了値範囲(開始)
	 * @param end_value_to 終了値範囲(終了)
	 * @return プライマリーキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public JobEndInfoPK ejbCreate(
			String session_id,
			String jobunit_id,
			String job_id,
			Integer end_status,
			Integer end_value,
			Integer end_value_from,
			Integer end_value_to
	) throws javax.ejb.CreateException {
		this.session_id = session_id;
		this.jobunit_id = jobunit_id;
		this.job_id = job_id;
		this.end_status = end_status;
		this.end_value = end_value;
		this.end_value_from = end_value_from;
		this.end_value_to = end_value_to;
		return null;
	}

	/**
	 * 全てのジョブ終了状態情報を検索します。<BR>
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobEndInfoDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}

	/**
	 * プライマリキーに一致するジョブ終了状態情報を検索します。<BR>
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobEndInfoDAOImpl#findByPrimaryKey(JobEndInfoPK)
	 */
	public JobEndInfoPK ejbFindByPrimaryKey(JobEndInfoPK pk) throws FinderException {
		return null;
	}

	/**
	 * セッションIDとジョブIDに一致するジョブ終了状態情報を検索します。<BR>
	 * 
	 * @param session_id セッションID
	 * @param job_id ジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobEndInfoDAOImpl#findAll()
	 */
	public Collection ejbFindBySessionIdAndJobId(String session_id, String job_id) throws FinderException {
		return null;
	}

	/**
	 * セッションIDを返す。<BR>
	 * 
	 * @ejb.persistent-field
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return セッションID
	 */
	public java.lang.String getSession_id() {
		return session_id;
	}

	/**
	 * セッションIDを設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param session_id セッションID
	 */
	public void setSession_id(java.lang.String session_id) {
		this.session_id = session_id;
	}

	/**
	 * 所属ジョブユニットのジョブIDを返す。<BR>
	 * 
	 * @ejb.persistent-field
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return 所属ジョブユニットのジョブID
	 */
	public java.lang.String getJobunit_id() {
		return jobunit_id;
	}

	/**
	 * 所属ジョブユニットのジョブIDを設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 */
	public void setJobunit_id(java.lang.String jobunit_id) {
		this.jobunit_id = jobunit_id;
	}

	/**
	 * ジョブIDを返す。<BR>
	 * 
	 * @ejb.persistent-field
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
	public java.lang.String getJob_id() {
		return job_id;
	}

	/**
	 * ジョブIDを設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
	public void setJob_id(java.lang.String job_id) {
		this.job_id = job_id;
	}

	/**
	 * 終了状態を返す。<BR>
	 * 
	 * @ejb.persistent-field
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return 終了状態
	 * 
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public java.lang.Integer getEnd_status() {
		return end_status;
	}

	/**
	 * 終了状態を設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param end_status 終了状態
	 * 
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public void setEnd_status(java.lang.Integer end_status) {
		this.end_status = end_status;
	}

	/**
	 * 終了値を返す。<BR>
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 終了値
	 */
	public java.lang.Integer getEnd_value() {
		return end_value;
	}

	/**
	 * 終了値を設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param end_value 終了値
	 */
	public void setEnd_value(java.lang.Integer end_value) {
		this.end_value = end_value;
	}

	/**
	 * 終了値範囲(開始)を返す。<BR>
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 終了値範囲(開始)
	 */
	public java.lang.Integer getEnd_value_from() {
		return end_value_from;
	}

	/**
	 * 終了値範囲(開始)を設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param end_value_from 終了値範囲(開始)
	 */
	public void setEnd_value_from(java.lang.Integer end_value_from) {
		this.end_value_from = end_value_from;
	}

	/**
	 * 終了値範囲(終了)を返す。<BR>
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 終了値範囲(終了)
	 */
	public java.lang.Integer getEnd_value_to() {
		return end_value_to;
	}

	/**
	 * 終了値範囲(終了)を設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param end_value_to 終了値範囲(終了)
	 */
	public void setEnd_value_to(java.lang.Integer end_value_to) {
		this.end_value_to = end_value_to;
	}

	/**
	 * ジョブ情報を取得する。<BR>
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブ情報
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobInfoUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobInfoPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobInfoBean#ejbFindByPrimaryKey(JobInfoPK)
	 */
	public JobInfoLocal getJobInfo() {
		JobInfoLocal jobInfo = null;
		try {
			jobInfo = JobInfoUtil.getLocalHome().findByPrimaryKey(new JobInfoPK(getSession_id(), getJobunit_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobInfo;
	}

	/**
	 * 履歴情報を作成する。<BR>
	 * ジョブ終了状態情報をジョブ終了状態マスタから作成します。<BR>
	 * 
	 * @ejb.home-method view-type="both"
	 * 
	 * @param sessionId セッションID
	 * @param jobunitId 所属ジョブユニットのジョブID
	 * @param jobs ジョブIDのコレクション
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobEndInfoDAOImpl#makeSession(String, String, Collection)
	 */
	public void ejbHomeMakeSession(String sessionId, String jobunitId, Collection jobs) throws javax.ejb.CreateException{
		JobEndInfoDAOImpl jeiDAO = new JobEndInfoDAOImpl();
		jeiDAO.makeSession(sessionId, jobunitId, jobs);
	}

}
