/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.factory;

import java.text.ParseException;

import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.commons.scheduler.QuartzUtil;
import com.clustercontrol.commons.scheduler.TriggerConstant;
import com.clustercontrol.commons.scheduler.TriggerSchedulerException;
import com.clustercontrol.commons.scheduler.TriggerSchedulerFactory;
import com.clustercontrol.jobmanagement.bean.JobTriggerInfo;
import com.clustercontrol.jobmanagement.bean.JobTriggerTypeConstant;
import com.clustercontrol.jobmanagement.bean.QuartzConstant;
import com.clustercontrol.jobmanagement.bean.JobSchedule;
import com.clustercontrol.jobmanagement.ejb.session.JobControllerUtil;

/**
 * スケジュール情報を操作するクラスです。
 *
 * @version 2.4.0
 * @since 1.0.0
 */
public class ModifySchedule {
	/** ログ出力のインスタンス */
	private static Log m_log = LogFactory.getLog( ModifySchedule.class );

	/**
	 * スケジュール情報をDBに反映し、スケジューラにジョブを登録します。<BR>
	 * 
	 * @param info スケジュール情報
	 * @param user ユーザID
	 * @throws ParseException
	 * @throws NamingException
	 * @throws SchedulerException
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.QuartzConstant
	 * @see com.clustercontrol.jobmanagement.bean.JobTriggerInfo
	 * @see com.clustercontrol.jobmanagement.util.QuartzUtil#getQuartzManager()
	 */
	public void addSchedule(JobSchedule info, String user) throws TriggerSchedulerException {
		m_log.debug("addSchedule() : id=" + info.getId() + ", jobId=" + info.getJobId());

		//実行契機情報の作成
		JobTriggerInfo triggerInfo = new JobTriggerInfo();
		triggerInfo.setTrigger_type(JobTriggerTypeConstant.TYPE_SCHEDULE);
		triggerInfo.setTrigger_info(info.getName()+"("+info.getId()+")");

		//JobDetailに呼び出すメソッドの引数を設定
		Object[] jdArgs = new Object[QuartzConstant.ARGS_NUM];
		Class[] jdArgsType = new Class[QuartzConstant.ARGS_NUM];
		//ジョブユニットIDを設定
		jdArgs[QuartzConstant.INDEX_JOBUNIT_ID] = info.getJobunitId();
		jdArgsType[QuartzConstant.INDEX_JOBUNIT_ID] = String.class;

		//ジョブIDを設定
		jdArgs[QuartzConstant.INDEX_JOB_ID] = info.getJobId();
		jdArgsType[QuartzConstant.INDEX_JOB_ID] = String.class;

		//カレンダIDを設定
		jdArgs[QuartzConstant.INDEX_CALENDAR_ID] = info.getCalendarId();
		jdArgsType[QuartzConstant.INDEX_CALENDAR_ID] = String.class;

		//実行契機情報を設定
		jdArgs[QuartzConstant.INDEX_TRIGGER_INFO] = triggerInfo;
		jdArgsType[QuartzConstant.INDEX_TRIGGER_INFO] = JobTriggerInfo.class;

		try {
			TriggerSchedulerFactory.getScheduler(TriggerConstant.JOB_INSTANCE_NAME).scheduleEjbLocalInvokerJobWithCronTrigger(
					info.getId(),
					QuartzConstant.GROUP_NAME,
					JobControllerUtil.getLocalHome(),
					QuartzConstant.METHOD_NAME,
					jdArgs,
					jdArgsType,
					null,
					false,
					ValidConstant.typeToBoolean(info.getValid()),
					QuartzUtil.getCronString(info.getSchedule()));
		} catch (TriggerSchedulerException e) {
			m_log.warn("addSchedule() scheduleJob : id=" + info.getId() + ", jobId=" + info.getJobId() + ", " + e.getMessage(), e);
			throw e;
		} catch (NamingException e) {
			String msg = "addSchedule() scheduleJob : id=" + info.getId() + ", jobId=" + info.getJobId() + ", " + e.getMessage();
			m_log.warn(msg, e);
			throw new TriggerSchedulerException(msg, e);
		}
	}

	/**
	 * スケジュール情報を基にQuartzに登録したジョブを削除します。
	 * 
	 * @param scheduleId スケジュールID
	 * @throws NamingException
	 * @throws SchedulerException
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.QuartzConstant
	 * @see com.clustercontrol.jobmanagement.util.QuartzUtil#getQuartzManager()
	 * @see com.clustercontrol.quartzmanager.ejb.session.QuartzManager#deleteSchedule(java.lang.String, java.lang.String)
	 */
	public void deleteSchedule(String scheduleId) throws TriggerSchedulerException {
		m_log.debug("deleteSchedule() : id=" + scheduleId);
		try {
			//ジョブ削除
			TriggerSchedulerFactory.getScheduler(TriggerConstant.JOB_INSTANCE_NAME).deleteJob(scheduleId, QuartzConstant.GROUP_NAME);
		} catch (TriggerSchedulerException e) {
			m_log.warn("deleteSchedule() deleteJob : " + e.getClass().getSimpleName() + ", " + e.getMessage());
			throw e;
		}
	}
}
