/*

Copyright (C) 2007 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.maintenance.factory;

import java.sql.Timestamp;
import java.util.Date;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.maintenance.bean.MaintenanceInfo;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoUtil;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;

/**
 * メンテナンス情報を登録するためのクラスです。
 * 
 * @version 4.0.0
 * @since 2.2.0
 *
 */
public class AddMaintenance {

	public boolean addMaintenance(MaintenanceInfo data, String name) throws CreateException, NamingException, HinemosUnknown {

		//エンティティBeanをつくる
		MaintenanceInfoUtil.getLocalHome().create(
				data.getMaintenanceId(),
				data.getDescription(),
				data.getTypeId(),
				data.getDataRetentionPeriod(),
				data.getCalendarId(),
				data.getSchedule().getType(),
				data.getSchedule().getMonth(),
				data.getSchedule().getDay(),
				data.getSchedule().getWeek(),
				data.getSchedule().getHour(),
				data.getSchedule().getMinute(),
				data.getNotifyGroupId(),
				data.getApplication(),
				data.getValidFlg(),
				name,
				new Timestamp(new Date().getTime()),
				name,
				new Timestamp(new Date().getTime()));

		if(data.getNotifyId() != null){

			NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();

			nc.addNotifyRelation(data.getNotifyId());
		}


		return true;

	}

}
