/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.maintenance.factory;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.NotifyNotFound;
import com.clustercontrol.commons.util.ConnectionManager;

/**
 * 性能実績の削除処理
 * 
 * @version 4.0.0
 * @since 4.0.0
 *
 */
public class MaintenancePerf extends MaintenanceObject {

	private static Log m_log = LogFactory.getLog( MaintenancePerf.class );

	/**
	 * 収集設定のオブジェクト名。<BR>
	 * キャッシュをフラッシュするオブジェクト名を指定します。
	 */
	private static final String[] OBJECT_NAME_JOB =
	{"jboss.j2ee:jndiName=MonitorInfoLocal,service=EJB"};

	public MaintenancePerf() {
		super(OBJECT_NAME_JOB);
	}

	/**
	 * 削除処理
	 */
	@Override
	protected int _delete(Timestamp keep, boolean status) throws FinderException,
	NamingException, CreateException, SQLException, RemoveException,
	HinemosUnknown, NotifyNotFound {
		m_log.debug("_delete() start : keep = " + keep.toString() + ", status = " + status);

		int ret = -1;
		Connection conn = null;
		Statement stmt = null;
		boolean autoCommit = false;

		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			autoCommit = conn.getAutoCommit();
			conn.setAutoCommit(false);

			//SQL文のセット
			stmt = conn.createStatement();
			// for HA (縮退判定時間を延ばすため)、シングルには影響なし(0)
			if (_queryTimeout > 0) {
				stmt.setQueryTimeout(_queryTimeout);
			}

			//SQL文の定義
			StringBuffer sql = new StringBuffer();
			sql.append("DELETE FROM cc_calculated_data WHERE date_time < '" + keep.toString() + "'");
			if(!status){
				//status=falseの場合は収集中イベントのみを削除する
				sql.append(" AND collectorid IN (SELECT monitor_id FROM cc_monitor_info WHERE collector_flg = 1)");
			}

			//SQL文の実行
			m_log.debug("_delete() execute : " + sql.toString());
			ret = stmt.executeUpdate(sql.toString());

			///////////////////////////////////////////////
			// COMMIT
			///////////////////////////////////////////////
			conn.commit();

			//終了
			m_log.debug("_delete() count : " + ret);
			return ret;

		} catch (SQLException e) {
			m_log.error("_delete() : keep = " + keep.toString() + ", status = " + status, e);
			throw e;
		} finally {
			//接続close
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.setAutoCommit(autoCommit);
					conn.close();
				}
			} catch (SQLException e) {
				m_log.error("_delete() : keep = " + keep.toString() + ", status = " + status, e);
			}
		}
	}

}
