/*

Copyright (C) 2007 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.maintenance.factory;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.MaintenanceNotFound;
import com.clustercontrol.fault.NotifyNotFound;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.maintenance.bean.MaintenanceTypeMstConstant;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoLocal;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoUtil;
import com.clustercontrol.maintenance.ejb.session.MaintenanceControllerLocal;
import com.clustercontrol.maintenance.ejb.session.MaintenanceControllerUtil;

/**
 * 
 * メンテナンス機能が提供する操作を実行するクラスです。
 * 
 * @version 4.0.0
 * @since 2.2.0
 *
 */
public class OperationMaintenance {
	/** ログ出力のインスタンス */
	private static Log m_log = LogFactory.getLog( OperationMaintenance.class );

	public void runMaintenance(String maintenanceId) throws HinemosUnknown, NotifyNotFound {

		int result = -1;
		Integer type = PriorityConstant.TYPE_CRITICAL;

		try {
			MaintenanceInfoLocal info = MaintenanceInfoUtil.getLocalHome().findByPrimaryKey(maintenanceId);
			MaintenanceControllerLocal controller = MaintenanceControllerUtil.getLocalHome().create();

			Integer dataRetentionPeriod = info.getDataRetentionPeriod();
			String type_id = info.getType_id();

			if (MaintenanceTypeMstConstant.DELETE_EVENT_LOG_ALL.equals(type_id)) {
				result = controller.deleteEventLog(dataRetentionPeriod, true);
			} else if (MaintenanceTypeMstConstant.DELETE_EVENT_LOG.equals(type_id)) {
				result = controller.deleteEventLog(dataRetentionPeriod, false);
			} else if (MaintenanceTypeMstConstant.DELETE_JOB_HISTORY_ALL.equals(type_id)) {
				result = controller.deleteJobHistory(dataRetentionPeriod, true);
			} else if (MaintenanceTypeMstConstant.DELETE_JOB_HISTORY.equals(type_id)) {
				result = controller.deleteJobHistory(dataRetentionPeriod, false);
			} else if (MaintenanceTypeMstConstant.DELETE_CRUN_HISTORY_ALL.equals(type_id)) {
				result = controller.deleteCollectiveRunHistory(dataRetentionPeriod, true);
			} else if (MaintenanceTypeMstConstant.DELETE_CRUN_HISTORY.equals(type_id)) {
				result = controller.deleteCollectiveRunHistory(dataRetentionPeriod, false);
			} else if (MaintenanceTypeMstConstant.DELETE_VM_LOG_ALL.equals(type_id)) {
				result = controller.deleteVmLog(dataRetentionPeriod, true);
			} else if (MaintenanceTypeMstConstant.DELETE_VM_LOG.equals(type_id)) {
				result = controller.deleteVmLog(dataRetentionPeriod, false);
			} else if (MaintenanceTypeMstConstant.DELETE_RERF_DATA_ALL.equals(type_id)) {
				result = controller.deletePerfData(dataRetentionPeriod, true);
			} else if (MaintenanceTypeMstConstant.DELETE_RERF_DATA.equals(type_id)) {
				result = controller.deletePerfData(dataRetentionPeriod, false);
			} else {
				m_log.error("runMaintenance() : " + type_id);
			}

			type = PriorityConstant.TYPE_INFO;

		} catch (FinderException e) {
			m_log.warn("runMaintenance " + e.getClass() + e.getMessage(), e);
		} catch (NamingException e) {
			m_log.warn("runMaintenance " + e.getClass() + e.getMessage(), e);
		} catch (CreateException e) {
			m_log.warn("runMaintenance " + e.getClass() + e.getMessage(), e);
		} catch (MaintenanceNotFound e) {
			m_log.warn("runMaintenance " + e.getClass() + e.getMessage(), e);
		} finally {
			try {
				new Notice().notify(maintenanceId, type.intValue(), result);
			} catch (FinderException e) {
				m_log.warn("runMaintenance " + e.getClass() + e.getMessage(), e);
			} catch (NamingException e) {
				m_log.warn("runMaintenance " + e.getClass() + e.getMessage(), e);
			}
		}
	}

}
