/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.monitor.run.util;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * トランザクションマネージャを取得するクラス<BR>
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class MonitorTransactionManager {
	/** ログ出力のインスタンス。 */
	private static Log m_log = LogFactory.getLog( MonitorTransactionManager.class );

	private static MonitorTransactionManager m_instance = null;
	private InitialContext m_ctx = null;

	/**
	 * 唯一の自身のインスタンスを返します。<BR>
	 * コンテキストオブジェクトを保持します。
	 * 
	 * @return 自身のインスタンス
	 */
	public static MonitorTransactionManager getInstance() {
		if (m_instance==null) {
			m_instance = new MonitorTransactionManager();
		}
		return m_instance;
	}

	/**
	 * コンストラクタ。
	 */
	private MonitorTransactionManager() {
		try {
			m_ctx = new InitialContext();
		} catch (NamingException e) {
			m_log.error("TransactionManager:" + e.getMessage());
		}
	}

	/**
	 * トランザクションマネージャを返します。
	 * 
	 * @return トランザクションマネージャ
	 * @throws NamingException
	 */
	public synchronized TransactionManager getTransactionManager() throws NamingException {
		if(m_ctx == null){
			try {
				m_ctx = new InitialContext();
			} catch (NamingException e) {
				m_log.error("getTransactionManager:" + e.getMessage());
				throw e;
			}
		}

		try {
			// TransactionManagerをルックアップ
			TransactionManager tm = (TransactionManager)m_ctx.lookup("java:/TransactionManager");
			return tm;
		} catch (NamingException e) {
			m_ctx = null;

			m_log.error("getTransactionManager:" + e.getMessage());
			throw e;
		}
	}
}
