/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.ejb.entity;

import javax.ejb.EntityBean;

/**
 * リソース監視の設定情報を管理するEntity Bean <BR>
 * @ejb.bean name="MonitorPerfInfo"
 *           jndi-name="MonitorPerfInfo"
 *           type="CMP"
 *           view-type="local"
 *           primkey-field="monitorId"
 *           schema="MonitorPerfInfo"
 *           cmp-version="2.x"
 *           data-source="java:/DefaultDS"
 * 
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 *  @jboss.container-configuration
 *     name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @jboss.persistence
 *    datasource="java:/DefaultDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_monitor_perf_info"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 * 
 *  @ejb.permission
 *     unchecked="true"
 * 
 *  @ejb.persistence
 *   table-name="cc_monitor_perf_info"
 * 
 *  @ejb.finder
 *    query="SELECT OBJECT(a) FROM MonitorPerfInfo as a"
 *    signature="java.util.Collection findAll()"
 *
 * @ejb.pk
 *    class="java.lang.String"
 * 
 */
public abstract class MonitorPerfInfoBean implements EntityBean {

	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.create-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public java.lang.String ejbCreate(
			String monitorId,
			String itemCode,
			String deviceDisplayName,
			Integer breakdownFlg
	) throws javax.ejb.CreateException {

		this.setMonitorId(monitorId);
		this.setItemCode(itemCode);
		this.setDeviceDisplayName(deviceDisplayName);
		this.setBreakdownFlg(breakdownFlg);

		return null;
	}

	/**
	 * コンストラクター
	 * @param monitorTypeId 監視種別ID
	 * @param monitorId 監視項目ID
	 * @param collectorId 収集項目ID
	 * @param itemCode 収集項目コード
	 * @param deviceIndex デバイスインデックス
	 * @param deviceType デバイスタイプ
	 * @param deviceDisplayName デバイス名
	 * @param breakdownFlg 内訳収集フラグ
	 * @throws javax.ejb.CreateException
	 */
	public void ejbPostCreate(
			String monitorId,
			String itemCode,
			String deviceName,
			String deviceDisplayName,
			int breakdownFlg
	) throws javax.ejb.CreateException {
	}

	/**
	 * 収集項目コードを取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="item_code"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the item code.
	 */
	public abstract String getItemCode();

	/**
	 * 収集項目コードを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param itemCode The item code to set.
	 */
	public abstract void setItemCode(String itemCode);

	/**
	 * リポジトリ表示名を取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="device_display_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the device display name.
	 */
	public abstract String getDeviceDisplayName();

	/**
	 * リポジトリ表示名を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param displayName The device display name to set.
	 */
	public abstract void setDeviceDisplayName(String device_display_name);

	/**
	 * 内訳収集フラグを取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="breakdown_flg "
	 *     jdbc-type="SMALLINT"
	 *     sql-type="SMALLINT"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the breakdown flg.
	 */
	public abstract Integer getBreakdownFlg();

	/**
	 * 内訳収集フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param displayName The breakdown flg to set.
	 */
	public abstract void setBreakdownFlg(Integer breakdownFlg);

	/**
	 * 監視項目IDを取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorId.
	 */
	public abstract String getMonitorId();

	/**
	 * 監視項目IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorId The monitorId to set.
	 */
	public abstract void setMonitorId(String monitorId);
}
