/*

Copyright (C) 2008 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

 */

package com.clustercontrol.performance.operator;

/**
 * (var0 - var2) / (var0 + var1) の百分率を求める計算
 * 
 */
public class PercentageDiffAdd extends Operator {
@Override
public double calc() throws CollectedDataNotFoundException, InvalidValueException{
double diff;
double total;
double perfData;


//FIXME 値をdouble値で取得するため、丸め誤差が発生します。
diff = getCurrentMibValue("var0") - getCurrentMibValue("var2");

total = getCurrentMibValue("var0") + getCurrentMibValue("var1");

if(total == 0){
// エラー処理　おそらく値がとれていない
return Double.NaN;
}

perfData = diff / total * 100.0D;

return perfData;
}
}
