/*

Copyright (C) 2010 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.selfcheck;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import com.clustercontrol.selfcheck.monitor.DBSizeMonitor;

public class SelfCheckConfig {

	// SelfCheck Service Attribute
	private static volatile Date lastMonitorDate = null;

	private static volatile int startupDelaySec = 90;
	private static volatile int intervalSec = 150;
	private static volatile int alertThreshold = 3;
	private static volatile int threadPoolSize = 5;

	// SelfCheck Notification Attribute
	private static volatile boolean event = true;
	private static volatile boolean syslog = false;
	private static volatile String[] syslogHost = { "127.0.0.1" };
	private static volatile int syslogPort = 514;
	private static volatile String syslogFacility = "daemon";
	private static volatile String syslogSeverity = "alert";
	private static volatile boolean mail = false;
	private static volatile String[] mailAddress = { };

	// SNMP Configuration to 127.0.0.1 (Hinemos Manager)
	private static volatile String snmpHost = "127.0.0.1";
	private static volatile String snmpCommunity = "public";
	private static volatile int snmpPort = 161;
	private static volatile String snmpVersion = "2c";
	private static volatile int snmpTimeoutMSec = 3000;
	private static volatile int snmpRetries = 3;

	// monitor java vm heap
	private static volatile boolean jvmHeapMonitoring = true;
	private static volatile int jvmHeapThresholdMByte = 32;

	// monitor filesystem on 127.0.0.1 (Hinemos Manager)
	private static volatile boolean fileSystemMonitoring = false;
	private static volatile String mountPointDatabase = "/";
	private static volatile String mountPointLog = "/";
	private static volatile int fileSystemDBThresholdPer = 75;
	private static volatile int fileSystemLogThresholdPer = 75;

	// monitor ram memory on 127.0.0.1 (Hinemos Manager)
	private static volatile boolean swapOutMonitoring = false;

	// monitor datasource
	private static volatile boolean datasourceMonitoring = true;
	private static volatile String jndiDatasourceHinemos = "DefaultDS";

	// monitor java scheduler
	private static volatile boolean schedulerMonitoring = true;
	private static volatile int schedulerDelayThresholdSec = 300;
	private static volatile String jndiDBMSScheduler = "DBMSScheduler";
	private static volatile String triggerGroupDBMS = "JOB_MANAGEMENT";
	private static volatile String triggerNameDBMS = "JobRunManagement";
	private static volatile String jndiRAMScheduler = "RAMScheduler";
	private static volatile String triggerGroupRAM = "SHAREDTABLE";
	private static volatile String triggerNameRAM = "CHECK_JOB";

	// monitor jms
	private static volatile boolean jmsMonitoring = true;
	private static volatile int jmsMessageCountThreshold = 5000;
	private static volatile String[] monitorQueue = { "clustercontrolCollectiveRunExecute",
		"clustercontrolCollectiveRunStatus",
		"clustercontrolJobManagementStatus",
		"clustercontrolLogtransferLogTransferFileManage",
		"clustercontrolNotifyCommand",
		"clustercontrolNotifyEvent",
		"clustercontrolNotifyJob",
		"clustercontrolNotifyLogEscalation",
		"clustercontrolNotifyMail",
		"clustercontrolNotifyStatus",
		"clustercontrolVmControlExecute",
	"clustercontrolVmControlStatus"};
	private static volatile String[] monitorTopic = { "clustercontrolJobManagementExecute",
		"clustercontrolLogtransferUpdate",
	"clustercontrolRepositoryUpdate"};

	// monitor syslogforward
	private static volatile boolean syslogFilterMonitoring = false;
	private static volatile String[] syslogFilterHost = { };

	// monitor log table
	private static volatile boolean logTableSizeMonitoring = true;

	private static volatile String jndiLogTableDS = "DefaultDS";

	private static volatile String tableNameEventLog = "cc_event_log";
	private static volatile String tableNameEventLogDesc = "Event Log";
	private static volatile long thresholdEventLog = 512;
	private static volatile int thresholdTypeEventLog = DBSizeMonitor.THRESHOLD_MBYTE;

	private static volatile String tableNameCollectedResourceLog = "cc_calculated_data";
	private static volatile String tableNameCollectedResourceLogDesc = "Performance Store";
	private static volatile long thresholdCollectedResourceLog = 5120;
	private static volatile int thresholdTypeCollectedResourceLog = DBSizeMonitor.THRESHOLD_MBYTE;

	private static volatile String tableNameJobLog = "cc_job_session";
	private static volatile String tableNameJobLogDesc = "Job History";
	private static volatile long thresholdJobLog = 1000;
	private static volatile int thresholdTypeJobLog = DBSizeMonitor.THRESHOLD_COUNT;

	private static volatile String tableNameCrunLog = "cc_crun_session";
	private static volatile String tableNameCrunLogDesc = "Collective Run History";
	private static volatile long thresholdCrunLog = 1000;
	private static volatile int thresholdTypeCrunLog = DBSizeMonitor.THRESHOLD_COUNT;

	// monitor monitor job
	private static volatile boolean jobMonitoring = true;
	private static volatile long thresholdJobRunSession = 100;

	//
	// GETTER and SETTER
	//
	public static synchronized int getStartupDelaySec() {
		return startupDelaySec;
	}

	public static synchronized void setStartupDelaySec(int startupDelaySec) {
		SelfCheckConfig.startupDelaySec = startupDelaySec;
	}

	public static synchronized int getIntervalSec() {
		return intervalSec;
	}

	public static synchronized void setIntervalSec(int intervalSec) {
		SelfCheckConfig.intervalSec = intervalSec;
	}

	public static synchronized int getAlertThreshold() {
		return alertThreshold;
	}

	public static synchronized void setAlertThreshold(int alertThreshold) {
		SelfCheckConfig.alertThreshold = alertThreshold;
	}

	public static synchronized int getThreadPoolSize() {
		return threadPoolSize;
	}

	public static synchronized void setThreadPoolSize(int threadPoolSize) {
		SelfCheckConfig.threadPoolSize = threadPoolSize;
	}

	public static synchronized boolean getEvent() {
		return event;
	}

	public static synchronized void setEvent(boolean event) {
		SelfCheckConfig.event = event;
	}

	public static synchronized boolean getSyslog() {
		return syslog;
	}

	public static synchronized void setSyslog(boolean syslog) {
		SelfCheckConfig.syslog = syslog;
	}

	public static synchronized String[] getSyslogHost() {
		return syslogHost;
	}

	public static synchronized void setSyslogHost(String[] syslogHost) {
		SelfCheckConfig.syslogHost = syslogHost;
	}

	public static synchronized int getSyslogPort() {
		return syslogPort;
	}

	public static synchronized void setSyslogPort(int syslogPort) {
		SelfCheckConfig.syslogPort = syslogPort;
	}

	public static synchronized String getSyslogFacility() {
		return syslogFacility;
	}

	public static synchronized void setSyslogFacility(String syslogFacility) {
		SelfCheckConfig.syslogFacility = syslogFacility;
	}

	public static synchronized String getSyslogSeverity() {
		return syslogSeverity;
	}

	public static synchronized void setSyslogSeverity(String syslogServerity) {
		SelfCheckConfig.syslogSeverity = syslogServerity;
	}

	public static synchronized String getSnmpHost() {
		return snmpHost;
	}

	public static synchronized void setSnmpHost(String snmpHost) {
		SelfCheckConfig.snmpHost = snmpHost;
	}

	public static synchronized String getSnmpCommunity() {
		return snmpCommunity;
	}

	public static synchronized void setSnmpCommunity(String snmpCommunity) {
		SelfCheckConfig.snmpCommunity = snmpCommunity;
	}

	public static synchronized int getSnmpPort() {
		return snmpPort;
	}

	public static synchronized void setSnmpPort(int snmpPort) {
		SelfCheckConfig.snmpPort = snmpPort;
	}

	public static synchronized String getSnmpVersion() {
		return snmpVersion;
	}

	public static synchronized void setSnmpVersion(String snmpVersion) {
		SelfCheckConfig.snmpVersion = snmpVersion;
	}

	public static synchronized int getSnmpTimeoutMSec() {
		return snmpTimeoutMSec;
	}

	public static synchronized void setSnmpTimeoutMSec(int snmpTimeoutMSec) {
		SelfCheckConfig.snmpTimeoutMSec = snmpTimeoutMSec;
	}

	public static synchronized int getSnmpRetries() {
		return snmpRetries;
	}

	public static synchronized void setSnmpRetries(int snmpRetries) {
		SelfCheckConfig.snmpRetries = snmpRetries;
	}

	public static synchronized boolean getJvmHeapMonitoring() {
		return jvmHeapMonitoring;
	}

	public static synchronized void setJvmHeapMonitoring(boolean jvmHeapMonitoring) {
		SelfCheckConfig.jvmHeapMonitoring = jvmHeapMonitoring;
	}

	public static synchronized int getJvmHeapThresholdMByte() {
		return jvmHeapThresholdMByte;
	}

	public static synchronized void setJvmHeapThresholdMByte(
			int jvmHeapThresholdMByte) {
		SelfCheckConfig.jvmHeapThresholdMByte = jvmHeapThresholdMByte;
	}

	public static synchronized boolean getFileSystemMonitoring() {
		return fileSystemMonitoring;
	}

	public static synchronized void setFileSystemMonitoring(
			boolean fileSystemMonitoring) {
		SelfCheckConfig.fileSystemMonitoring = fileSystemMonitoring;
	}

	public static synchronized int getFileSystemDBThresholdPer() {
		return fileSystemDBThresholdPer;
	}

	public static synchronized void setFileSystemDBThresholdPer(
			int fileSystemDBThresholdPer) {
		SelfCheckConfig.fileSystemDBThresholdPer = fileSystemDBThresholdPer;
	}

	public static synchronized int getFileSystemLogThresholdPer() {
		return fileSystemLogThresholdPer;
	}

	public static synchronized void setFileSystemLogThresholdPer(
			int fileSystemLogThresholdPer) {
		SelfCheckConfig.fileSystemLogThresholdPer = fileSystemLogThresholdPer;
	}

	public static synchronized String getMountPointDatabase() {
		return mountPointDatabase;
	}

	public static synchronized void setMountPointDatabase(String mountPointDatabase) {
		SelfCheckConfig.mountPointDatabase = mountPointDatabase;
	}

	public static synchronized String getMountPointLog() {
		return mountPointLog;
	}

	public static synchronized void setMountPointLog(String mountPointLog) {
		SelfCheckConfig.mountPointLog = mountPointLog;
	}

	public static synchronized boolean getSwapOutMonitoring() {
		return swapOutMonitoring;
	}

	public static synchronized void setSwapOutMonitoring(boolean swapOutMonitoring) {
		SelfCheckConfig.swapOutMonitoring = swapOutMonitoring;
	}

	public static synchronized boolean getDatasourceMonitoring() {
		return datasourceMonitoring;
	}

	public static synchronized void setDatasourceMonitoring(
			boolean datasourceMonitoring) {
		SelfCheckConfig.datasourceMonitoring = datasourceMonitoring;
	}

	public static synchronized String getJndiDatasourceHinemos() {
		return jndiDatasourceHinemos;
	}

	public static synchronized void setJndiDatasourceHinemos(
			String jndiDatasourceHinemos) {
		SelfCheckConfig.jndiDatasourceHinemos = jndiDatasourceHinemos;
	}

	public static synchronized boolean getSchedulerMonitoring() {
		return schedulerMonitoring;
	}

	public static synchronized void setSchedulerMonitoring(
			boolean schedulerMonitoring) {
		SelfCheckConfig.schedulerMonitoring = schedulerMonitoring;
	}

	public static synchronized int getSchedulerDelayThresholdSec() {
		return schedulerDelayThresholdSec;
	}

	public static synchronized void setSchedulerDelayThresholdSec(
			int schedulerDelayThresholdSec) {
		SelfCheckConfig.schedulerDelayThresholdSec = schedulerDelayThresholdSec;
	}

	public static synchronized String getJndiDBMSScheduler() {
		return jndiDBMSScheduler;
	}

	public static synchronized void setJndiDBMSScheduler(String jndiDBMSScheduler) {
		SelfCheckConfig.jndiDBMSScheduler = jndiDBMSScheduler;
	}

	public static synchronized String getTriggerGroupDBMS() {
		return triggerGroupDBMS;
	}

	public static synchronized void setTriggerGroupDBMS(String triggerGroupDBMS) {
		SelfCheckConfig.triggerGroupDBMS = triggerGroupDBMS;
	}

	public static synchronized String getTriggerNameDBMS() {
		return triggerNameDBMS;
	}

	public static synchronized void setTriggerNameDBMS(String triggerNameDBMS) {
		SelfCheckConfig.triggerNameDBMS = triggerNameDBMS;
	}

	public static synchronized String getJndiRAMScheduler() {
		return jndiRAMScheduler;
	}

	public static synchronized void setJndiRAMScheduler(String jndiRAMScheduler) {
		SelfCheckConfig.jndiRAMScheduler = jndiRAMScheduler;
	}

	public static synchronized String getTriggerGroupRAM() {
		return triggerGroupRAM;
	}

	public static synchronized void setTriggerGroupRAM(String triggerGroupRAM) {
		SelfCheckConfig.triggerGroupRAM = triggerGroupRAM;
	}

	public static synchronized String getTriggerNameRAM() {
		return triggerNameRAM;
	}

	public static synchronized void setTriggerNameRAM(String triggerNameRAM) {
		SelfCheckConfig.triggerNameRAM = triggerNameRAM;
	}

	public static synchronized boolean getJmsMonitoring() {
		return jmsMonitoring;
	}

	public static synchronized void setJmsMonitoring(boolean jmsMonitoring) {
		SelfCheckConfig.jmsMonitoring = jmsMonitoring;
	}

	public static synchronized int getJmsMessageCountThreshold() {
		return jmsMessageCountThreshold;
	}

	public static synchronized void setJmsMessageCountThreshold(
			int jmsMessageCountThreshold) {
		SelfCheckConfig.jmsMessageCountThreshold = jmsMessageCountThreshold;
	}

	public static synchronized String[] getMonitorQueue() {
		return monitorQueue;
	}

	public static synchronized void setMonitorQueue(String[] monitorQueue) {
		SelfCheckConfig.monitorQueue = monitorQueue;
	}

	public static synchronized String[] getMonitorTopic() {
		return monitorTopic;
	}

	public static synchronized void setMonitorTopic(String[] monitorTopic) {
		SelfCheckConfig.monitorTopic = monitorTopic;
	}

	public static synchronized boolean getSyslogFilterMonitoring() {
		return syslogFilterMonitoring;
	}

	public static synchronized void setSyslogFilterMonitoring(
			boolean syslogFilterMonitoring) {
		SelfCheckConfig.syslogFilterMonitoring = syslogFilterMonitoring;
	}

	public static synchronized boolean getLogTableSizeMonitoring() {
		return logTableSizeMonitoring;
	}

	public static synchronized void setLogTableSizeMonitoring(
			boolean logTableSizeMonitoring) {
		SelfCheckConfig.logTableSizeMonitoring = logTableSizeMonitoring;
	}

	public static synchronized String getJndiLogTableDS() {
		return jndiLogTableDS;
	}

	public static synchronized void setJndiLogTableDS(String jndiLogTableDS) {
		SelfCheckConfig.jndiLogTableDS = jndiLogTableDS;
	}

	public static synchronized String getTableNameEventLog() {
		return tableNameEventLog;
	}

	public static synchronized void setTableNameEventLog(String tableNameEventLog) {
		SelfCheckConfig.tableNameEventLog = tableNameEventLog;
	}

	public static synchronized String getTableNameEventLogDesc() {
		return tableNameEventLogDesc;
	}

	public static synchronized void setTableNameEventLogDesc(
			String tableNameEventLogDesc) {
		SelfCheckConfig.tableNameEventLogDesc = tableNameEventLogDesc;
	}

	public static synchronized long getThresholdEventLog() {
		return thresholdEventLog;
	}

	public static synchronized void setThresholdEventLog(long thresholdEventLog) {
		SelfCheckConfig.thresholdEventLog = thresholdEventLog;
	}

	public static synchronized int getThresholdTypeEventLog() {
		return thresholdTypeEventLog;
	}

	public static synchronized void setThresholdTypeEventLog(
			int thresholdTypeEventLog) {
		SelfCheckConfig.thresholdTypeEventLog = thresholdTypeEventLog;
	}

	public static synchronized String getTableNameCollectedResourceLog() {
		return tableNameCollectedResourceLog;
	}

	public static synchronized void setTableNameCollectedResourceLog(
			String tableNameCollectedResourceLog) {
		SelfCheckConfig.tableNameCollectedResourceLog = tableNameCollectedResourceLog;
	}

	public static synchronized String getTableNameCollectedResourceLogDesc() {
		return tableNameCollectedResourceLogDesc;
	}

	public static synchronized void setTableNameCollectedResourceLogDesc(
			String tableNameCollectedResourceLogDesc) {
		SelfCheckConfig.tableNameCollectedResourceLogDesc = tableNameCollectedResourceLogDesc;
	}

	public static synchronized long getThresholdCollectedResourceLog() {
		return thresholdCollectedResourceLog;
	}

	public static synchronized void setThresholdCollectedResourceLog(
			long thresholdCollectedResourceLog) {
		SelfCheckConfig.thresholdCollectedResourceLog = thresholdCollectedResourceLog;
	}

	public static synchronized int getThresholdTypeCollectedResourceLog() {
		return thresholdTypeCollectedResourceLog;
	}

	public static synchronized void setThresholdTypeCollectedResourceLog(
			int thresholdTypeCollectedResourceLog) {
		SelfCheckConfig.thresholdTypeCollectedResourceLog = thresholdTypeCollectedResourceLog;
	}

	public static synchronized String getTableNameJobLog() {
		return tableNameJobLog;
	}

	public static synchronized void setTableNameJobLog(String tableNameJobLog) {
		SelfCheckConfig.tableNameJobLog = tableNameJobLog;
	}

	public static synchronized String getTableNameJobLogDesc() {
		return tableNameJobLogDesc;
	}

	public static synchronized void setTableNameJobLogDesc(
			String tableNameJobLogDesc) {
		SelfCheckConfig.tableNameJobLogDesc = tableNameJobLogDesc;
	}

	public static synchronized long getThresholdJobLog() {
		return thresholdJobLog;
	}

	public static synchronized void setThresholdJobLog(long thresholdJobLog) {
		SelfCheckConfig.thresholdJobLog = thresholdJobLog;
	}

	public static synchronized int getThresholdTypeJobLog() {
		return thresholdTypeJobLog;
	}

	public static synchronized void setThresholdTypeJobLog(int thresholdTypeJobLog) {
		SelfCheckConfig.thresholdTypeJobLog = thresholdTypeJobLog;
	}

	public static synchronized String getTableNameCrunLog() {
		return tableNameCrunLog;
	}

	public static synchronized void setTableNameCrunLog(String tableNameCrunLog) {
		SelfCheckConfig.tableNameCrunLog = tableNameCrunLog;
	}

	public static synchronized String getTableNameCrunLogDesc() {
		return tableNameCrunLogDesc;
	}

	public static synchronized void setTableNameCrunLogDesc(
			String tableNameCrunLogDesc) {
		SelfCheckConfig.tableNameCrunLogDesc = tableNameCrunLogDesc;
	}

	public static synchronized long getThresholdCrunLog() {
		return thresholdCrunLog;
	}

	public static synchronized void setThresholdCrunLog(long thresholdCrunLog) {
		SelfCheckConfig.thresholdCrunLog = thresholdCrunLog;
	}

	public static synchronized int getThresholdTypeCrunLog() {
		return thresholdTypeCrunLog;
	}

	public static synchronized void setThresholdTypeCrunLog(int thresholdTypeCrunLog) {
		SelfCheckConfig.thresholdTypeCrunLog = thresholdTypeCrunLog;
	}

	public static synchronized Date getLastMonitorDate() {
		return lastMonitorDate;
	}

	public static synchronized String getLastMonitorDateString() {
		return lastMonitorDate == null ? "not yet" : new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(lastMonitorDate);
	}

	public static synchronized void setLastMonitorDate(Date lastMonitorDate) {
		SelfCheckConfig.lastMonitorDate = lastMonitorDate;
	}

	public static synchronized void setLastMonitorDateString(String lastMonitorDate) throws ParseException {
		SelfCheckConfig.setLastMonitorDate(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse(lastMonitorDate));
	}

	public static synchronized boolean getMail() {
		return mail;
	}

	public static synchronized void setMail(boolean mail) {
		SelfCheckConfig.mail = mail;
	}

	public static synchronized String[] getMailAddress() {
		return mailAddress;
	}

	public static synchronized void setMailAddress(String[] mailAddress) {
		SelfCheckConfig.mailAddress = mailAddress;
	}

	public static synchronized String[] getSyslogFilterHost() {
		return syslogFilterHost;
	}

	public static synchronized void setSyslogFilterHost(String[] syslogForwardHost) {
		SelfCheckConfig.syslogFilterHost = syslogForwardHost;
	}

	public static long getThresholdJobRunSession() {
		return thresholdJobRunSession;
	}

	public static boolean getJobMonitoring() {
		return jobMonitoring;
	}

	public static void setJobMonitoring(boolean jobMonitoring) {
		SelfCheckConfig.jobMonitoring = jobMonitoring;
	}

	public static void setThresholdJobRunSession(long thresholdJobRunSession) {
		SelfCheckConfig.thresholdJobRunSession = thresholdJobRunSession;
	}

	public static String getStatusString() {
		String output = "";
		String syslogHost = "";
		String mailAddress = "";
		String syslogForwardHost = "";
		String returnCode = System.getProperty("line.separator");

		output += returnCode;
		output += "LastMonitorDate : " + getLastMonitorDateString() + returnCode;
		output += returnCode;

		output += "StartupDelaySec : " + getStartupDelaySec() + " [sec]" + returnCode;
		output += "IntervalSec : " + getIntervalSec() + " [sec]" + returnCode;
		output += "AlertThreshold : " + getAlertThreshold() + returnCode;
		output += "ThreadPoolSize : " + getThreadPoolSize() + returnCode;
		output += returnCode;

		output += "Event : " + getEvent() + returnCode;
		output += "Syslog : " + getSyslog() + returnCode;
		for (String host : getSyslogHost()) {
			syslogHost += syslogHost.length() == 0 ? host : "," + host;
		}
		output += "SyslogHost : " + syslogHost + returnCode;
		output += "SyslogPort : " + getSyslogPort() + returnCode;
		output += "SyslogFacility : " + getSyslogFacility() + returnCode;
		output += "SyslogSeverity : " + getSyslogSeverity() + returnCode;
		output += "Mail : " + mail + returnCode;
		for (String address : getMailAddress()) {
			mailAddress += mailAddress.length() == 0 ? address : "," + address;
		}
		output += "MailAddress : " + mailAddress + returnCode;
		output += returnCode;

		output += "SnmpHost : " + getSnmpHost() + returnCode;
		output += "SnmpCommunity : " + getSnmpCommunity() + returnCode;
		output += "SnmpPort : " + getSnmpPort() + returnCode;
		output += "SnmpVersion : " + getSnmpVersion() + returnCode;
		output += "SnmpTimeoutMSec : " + getSnmpTimeoutMSec() + " [msec]" + returnCode;
		output += "SnmpRetries : " + getSnmpRetries() + " [count]" + returnCode;
		output += returnCode;

		output += "JVMHeapMonitoring : " + getJvmHeapMonitoring() + returnCode;
		output += "JVMHeapThresholdMByte : " + getJvmHeapThresholdMByte() + " [MByte]" + returnCode;
		output += returnCode;

		output += "FileSystemMonitoring : " + getFileSystemMonitoring() + returnCode;
		output += "MountPointDatabase : " + getMountPointDatabase() + returnCode;
		output += "MountPointLog : " + getMountPointLog() + returnCode;
		output += "FileSystemDBThresholdPer : " + getFileSystemDBThresholdPer() + returnCode;
		output += "FileSystemLogThresholdPer : " + getFileSystemLogThresholdPer() + returnCode;
		output += returnCode;

		output += "SwapOutMonitoring : " + getSwapOutMonitoring() + returnCode;
		output += returnCode;

		output += "DatasourceMonitoring : " + getDatasourceMonitoring() + returnCode;
		output += "JndiDatasourceHinemos : " + getJndiDatasourceHinemos() + returnCode;
		output += returnCode;

		output += "SchedulerMonitoring : " + getSchedulerMonitoring() + returnCode;
		output += "SchedulerDelayThresholdSec : " + getSchedulerDelayThresholdSec() + " [sec]" + returnCode;
		output += "JndiDBMSSchedueler : " + getJndiDBMSScheduler() + returnCode;
		output += "TriggetGroupDBMS : " + getTriggerGroupDBMS() + returnCode;
		output += "TriggerNameDBMS : " + getTriggerNameDBMS() + returnCode;
		output += "JndiRAMScheduler : " + getJndiRAMScheduler() + returnCode;
		output += "TriggerGroupRAM : " + getTriggerGroupRAM() + returnCode;
		output += "TriggerNameRAM : " + getTriggerNameRAM() + returnCode;
		output += returnCode;

		output += "JMSMonitoring : " + getJmsMonitoring() + returnCode;
		output += "JMSMessageCountThreshold : " + getJmsMessageCountThreshold() + returnCode;
		output += returnCode;

		output += "SyslogFilterMonitoring : " + getSyslogFilterMonitoring() + returnCode;
		for (String host : getSyslogFilterHost()) {
			syslogForwardHost += syslogForwardHost.length() == 0 ? host : "," + host;
		}
		output += "SyslogForwardHost : " + syslogForwardHost + returnCode;
		output += returnCode;

		output += "LogTableSizeMonitoring : " + getLogTableSizeMonitoring() + returnCode;
		output += "JndiLogTableDS : " + getJndiLogTableDS() + returnCode;
		// event log
		output += "TableNameEventLog : " + getTableNameEventLog() + returnCode;
		output += "TableNameEventLogDesc : " + getTableNameEventLogDesc() + returnCode;
		output += "ThresholdEventLog : " + getThresholdEventLog() + returnCode;
		output += "ThresholdTypeEventLog : " + getThresholdTypeEventLog() + returnCode;
		// resource collection log
		output += "tableNameCollectedResourceLog : " + getTableNameCollectedResourceLog() + returnCode;
		output += "tableNameCollectedResourceLogDesc : " + getTableNameCollectedResourceLogDesc() + returnCode;
		output += "thresholdCollectedResourceLog : " + getThresholdCollectedResourceLog() + returnCode;
		output += "thresholdTypeCollectedResourceLog : " + getThresholdTypeCollectedResourceLog() + returnCode;
		// job log
		output += "tableNameJobLog : " + getTableNameJobLog() + returnCode;
		output += "tableNameJobLogDesc : " + getTableNameJobLogDesc() + returnCode;
		output += "thresholdJobLog : " + getThresholdJobLog() + returnCode;
		output += "thresholdTypeJobLog : " + getThresholdTypeJobLog() + returnCode;
		// collective run log
		output += "tableNameCrunLog : " + getTableNameCrunLog() + returnCode;
		output += "tableNameCrunLogDesc : " + getTableNameCrunLogDesc() + returnCode;
		output += "thresholdCrunLog : " + getThresholdCrunLog() + returnCode;
		output += "thresholdTypeCrunLog : " + getThresholdTypeCrunLog() + returnCode;

		// job
		output += "jobMonitoring : " + getJobMonitoring() + returnCode;
		output += "thresholdJobRunSession : " + getThresholdJobRunSession() + returnCode;

		return output;
	}

}
