/*

Copyright (C) 2010 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.selfcheck.jmx;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

import org.jboss.system.ServiceMBeanSupport;

import com.clustercontrol.selfcheck.SelfCheckConfig;
import com.clustercontrol.selfcheck.SelfCheckTaskSubmitter;

public class SelfCheckService extends ServiceMBeanSupport implements SelfCheckServiceMBean {

	private static volatile SelfCheckConfig config = new SelfCheckConfig();
	private static ScheduledExecutorService scheduler;
	private static SelfCheckTaskSubmitter submitter;

	/**
	 * SelfCheckServiceのコンストラクタ
	 */
	public SelfCheckService() {
		/** メイン処理 */
	}

	/**
	 * MBeanの初期化処理
	 */
	@Override
	public void createService() throws Exception {
		/** メイン処理 */
		if (log.isInfoEnabled()) log.info("creating SelfCheckService...");
		if (log.isInfoEnabled()) log.info("created SelfCheckService successfully.");
	}

	/**
	 * MBeanの開始処理
	 */
	@Override
	public void startService() throws Exception {
		/** メイン処理 */
		if (log.isInfoEnabled()) log.info("starting SelfCheckService... (interval = " + config.getIntervalSec() + " [sec], startupDelay = " + config.getStartupDelaySec() + " [sec])");

		if (log.isInfoEnabled())  log.info("intitializing scheduler...");
		scheduler = Executors.newSingleThreadScheduledExecutor(
				new ThreadFactory() {
					@Override
					public Thread newThread(Runnable r) {
						return new Thread(r, "SelfCheckScheduler");
					}
				}
		);
		if (log.isInfoEnabled()) log.info("initialized scheduler successfully.");

		submitter = new SelfCheckTaskSubmitter();
		scheduler.scheduleWithFixedDelay(
				submitter,
				config.getStartupDelaySec() * 1000,
				config.getIntervalSec() * 1000,
				TimeUnit.MILLISECONDS
		);
		if (log.isInfoEnabled()) log.info("started SelfCheckService successfully.");
	}

	/**
	 * MBeanの停止処理
	 */
	@Override
	public void stopService() throws Exception {
		/** メイン処理 */
		if (log.isInfoEnabled()) log.info("stopping SelfCheckService...");
		scheduler.shutdown();
		if (log.isInfoEnabled()) log.info("stopped SelfCheckService successfully.");
	}

	/**
	 * MBeanの削除処理
	 */
	@Override
	public void destroyService() throws Exception {
		/** メイン処理 */
		if (log.isInfoEnabled()) log.info("destroying SelfCheckService...");
		if (log.isInfoEnabled()) log.info("destroyed SelfCheckService successfully.");
	}

	public void restart() throws Exception {
		if (log.isInfoEnabled()) log.info("restarting SelfCheckService...");
		if (scheduler != null && ! scheduler.isShutdown()) {
			stopService();
		}
		startService();
		if (log.isInfoEnabled()) log.info("restarted SelfCheckService successfully.");
	}

	@Override
	public int getAlertThreshold() {
		return config.getAlertThreshold();
	}

	@Override
	public boolean getDatasourceMonitoring() {
		return config.getDatasourceMonitoring();
	}

	@Override
	public boolean getFileSystemMonitoring() {
		return config.getFileSystemMonitoring();
	}

	@Override
	public int getIntervalSec() {
		return config.getIntervalSec();
	}

	@Override
	public boolean getJMSMonitoring() {
		return config.getJmsMonitoring();
	}

	@Override
	public int getJMSMessageCountThreshold() {
		return config.getJmsMessageCountThreshold();
	}

	@Override
	public boolean getJVMHeapMonitoring() {
		return config.getJvmHeapMonitoring();
	}

	@Override
	public int getJVMHeapThresholdMByte() {
		return config.getJvmHeapThresholdMByte();
	}

	@Override
	public String getJndiDBMSScheduler() {
		return config.getJndiDBMSScheduler();
	}

	@Override
	public String getJndiDatasourceHinemos() {
		return config.getJndiDatasourceHinemos();
	}

	@Override
	public String getJndiRAMScheduler() {
		return config.getJndiRAMScheduler();
	}

	@Override
	public String getMountPointDatabase() {
		return config.getMountPointDatabase();
	}

	@Override
	public String getMountPointLog() {
		return config.getMountPointLog();
	}

	@Override
	public int getSchedulerDelayThresholdSec() {
		return config.getSchedulerDelayThresholdSec();
	}

	@Override
	public boolean getSchedulerMonitoring() {
		return config.getSchedulerMonitoring();
	}

	@Override
	public String getSnmpCommunity() {
		return config.getSnmpCommunity();
	}

	@Override
	public int getSnmpPort() {
		return config.getSnmpPort();
	}

	@Override
	public int getSnmpRetries() {
		return config.getSnmpRetries();
	}

	@Override
	public int getSnmpTimeoutMSec() {
		return config.getSnmpTimeoutMSec();
	}

	@Override
	public String getSnmpVersion() {
		return config.getSnmpVersion();
	}

	@Override
	public int getStartupDelaySec() {
		return config.getStartupDelaySec();
	}

	@Override
	public boolean getSwapOutMonitoring() {
		return config.getSwapOutMonitoring();
	}

	@Override
	public boolean getSyslogFilterMonitoring() {
		return config.getSyslogFilterMonitoring();
	}

	@Override
	public int getThreadPoolSize() {
		return config.getThreadPoolSize();
	}

	@Override
	public String getTriggerGroupDBMS() {
		return config.getTriggerGroupDBMS();
	}

	@Override
	public String getTriggerGroupRAM() {
		return config.getTriggerGroupRAM();
	}

	@Override
	public String getTriggerNameDBMS() {
		return config.getTriggerNameDBMS();
	}

	@Override
	public String getTriggerNameRAM() {
		return config.getTriggerNameRAM();
	}

	@Override
	public void setAlertThreshold(int count) {
		config.setAlertThreshold(count);
	}

	@Override
	public void setDatasourceMonitoring(boolean enable) {
		config.setDatasourceMonitoring(enable);
	}

	@Override
	public void setFileSystemMonitoring(boolean enable) {
		config.setFileSystemMonitoring(enable);
	}

	@Override
	public void setIntervalSec(int sec) {
		config.setIntervalSec(sec);
	}

	@Override
	public void setJMSMonitoring(boolean enable) {
		config.setJmsMonitoring(enable);
	}

	@Override
	public void setJMSMessageCountThreshold(int count) {
		config.setJmsMessageCountThreshold(count);
	}

	@Override
	public void setJVMHeapMonitoring(boolean enable) {
		config.setJvmHeapMonitoring(enable);
	}

	@Override
	public void setJVMHeapThresholdMByte(int mbyte) {
		config.setJvmHeapThresholdMByte(mbyte);
	}

	@Override
	public void setJndiDBMSScheduler(String jndi) {
		config.setJndiDBMSScheduler(jndi);
	}

	@Override
	public void setJndiDatasourceHinemos(String jndi) {
		config.setJndiDatasourceHinemos(jndi);
	}

	@Override
	public void setJndiRAMScheduler(String jndi) {
		config.setJndiRAMScheduler(jndi);
	}

	@Override
	public void setMountPointDatabase(String mountPoint) {
		config.setMountPointDatabase(mountPoint);
	}

	@Override
	public void setMountPointLog(String mountPoint) {
		config.setMountPointLog(mountPoint);
	}

	@Override
	public void setSchedulerDelayThresholdSec(int sec) {
		config.setSchedulerDelayThresholdSec(sec);
	}

	@Override
	public void setSchedulerMonitoring(boolean enable) {
		config.setSchedulerMonitoring(enable);
	}

	@Override
	public String getSnmpHost() {
		return config.getSnmpHost();
	}

	@Override
	public void setSnmpHost(String host) {
		config.setSnmpHost(host);
	}

	@Override
	public void setSnmpCommunity(String community) {
		config.setSnmpCommunity(community);
	}

	@Override
	public void setSnmpPort(int port) {
		config.setSnmpPort(port);
	}

	@Override
	public void setSnmpRetries(int count) {
		config.setSnmpRetries(count);
	}

	@Override
	public void setSnmpTimeoutMSec(int msec) {
		config.setSnmpTimeoutMSec(msec);
	}

	@Override
	public void setSnmpVersion(String version) {
		config.setSnmpVersion(version);
	}

	@Override
	public void setStartupDelaySec(int sec) {
		config.setStartupDelaySec(sec);
	}

	@Override
	public void setSwapOutMonitoring(boolean enable) {
		config.setSwapOutMonitoring(enable);
	}

	@Override
	public void setSyslogFilterMonitoring(boolean enable) {
		config.setSyslogFilterMonitoring(enable);
	}

	@Override
	public void setThreadPoolSize(int size) {
		config.setThreadPoolSize(size);
	}

	@Override
	public void setTriggerGroupDBMS(String group) {
		config.setTriggerGroupDBMS(group);
	}

	@Override
	public void setTriggerGroupRAM(String group) {
		config.setTriggerGroupRAM(group);
	}

	@Override
	public void setTriggerNameDBMS(String name) {
		config.setTriggerNameDBMS(name);
	}

	@Override
	public void setTriggerNameRAM(String name) {
		config.setTriggerNameRAM(name);
	}

	@Override
	public boolean getEvent() {
		return config.getEvent();
	}

	@Override
	public boolean getSyslog() {
		return config.getSyslog();
	}

	@Override
	public String getSyslogFacility() {
		return config.getSyslogFacility();
	}

	@Override
	public String[] getSyslogHost() {
		return config.getSyslogHost();
	}

	@Override
	public int getSyslogPort() {
		return config.getSyslogPort();
	}

	@Override
	public String getSyslogSeverity() {
		return config.getSyslogSeverity();
	}

	@Override
	public void setEvent(boolean enable) {
		config.setEvent(enable);
	}

	@Override
	public void setSyslog(boolean enable) {
		config.setSyslog(enable);
	}

	@Override
	public void setSyslogFacility(String facility) {
		config.setSyslogFacility(facility);
	}

	@Override
	public void setSyslogHost(String[] hosts) {
		config.setSyslogHost(hosts);
	}

	@Override
	public void setSyslogPort(int port) {
		config.setSyslogPort(port);
	}

	@Override
	public void setSyslogSeverity(String severity) {
		config.setSyslogSeverity(severity);
	}

	@Override
	public String showStatus() {
		return config.getStatusString();
	}

	@Override
	public int getFileSystemDBThresholdPer() {
		return config.getFileSystemDBThresholdPer();
	}

	@Override
	public int getFileSystemLogThresholdPer() {
		return config.getFileSystemLogThresholdPer();
	}

	@Override
	public void setFileSystemDBThresholdPer(int percent) {
		config.setFileSystemDBThresholdPer(percent);
	}

	@Override
	public void setFileSystemLogThresholdPer(int percent) {
		config.setFileSystemLogThresholdPer(percent);
	}

	@Override
	public String[] getMonitorQueue() {
		return config.getMonitorQueue();
	}

	@Override
	public String[] getMonitorTopic() {
		return config.getMonitorTopic();
	}

	@Override
	public void setMonitorQueue(String[] queues) {
		config.setMonitorQueue(queues);
	}

	@Override
	public void setMonitorTopic(String[] topics) {
		config.setMonitorTopic(topics);
	}

	@Override
	public String getJndiLogTableDS() {
		return config.getJndiLogTableDS();
	}

	@Override
	public boolean getLogTableSizeMonitoring() {
		return config.getLogTableSizeMonitoring();
	}

	@Override
	public String getTableNameCollectedResourceLog() {
		return config.getTableNameCollectedResourceLog();
	}

	@Override
	public String getTableNameCollectedResourceLogDesc() {
		return config.getTableNameCollectedResourceLogDesc();
	}

	@Override
	public String getTableNameCrunLog() {
		return config.getTableNameCrunLog();
	}

	@Override
	public String getTableNameCrunLogDesc() {
		return config.getTableNameCrunLogDesc();
	}

	@Override
	public String getTableNameEventLog() {
		return config.getTableNameEventLog();
	}

	@Override
	public String getTableNameEventLogDesc() {
		return config.getTableNameEventLogDesc();
	}

	@Override
	public String getTableNameJobLog() {
		return config.getTableNameJobLog();
	}

	@Override
	public String getTableNameJobLogDesc() {
		return config.getTableNameJobLogDesc();
	}

	@Override
	public long getThresholdCollectedResourceLog() {
		return config.getThresholdCollectedResourceLog();
	}

	@Override
	public long getThresholdCrunLog() {
		return config.getThresholdCrunLog();
	}

	@Override
	public long getThresholdEventLog() {
		return config.getThresholdEventLog();
	}

	@Override
	public long getThresholdJobLog() {
		return config.getThresholdJobLog();
	}

	@Override
	public int getThresholdTypeCollectedResourceLog() {
		return config.getThresholdTypeCollectedResourceLog();
	}

	@Override
	public int getThresholdTypeCrunLog() {
		return config.getThresholdTypeCrunLog();
	}

	@Override
	public int getThresholdTypeEventLog() {
		return config.getThresholdTypeEventLog();
	}

	@Override
	public int getThresholdTypeJobLog() {
		return config.getThresholdTypeJobLog();
	}

	@Override
	public void setJndiLogTableDS(String jndi) {
		config.setJndiLogTableDS(jndi);
	}

	@Override
	public void setLogTableSizeMonitoring(boolean enable) {
		config.setLogTableSizeMonitoring(enable);
	}

	@Override
	public void setTableNameCollectedResourceLog(String tableName) {
		config.setTableNameCollectedResourceLog(tableName);
	}

	@Override
	public void setTableNameCollectedResourceLogDesc(String desc) {
		config.setTableNameCollectedResourceLogDesc(desc);
	}

	@Override
	public void setTableNameCrunLog(String tableName) {
		config.setTableNameCrunLog(tableName);
	}

	@Override
	public void setTableNameCrunLogDesc(String desc) {
		config.setTableNameCrunLogDesc(desc);
	}

	@Override
	public void setTableNameEventLog(String tableName) {
		config.setTableNameEventLog(tableName);
	}

	@Override
	public void setTableNameEventLogDesc(String desc) {
		config.setTableNameEventLogDesc(desc);
	}

	@Override
	public void setTableNameJobLog(String tableName) {
		config.setTableNameJobLog(tableName);
	}

	@Override
	public void setTableNameJobLogDesc(String desc) {
		config.setTableNameJobLogDesc(desc);
	}

	@Override
	public void setThresholdCollectedResourceLog(long threshold) {
		config.setThresholdCollectedResourceLog(threshold);
	}

	@Override
	public void setThresholdCrunLog(long threshold) {
		config.setThresholdCrunLog(threshold);
	}

	@Override
	public void setThresholdEventLog(long threshold) {
		config.setThresholdEventLog(threshold);
	}

	@Override
	public void setThresholdJobLog(long threshold) {
		config.setThresholdJobLog(threshold);
	}

	@Override
	public void setThresholdTypeCollectedResourceLog(int type) {
		config.setThresholdTypeCollectedResourceLog(type);
	}

	@Override
	public void setThresholdTypeCrunLog(int type) {
		config.setThresholdTypeCrunLog(type);
	}

	@Override
	public void setThresholdTypeEventLog(int type) {
		config.setThresholdTypeEventLog(type);
	}

	@Override
	public void setThresholdTypeJobLog(int type) {
		config.setThresholdTypeJobLog(type);
	}

	@Override
	public String getLastMonitorDate() {
		return config.getLastMonitorDateString();
	}

	@Override
	public void setLastMonitorDate(String date) throws Exception {
		config.setLastMonitorDateString(date);
	}

	@Override
	public boolean getMail() {
		return config.getMail();
	}

	@Override
	public String[] getSyslogForwardHost() {
		return config.getSyslogFilterHost();
	}

	@Override
	public void setMail(boolean enable) {
		config.setMail(enable);
	}

	@Override
	public void setSyslogForwardHost(String[] hosts) {
		config.setSyslogFilterHost(hosts);
	}

	@Override
	public String[] getMailAddress() {
		return config.getMailAddress();
	}

	@Override
	public void setMailAddress(String[] addresses) {
		config.setMailAddress(addresses);
	}

	@Override
	public boolean getJobMonitoring() {
		return config.getJobMonitoring();
	}

	@Override
	public void setJobMonitoring(boolean jobMonitoring) {
		config.setJobMonitoring(jobMonitoring);
	}

	@Override
	public long getThresholdJobRunSession() {
		return config.getThresholdJobRunSession();
	}

	@Override
	public void setThresholdJobRunSession(long thresholdJobRunSession) {
		config.setThresholdJobRunSession(thresholdJobRunSession);
	}
}

