/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmp.ejb.entity;

import javax.ejb.EntityBean;

/**
 * SNMP監視の設定情報を管理するEntity Bean <BR>
 * @ejb.bean name="MonitorSnmpInfo"
 *           jndi-name="MonitorSnmpInfo"
 *           type="CMP"
 *           schema="MonitorSnmpInfo"
 *           cmp-version="2.x"
 *           data-source="java:/DefaultDS"
 *           view-type="local"
 *           primkey-field="monitorId"
 * 
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 *  @jboss.container-configuration
 *     name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @jboss.persistence
 *    datasource="java:/DefaultDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_monitor_snmp_info"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 * 
 *  @ejb.permission
 *     unchecked="true"
 * 
 *  @ejb.persistence
 *   table-name="cc_monitor_snmp_info"
 * 
 *  @ejb.finder
 *    query="SELECT OBJECT(a) FROM MonitorSnmpInfo as a"
 *    signature="java.util.Collection findAll()"
 *
 * @ejb.pk
 *    class="java.lang.String"
 * 
 */
public abstract class MonitorSnmpInfoBean implements EntityBean {

	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.create-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public java.lang.String ejbCreate(
			String monitorId,
			String snmpOid,
			Integer convertFlg
	) throws javax.ejb.CreateException {

		this.setMonitorId(monitorId);
		this.setSnmpOid(snmpOid);
		this.setConvertFlg(convertFlg);
		return null;
	}

	/**
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorId.
	 */
	public abstract String getMonitorId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorId The monitorId to set.
	 */
	public abstract void setMonitorId(String monitorId);

	/**
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="convert_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the convertFlg.
	 */
	public abstract Integer getConvertFlg();

	/**
	 * @ejb.interface-method
	 * 
	 * @param convertFlg The convertFlg to set.
	 */
	public abstract void setConvertFlg(Integer convertFlg);

	/**
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="snmp_oid"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the snmpOid.
	 */
	public abstract String getSnmpOid();

	/**
	 * @ejb.interface-method
	 * 
	 * @param snmpOid The snmpOid to set.
	 */
	public abstract void setSnmpOid(String snmpOid);


}
