/*

Copyright (C) 2008 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.factory;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.commons.scheduler.TriggerScheduler;
import com.clustercontrol.commons.scheduler.TriggerSchedulerException;
import com.clustercontrol.monitor.run.factory.AddMonitorTrapValueType;
import com.clustercontrol.snmptrap.bean.TrapCheckInfo;
import com.clustercontrol.snmptrap.ejb.entity.MonitorTrapInfoUtil;
import com.clustercontrol.snmptrap.util.CharsetUtil;

/**
 * SNMPTRAP監視情報を登録するクラス<BR>
 *
 * @version 4.0.0
 * @since 4.0.0
 */
public class AddMonitorTrap extends AddMonitorTrapValueType {

	private static Log m_log = LogFactory.getLog( AddMonitorTrap.class );

	/**
	 * SNMPトラップ監視設定の追加(追加時に文字コードをチェック)
	 */
	@Override
	protected boolean addMonitorInfo(String user) throws CreateException,
	NamingException, HinemosUnknown, TriggerSchedulerException {
		CharsetUtil.checkCharset(m_monitorInfo);

		return super.addMonitorInfo(user);
	}

	@Override
	protected boolean addCheckInfo() throws CreateException, NamingException {

		m_log.debug("addCheckInfo() : start");

		// SNMPTRAP監視情報を登録
		TrapCheckInfo trap = m_monitorInfo.getTrapCheckInfo();
		if(m_log.isDebugEnabled()){
			m_log.debug("addCheckInfo() : " +
					" MonitorId = " + trap.getMonitorId() +
					",CommunityName = " + trap.getCommunityName() +
					",CheckMode = " + trap.getCheckMode() +
					",CommunityCheck = " + trap.getCommunityCheck() +
					",CharsetConvert = " + trap.getCharsetConvert() +
					",CharsetName = " + trap.getCharsetName());
		}

		MonitorTrapInfoUtil.getLocalHome().create(
				trap.getMonitorId(),
				trap.getCommunityName(),
				trap.getCheckMode(),
				trap.getCommunityCheck(),
				trap.getCharsetConvert(),
				trap.getCharsetName());

		m_log.debug("addCheckInfo() : end");
		return true;
	}

	/**
	 * スケジュール実行の遅延時間を返します。
	 */
	@Override
	protected int getDelayTime() {
		return 0;
	}

	/**
	 * スケジュール実行種別を返します。
	 */
	@Override
	protected String getTriggerType() {
		return TriggerScheduler.TRIGGER_TYPE_NONE;
	}
}
