/*

 Copyright (C) 2012 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.notify.bean.OutputBasicInfo;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;
import com.clustercontrol.snmptrap.bean.SnmpTrapV1;

/**
 * snmptrap監視の通知実装のインタフェース(シングル版)
 */
public class SnmpTrapDirectNotifier extends AbstractSnmpTrapNotifier {

	private static final Log _log = LogFactory.getLog(SnmpTrapDirectNotifier.class);

	@Override
	public void put(SnmpTrapV1 snmptrap, String monitorId, String notifyGroupId, int priority,
			String facilityId, String facilityPath, String application, String msg, String msgOrig) {

		OutputBasicInfo info = new OutputBasicInfo();

		info.setMonitorId(monitorId);
		info.setPluginId(HinemosModuleConstant.MONITOR_SNMPTRAP);
		info.setSubKey(snmptrap.enterpriseId + "_" + snmptrap.genericId + "_" + snmptrap.specificId);
		info.setPriority(priority);

		info.setApplication(application);
		info.setFacilityId(facilityId);
		info.setScopeText(facilityPath);
		info.setGenerationDate(snmptrap.receivedTime);

		msg = replaceUnsafeCharacter(msg);
		msgOrig = replaceUnsafeCharacter(msgOrig);

		if (priority == PriorityConstant.TYPE_INFO) {
			info.setMessageId(MESSAGE_ID_INFO);
		} else if (priority == PriorityConstant.TYPE_WARNING) {
			info.setMessageId(MESSAGE_ID_WARNING);
		} else if (priority == PriorityConstant.TYPE_CRITICAL) {
			info.setMessageId(MESSAGE_ID_CRITICAL);
		} else {
			info.setMessageId(MESSAGE_ID_UNKNOWN);
		}

		if (msg.length() > _messageMaxLength) {
			info.setMessage(msg.substring(0, _messageMaxLength));
		} else {
			info.setMessage(msg);
		}

		info.setMessageOrg(msgOrig);

		try {
			NotifyControllerLocal notifyCtrl = NotifyControllerUtil.getLocalHome().create();

			notifyCtrl.notify(info, notifyGroupId);
		} catch (Exception e) {
			_log.warn("unexpected internal error. ", e);
		}

	}

	@Override
	public void shutdown() {
		// TODO Auto-generated method stub

	}

}
