package com.clustercontrol.snmptrap.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterUtil;

/**
 * SNMPTRAP監視のキャッシュ
 *
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class SnmpTrapMasterCache {
	private static Log m_log = LogFactory.getLog( SnmpTrapMasterCache.class );

	private static Object lock = new Object();
	private static ConcurrentHashMap<SnmpTrapMasterPK, SnmpTrapMasterInfo> trapMstCache = new ConcurrentHashMap<SnmpTrapMasterPK, SnmpTrapMasterInfo>();

	static {
		refresh();
	}

	/**
	 * キャッシュのリフレッシュ
	 * このメソッドはsynchronizedの内部で呼ぶこと。
	 */
	private static void refresh() {
		if (trapMstCache.isEmpty()) {
			m_log.info("refresh SnmpTrapMasterCache");
			try{
				Collection<SnmpTrapMasterLocal> c = SnmpTrapMasterUtil.getLocalHome().findAll();
				for(SnmpTrapMasterLocal local : c){
					SnmpTrapMasterInfo info = new SnmpTrapMasterInfo();
					info.setMib(local.getMib());
					info.setTrapOid(local.getTrapOid());
					info.setGenericId(local.getGenericId());
					info.setSpecificId(local.getSpecificId());
					info.setUei(local.getUei());
					info.setPriority(local.getPriority());
					info.setLogmsg(local.getLogmsg());
					info.setDescr(local.getDescr());
					trapMstCache.put((SnmpTrapMasterPK)local.getPrimaryKey(), info);
				}
			} catch (Exception e){
				m_log.error("trapMstCache : " + e.getMessage(), e);
			}
		}
	}

	public static void clear() {
		synchronized (lock) {
			trapMstCache.clear();
		}
	}

	public static ArrayList<SnmpTrapMasterInfo> getMasterList(String mib){
		synchronized(lock) {
			refresh();
			ArrayList<SnmpTrapMasterInfo> mstList = new ArrayList<SnmpTrapMasterInfo>();
			if(mib == null || mib.equals("")){
				for(SnmpTrapMasterPK pk : trapMstCache.keySet()){
					mstList.add(trapMstCache.get(pk));
				}
			}
			else{
				for(SnmpTrapMasterPK pk : trapMstCache.keySet()){
					if(mib.equals(trapMstCache.get(pk).getMib())){
						mstList.add(trapMstCache.get(pk));
					}
				}
			}
			return mstList;
		}
	}

	public static SnmpTrapMasterInfo findMasterInfo(String trapOid, int genericId, int specificId){
		synchronized(lock) {
			refresh();
			ArrayList<SnmpTrapMasterInfo> mstList = new ArrayList<SnmpTrapMasterInfo>();
			for(SnmpTrapMasterPK pk : trapMstCache.keySet()){
				if(trapOid.equals(trapMstCache.get(pk).getTrapOid()) &&
						genericId == trapMstCache.get(pk).getGenericId() &&
						specificId == trapMstCache.get(pk).getSpecificId()){
					mstList.add(trapMstCache.get(pk));
				}
			}
			if(mstList.size() >= 1){
				if(mstList.size() != 1 ){
					m_log.warn("SnmpTrapMasterInfo() : Multiple OID were found in trap master database. (Must be found only one OID)");
				}

				return mstList.get(0);
			}
			else {
				SnmpTrapMasterInfo info = new SnmpTrapMasterInfo();
				info.setTrapOid(trapOid);
				info.setMib(null);
				return info;
			}
		}
	}

	public static SnmpTrapMasterInfo getMasterInfo (SnmpTrapMasterPK pk) {
		synchronized(lock) {
			refresh();
			return trapMstCache.get(pk);
		}
	}
}
