/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.sql.factory;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import com.clustercontrol.commons.scheduler.TriggerScheduler;
import com.clustercontrol.monitor.run.factory.AddMonitor;
import com.clustercontrol.monitor.run.factory.AddMonitorStringValueType;
import com.clustercontrol.sql.util.ControlSqlInfo;

/**
 * SQL監視 文字列監視設定を登録するファクトリークラス<BR>
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class AddMonitorSqlString extends AddMonitorStringValueType{

	/* (non-Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#addCheckInfo()
	 */
	@Override
	protected boolean addCheckInfo() throws CreateException, NamingException{

		// SQL監視情報を追加
		ControlSqlInfo sql = new ControlSqlInfo(m_monitorInfo.getMonitorId(), m_monitorInfo.getMonitorTypeId());
		return sql.add(m_monitorInfo.getSqlCheckInfo());
	}

	/**
	 * スケジュール実行の遅延時間を返します。
	 */
	@Override
	protected int getDelayTime() {
		return AddMonitor.getDelayTimeBasic(m_monitorInfo);
	}

	/**
	 * スケジュール実行種別を返します。
	 */
	@Override
	protected String getTriggerType() {
		return TriggerScheduler.TRIGGER_TYPE_SIMPLE;
	}
}
