package com.clustercontrol.ws.endpoint;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;

import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.security.auth.login.LoginContext;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.naming.NamingContextFactory;
import org.jboss.security.auth.callback.UsernamePasswordHandler;
import org.jboss.util.Base64;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidUserPass;
import com.clustercontrol.accesscontrol.ejb.session.AccessControllerLocal;
import com.clustercontrol.accesscontrol.ejb.session.AccessControllerLocalHome;
import com.sun.net.httpserver.HttpExchange;

// openJDK
// import java.util.prefs.Base64;

public class HttpAuthenticator{
	private static Log m_log = LogFactory.getLog( HttpAuthenticator.class );

	public static void authCheck(WebServiceContext wsContext, ArrayList<String> roleList)
	throws InvalidUserPass, InvalidRole, HinemosUnknown {

		String username = null; // "HINEMOS_AGENT";
		String password = null; // "HINEMOS_AGENT";
		String account = null; // username + ":" + password

		account = getAccount(wsContext);
		username = account.split(":")[0];
		password = account.split(":")[1];
		m_log.trace("username=" + username + ", password=" + password);

		AccessControllerLocal local = null;
		try {
			NamingContext namingContext = HttpAuthenticator.getContext(account);
			AccessControllerLocalHome localHome =
				(AccessControllerLocalHome)
				namingContext.lookup(AccessControllerLocalHome.JNDI_NAME);
			local = localHome.create();
		} catch (CreateException e) {
			m_log.warn("createCache : " + e.getMessage());
			throw new HinemosUnknown("createCache : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
		} catch (NamingException e) {
			m_log.warn("createCache : " + e.getMessage());
			throw new HinemosUnknown("createCache : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
		} catch (Exception e) {
			String message = "createCache, " + e.getClass().getCanonicalName() + " : " + e.getMessage();
			m_log.warn(message);
			m_log.debug(message, e);
			throw new HinemosUnknown("createCache : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
		}

		// 認証に失敗したら、Exceptionが発生する。
		try{
			local.getUserInfoByPassword(username, password, roleList);
		} catch (InvalidUserPass e) {
			m_log.warn("HTTP attestation failure : invalid user. user = " + username);
			throw e;
		} catch (InvalidRole e) {
			m_log.warn("HTTP attestation failure : invalid role. user = " + username);
			throw e;
		} catch (HinemosUnknown e) {
			m_log.warn("HTTP attestation failure : unknown error. user = " + username, e);
			throw e;
		}
	}

	/**
	 * username + ":" + password
	 * という形でアカウントを取得する。
	 * @param wsContext
	 * @return
	 */
	public static String getAccount(WebServiceContext wsContext) throws InvalidUserPass {
		MessageContext messageContext = wsContext.getMessageContext();
		Map map = (Map)messageContext.get(MessageContext.HTTP_REQUEST_HEADERS);

		LinkedList auth = (LinkedList)map.get("Authorization");
		if (auth == null || auth.size() == 0) {
			String message = "Authorization does not exist";
			m_log.warn(message);
			throw new InvalidUserPass(message);
		}

		/*
		 * account = "Basic SElORU1PU19BR0VOVDpISU5FTU9TX0FHRU5U"
		 * という形式。
		 */
		String accountBase64 = (String)(auth.get(0));
		m_log.trace("accountBase64 : " + accountBase64);
		if (!"Basic".equalsIgnoreCase(accountBase64.split(" ")[0])) {
			m_log.warn("Basic auth does not exist : " + accountBase64.split(" ")[0]);
		}
		accountBase64 = accountBase64.split(" ")[1];
		return new String(Base64.decode(accountBase64));
	}


	public static NamingContext getContext(String account) {
		String uid = null;
		String password = null;

		uid = account.split(":")[0];
		password = account.split(":")[1];
		m_log.trace("uid=" + uid + ", pass=" + password);

		//接続先URL取得
		Hashtable<String, String> props = new Hashtable<String, String>();
		NamingContext namingContext = null;
		try {
			UsernamePasswordHandler handler = new UsernamePasswordHandler(uid, password.toCharArray());
			LoginContext m_loginContext = new LoginContext("client-login", handler);
			m_loginContext.login();
			NamingContextFactory ncf = new NamingContextFactory();
			namingContext = (NamingContext) ncf.getInitialContext(props);
		} catch (Exception e) {
			m_log.warn("getContext : " + e.getMessage(), e);
		}
		return namingContext;
	}

	/**
	 * 操作ログ用にuser@[ipaddress]の形式でアクセス元情報を取得する
	 * 
	 * @param wsContext
	 * @return
	 * @throws InvalidUserPass
	 */
	public static String getUserAccountString(WebServiceContext wsContext) throws InvalidUserPass {
		m_log.debug("getUserAccountString()");

		String username = "";
		String ipAddress = "";

		// UserName
		username = getAccount(wsContext).split(":")[0];

		// Source IPAddress(HTTP Only)
		MessageContext messageContext = wsContext.getMessageContext();
		HttpExchange exchange = (HttpExchange)messageContext.get("com.sun.xml.internal.ws.http.exchange");
		if(exchange != null & exchange.getRemoteAddress() != null && exchange.getRemoteAddress().getAddress() != null){
			ipAddress = exchange.getRemoteAddress().getAddress().toString();
		}

		return username + "@[" + ipAddress.replaceAll("/", "") + "]";
	}
}
