/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud;

import com.clustercontrol.cloud.plugin.action.ActionPluginManager;
import com.clustercontrol.cloud.plugin.action.IActionPluginManager;
import com.clustercontrol.cloud.presenter.CloudResourceManager;
import com.clustercontrol.cloud.presenter.EndpointManager;
import com.clustercontrol.cloud.presenter.ICloudResourceManager;
import com.clustercontrol.cloud.presenter.IEndpointManager;
import java.io.File;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class Activator
extends AbstractUIPlugin {
    public static String ID = "com.clustercontrol.cloud.base";
    private static Activator plugin;
    private static String pluginPath;
    private CloudResourceManager cloudResourceManager;
    private static EndpointManager endpointManager;
    private ActionPluginManager actionPluginManager;
    private Boolean enterprisePluginedFlg = false;

    public Activator() {
        plugin = this;
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerImage(registry, "user", "user.png");
        this.registerImage(registry, "account", "account.png");
        this.registerImage(registry, "aws-box", "aws-box.png");
    }

    private void registerImage(ImageRegistry registry, String key, String fileName) {
        try {
            URL url = new URL(Activator.getDefault().getBundle().getEntry("/"), "icons/" + fileName);
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            registry.put(key, desc);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static Activator getDefault() {
        return plugin;
    }

    public ICloudResourceManager getCloudResourceManager() {
        if (this.cloudResourceManager == null) {
            this.cloudResourceManager = new CloudResourceManager(endpointManager);
        }
        return this.cloudResourceManager;
    }

    public void releaseCloudManager() {
        this.cloudResourceManager = null;
    }

    public static IEndpointManager getEndpointManager() {
        return endpointManager;
    }

    public IActionPluginManager getActionPluginManager() {
        if (this.actionPluginManager == null) {
            this.actionPluginManager = new ActionPluginManager();
        }
        return this.actionPluginManager;
    }

    public static String getPluginPath() {
        if (pluginPath == null) {
            URL entry = Activator.getDefault().getBundle().getEntry("/");
            try {
                String url = FileLocator.resolve((URL)entry).toString();
                url = url.replaceAll(" ", "%20");
                pluginPath = new File(new URI(url)).getAbsolutePath();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
        }
        return pluginPath;
    }

    public Boolean isEnterprisePlugined() {
        return this.enterprisePluginedFlg;
    }

    public void setEnterprisePluginedFlg(Boolean enterprisePluginedflg) {
        this.enterprisePluginedFlg = enterprisePluginedflg;
    }

    static {
        endpointManager = new EndpointManager();
    }
}

