/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.plugin.decorator;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.plugin.decorator.IARDecoratorProvider;
import com.clustercontrol.cloud.plugin.decorator.IAccountResourceDecorator;
import com.clustercontrol.cloud.presenter.ICloudResourceManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ARDecoratorProvider
implements IARDecoratorProvider {
    private static List<IAccountResourceDecorator> decoratorList = null;
    private ICloudResourceManager cloudResourceManager;

    public ARDecoratorProvider(ICloudResourceManager cloudResourceManger) {
        this.cloudResourceManager = cloudResourceManger;
    }

    private void initialize(PluginInfo pluginInfo) {
        decoratorList = new ArrayList<IAccountResourceDecorator>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(Activator.getDefault().getBundle().getSymbolicName() + "." + pluginInfo.getPluginName());
        for (IExtension extension : point.getExtensions()) {
            for (IConfigurationElement element : extension.getConfigurationElements()) {
                if (!element.getName().equals(pluginInfo.getElementName())) continue;
                try {
                    decoratorList.add((IAccountResourceDecorator)element.createExecutableExtension(pluginInfo.getAttributeName()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public ICloudResourceManager getCloudResourceManger() {
        return this.cloudResourceManager;
    }

    @Override
    public List<IAccountResourceDecorator> getDecoratorList() {
        if (decoratorList == null) {
            this.initialize(new PluginInfo("accountResourceDecoratorPlugin", "account_resource_decorator_plugin", "account_resource_decorator_class"));
        }
        return decoratorList;
    }

    private static class PluginInfo {
        private String pluginName;
        private String elementName;
        private String attributeName;

        public PluginInfo(String pluginName, String elementName, String attributeName) {
            this.pluginName = pluginName;
            this.elementName = elementName;
            this.attributeName = attributeName;
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public String getElementName() {
            return this.elementName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }
    }
}

