/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.presenter.AccountResource;
import com.clustercontrol.cloud.presenter.CloudComputeService;
import com.clustercontrol.cloud.presenter.CloudInstance;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceByTemplateRequest;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceRequest;
import com.clustercontrol.cloud.presenter.ICloudInstanceManager;
import com.clustercontrol.cloud.presenter.InternalContainer;
import com.clustercontrol.cloud.presenter.RestoreCloudInstanceRequest;
import com.clustercontrol.cloud.presenter.TemplateJobsArgument;
import com.clustercontrol.cloud.resources.Tag;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.CreateInstanceByTemplateRequest;
import com.clustercontrol.ws.cloud.CreateInstanceRequest;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import com.clustercontrol.ws.cloud.NodeDetail;
import com.clustercontrol.ws.cloud.RestoreInstanceRequest;
import java.util.List;

public class CloudInstanceManager
extends InternalContainer<CloudInstance, com.clustercontrol.ws.cloud.CloudInstance>
implements ICloudInstanceManager {
    private AccountResource.Region region;
    private CloudComputeService cloudComputeService;

    public CloudInstanceManager(CloudComputeService cloudComputeService) {
        this.cloudComputeService = cloudComputeService;
        this.region = cloudComputeService.getRegion();
    }

    @Override
    public AccountResource.Region getRegion() {
        return this.region;
    }

    private CloudInstance getCloudInstance(String cloudInstanceId) {
        for (CloudInstance cloudInstance : this.getComponents()) {
            if (!cloudInstance.getInstanceId().equals(cloudInstanceId)) continue;
            return cloudInstance;
        }
        return null;
    }

    public CloudInstance[] getCloudInstances() {
        return this.getComponents().toArray(new CloudInstance[0]);
    }

    @Override
    public CloudInstance createCloudInstance(CreateCloudInstanceRequest createCloudInstanceRequest) {
        CreateInstanceRequest wsCreateCloudInstanceRequest = new CreateInstanceRequest();
        ControlUtil.exportObject(createCloudInstanceRequest, wsCreateCloudInstanceRequest);
        wsCreateCloudInstanceRequest.setNodeDetail(new NodeDetail());
        ControlUtil.exportObject(createCloudInstanceRequest, wsCreateCloudInstanceRequest.getNodeDetail());
        if (createCloudInstanceRequest.getTags() != null) {
            for (Tag tag : createCloudInstanceRequest.getTags()) {
                com.clustercontrol.ws.cloud.Tag wsTag = new com.clustercontrol.ws.cloud.Tag();
                wsTag.setKey(tag.name);
                wsTag.setValue(tag.value);
                wsCreateCloudInstanceRequest.getTags().add(wsTag);
            }
        }
        try {
            com.clustercontrol.ws.cloud.CloudInstance reWsCloudInstance = this.getEndpoint().addInstance(this.getRoleId(), this.region.getRegion(), wsCreateCloudInstanceRequest);
            CloudInstance cloudInstance = CloudInstance.createCloudInstance(this, reWsCloudInstance);
            this.getComponents().add(cloudInstance);
            this.fireComponentAdded(cloudInstance);
            return cloudInstance;
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public CloudInstance createCloudInstanceByTemplate(CreateCloudInstanceByTemplateRequest createCloudInstanceByTemplateRequest) {
        CreateInstanceByTemplateRequest wsCreateCloudInstanceByTemplateRequest = new CreateInstanceByTemplateRequest();
        CreateCloudInstanceByTemplateRequest request = new CreateCloudInstanceByTemplateRequest();
        ControlUtil.importObject(request, createCloudInstanceByTemplateRequest);
        ControlUtil.exportObject(request, wsCreateCloudInstanceByTemplateRequest);
        wsCreateCloudInstanceByTemplateRequest.setNodeDetail(new NodeDetail());
        ControlUtil.exportObject(request, wsCreateCloudInstanceByTemplateRequest.getNodeDetail());
        if (createCloudInstanceByTemplateRequest.getTags() != null) {
            for (Tag tag : createCloudInstanceByTemplateRequest.getTags()) {
                com.clustercontrol.ws.cloud.Tag wsTag = new com.clustercontrol.ws.cloud.Tag();
                wsTag.setKey(tag.name);
                wsTag.setValue(tag.value);
                wsCreateCloudInstanceByTemplateRequest.getTags().add(wsTag);
            }
        }
        if (createCloudInstanceByTemplateRequest.getArguments() != null && createCloudInstanceByTemplateRequest.getArguments().size() > 0) {
            List wsArgs = wsCreateCloudInstanceByTemplateRequest.getArguments();
            for (TemplateJobsArgument arg : createCloudInstanceByTemplateRequest.getArguments()) {
                com.clustercontrol.ws.cloud.TemplateJobsArgument wsArg = new com.clustercontrol.ws.cloud.TemplateJobsArgument();
                ControlUtil.exportObject(arg, wsArg);
                wsArgs.add(wsArg);
            }
        }
        try {
            com.clustercontrol.ws.cloud.CloudInstance reWsCloudInstance = this.getEndpoint().addInstanceByTemplate(this.getRoleId(), this.region.getRegion(), wsCreateCloudInstanceByTemplateRequest);
            CloudInstance cloudInstance = CloudInstance.createCloudInstance(this, reWsCloudInstance);
            this.getComponents().add(cloudInstance);
            this.fireComponentAdded(cloudInstance);
            return cloudInstance;
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void removeCloudInstance(String roleId, String region, String instanceId) {
        try {
            this.getEndpoint().removeInstance(roleId, region, instanceId);
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
        CloudInstance cloudInstance = this.getCloudInstance(instanceId);
        this.getComponents().remove(cloudInstance);
        this.fireComponentRemoved(cloudInstance);
    }

    @Override
    public CloudInstance restoreCloudInstance(RestoreCloudInstanceRequest restoreCloudInstanceRequest) {
        RestoreInstanceRequest wsRequest = new RestoreInstanceRequest();
        ControlUtil.exportObject(restoreCloudInstanceRequest, wsRequest);
        wsRequest.setNodeDetail(new NodeDetail());
        ControlUtil.exportObject(restoreCloudInstanceRequest, wsRequest.getNodeDetail());
        try {
            com.clustercontrol.ws.cloud.CloudInstance restoredInstance = this.getEndpoint().restoreInstance(this.getRoleId(), this.getRegion().getRegion(), wsRequest);
            CloudInstance cloudInstance = CloudInstance.createCloudInstance(this, restoredInstance);
            this.getComponents().add(cloudInstance);
            this.fireComponentAdded(cloudInstance);
            return cloudInstance;
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    protected List<com.clustercontrol.ws.cloud.CloudInstance> getSources() throws CloudModelException {
        try {
            return this.getEndpoint().getInstancesByRegion(this.getRoleId(), this.region.getRegion());
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    protected CloudInstance createComponent(com.clustercontrol.ws.cloud.CloudInstance source) throws CloudModelException {
        CloudInstance cloudInstance = new CloudInstance(this);
        cloudInstance.overwrite(source);
        return cloudInstance;
    }

    @Override
    protected void fireComponentAdded(CloudInstance addedValue) {
        this.fireElementAdded(ICloudInstanceManager.p2.cloudInstances, addedValue);
    }

    @Override
    protected void fireComponentRemoved(CloudInstance removedValue) {
        this.fireElementRemoved(ICloudInstanceManager.p2.cloudInstances, removedValue);
    }

    private CloudEndpoint getEndpoint() {
        return this.getRegion().getAccountResource().getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
    }

    private String getRoleId() {
        return this.getRegion().getAccountResource().getActiveUser().getRoleId();
    }

    @Override
    public CloudComputeService getCloudComputeService() {
        return this.cloudComputeService;
    }

    @Override
    public void unregistNode(String instanceId) {
        try {
            this.getEndpoint().unregistNode(this.getRoleId(), this.getRegion().getRegion(), instanceId);
            CloudInstance tmpInstance = this.getCloudInstance(instanceId);
            this.getComponents().remove(tmpInstance);
            this.fireComponentRemoved(tmpInstance);
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }
}

