/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractCloudViewPart
extends ViewPart {
    public void createPartControl(Composite parent) {
        this.internalCreatePartControl(parent);
        if (this.isNeedDefaultPopupMenu()) {
            this.createDefaultContextMenu();
        }
    }

    protected abstract void internalCreatePartControl(Composite var1);

    protected abstract StructuredViewer getViewer();

    public void setFocus() {
        this.getViewer().getControl().setFocus();
    }

    protected void createDefaultContextMenu() {
        MenuManager menuManager = new MenuManager();
        this.getSite().registerContextMenu(menuManager, this.getSite().getSelectionProvider());
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractCloudViewPart.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
    }

    protected boolean isNeedDefaultPopupMenu() {
        return true;
    }
}

