/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TableViewerSorter;
import com.clustercontrol.cloud.presenter.AllPropertyObserver;
import com.clustercontrol.cloud.presenter.CollectionObserver2;
import com.clustercontrol.cloud.presenter.ICloudService;
import com.clustercontrol.cloud.presenter.ICloudServiceManager;
import com.clustercontrol.cloud.presenter.IElement;
import com.clustercontrol.cloud.ui.views.AbstractCloudViewPart;
import com.clustercontrol.util.LoginManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class CloudServicesView
extends AbstractCloudViewPart {
    public static final String Id = "com.clustercontrol.cloud.ui.views.CloudServicesView";
    private static MessageManager bundle_messages = MessageManager.getInstance("messages");
    private Table table;
    private TableViewer tableViewer;
    private Label lblFooter;
    private List<ICloudService> cloudServices = new ArrayList<ICloudService>();
    private String footerTitle = bundle_messages.getString("word.view_item_count") + bundle_messages.getString("caption.title_separator");
    private ICloudServiceManager manager = Activator.getDefault().getCloudResourceManager().getCloudServiceManager();
    private CollectionObserver2<ICloudService> elementObserver = new CollectionObserver2<ICloudService>(){

        @Override
        public void elementAdded(CollectionObserver2.ElementAddedEvent<ICloudService> event) {
            event.getAddedElement().addPropertyObserver2(IElement.allProperty, CloudServicesView.this.propertyObserver);
            CloudServicesView.this.cloudServices.add(event.getAddedElement());
            CloudServicesView.this.tableViewer.setInput((Object)CloudServicesView.this.cloudServices);
            CloudServicesView.this.lblFooter.setText(CloudServicesView.this.footerTitle + CloudServicesView.this.cloudServices.size());
            CloudServicesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CloudServicesView.this.tableViewer.refresh(true);
                    ISelection selection = CloudServicesView.this.tableViewer.getSelection();
                    CloudServicesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }

        @Override
        public void elementRemoved(CollectionObserver2.ElementRemovedEvent<ICloudService> event) {
            event.getRemovedElement().removePropertyObserver2(IElement.allProperty, CloudServicesView.this.propertyObserver);
            CloudServicesView.this.cloudServices.remove(event.getRemovedElement());
            CloudServicesView.this.tableViewer.setInput((Object)CloudServicesView.this.cloudServices);
            CloudServicesView.this.lblFooter.setText(CloudServicesView.this.footerTitle + CloudServicesView.this.cloudServices.size());
            CloudServicesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CloudServicesView.this.tableViewer.refresh(true);
                    ISelection selection = CloudServicesView.this.tableViewer.getSelection();
                    CloudServicesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }
    };
    private AllPropertyObserver propertyObserver = new AllPropertyObserver(){

        @Override
        public void propertyChanged(AllPropertyObserver.ValueChangedEvent event) {
            CloudServicesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CloudServicesView.this.tableViewer.refresh(true);
                    ISelection selection = CloudServicesView.this.tableViewer.getSelection();
                    CloudServicesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }

        @Override
        public void elementRemoved(AllPropertyObserver.ElementRemovedEvent event) {
            CloudServicesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CloudServicesView.this.tableViewer.refresh(true);
                    ISelection selection = CloudServicesView.this.tableViewer.getSelection();
                    CloudServicesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }

        @Override
        public void elementAdded(AllPropertyObserver.ElementAddedEvent event) {
            CloudServicesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CloudServicesView.this.tableViewer.refresh(true);
                    ISelection selection = CloudServicesView.this.tableViewer.getSelection();
                    CloudServicesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }
    };

    public void dispose() {
        super.dispose();
    }

    public CloudServicesView() {
        LoginManager.login();
    }

    @Override
    protected void internalCreatePartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Composite composite_1 = new Composite(composite, 0);
        TableColumnLayout tcl_composite_1 = new TableColumnLayout();
        composite_1.setLayout((Layout)tcl_composite_1);
        this.tableViewer = new TableViewer(composite_1, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        for (final ViewColumn column : ViewColumn.values()) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tcl_composite_1.setColumnData((Widget)tableColumn, (ColumnLayoutData)column.getPixelData());
            tableColumn.setText(column.getLabel());
            tableViewerColumn.setLabelProvider((CellLabelProvider)column.getProvider());
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CloudServicesView.this.tableViewer.setSorter((ViewerSorter)new TableViewerSorter(CloudServicesView.this.tableViewer, column.getProvider()));
                }
            });
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        GridLayout gl_composite = new GridLayout(1, true);
        gl_composite.horizontalSpacing = 0;
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        gl_composite.verticalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite_1.setLayoutData((Object)gridData);
        this.lblFooter = new Label(composite, 0);
        this.lblFooter.setAlignment(131072);
        this.lblFooter.setSize(this.lblFooter.getSize().x, 80);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.lblFooter.setLayoutData((Object)gridData);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        try {
            this.update();
        }
        catch (Throwable e) {
            this.lblFooter.setText(this.footerTitle + 0);
            Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
            logger.error((Object)e.getMessage(), e);
        }
    }

    private List<ICloudService> getCloudServices() {
        if (this.cloudServices == null) {
            try {
                for (ICloudService cl : this.manager.getCloudServices()) {
                    cl.addPropertyObserver2(IElement.allProperty, this.propertyObserver);
                }
                this.cloudServices = new ArrayList<ICloudService>();
                this.cloudServices.addAll(Arrays.asList(this.manager.getCloudServices()));
                this.manager.addPropertyObserver2(ICloudServiceManager.p2.cloudServices, this.elementObserver);
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
                logger.error((Object)e.getMessage(), (Throwable)e);
                this.cloudServices = new ArrayList<ICloudService>();
            }
        }
        return this.cloudServices;
    }

    public void update() {
        if (this.cloudServices != null) {
            for (ICloudService cloud : this.cloudServices) {
                cloud.removePropertyObserver2(IElement.allProperty, this.propertyObserver);
            }
            this.cloudServices = null;
        }
        if (this.manager != null) {
            this.manager.removePropertyObserver2(ICloudServiceManager.p2.cloudServices, this.elementObserver);
            this.manager.update();
        }
        List<ICloudService> cloudServices = this.getCloudServices();
        this.tableViewer.setInput(cloudServices);
        this.lblFooter.setText(this.footerTitle + cloudServices.size());
    }

    @Override
    protected StructuredViewer getViewer() {
        return this.tableViewer;
    }

    static /* synthetic */ MessageManager access$500() {
        return bundle_messages;
    }

    private static enum ViewColumn {
        cloud_service_id(CloudServicesView.access$500().getString("word.cloud_service_id"), new ColumnPixelData(180, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudService)element).getCloudServiceId();
            }
        }),
        cloud_service_name(CloudServicesView.access$500().getString("word.cloud_service_name"), new ColumnPixelData(180, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudService)element).getCloudServiceName();
            }
        }),
        cloud_type_id(CloudServicesView.access$500().getString("word.cloud_type_id"), new ColumnPixelData(180, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudService)element).getCloudTypeId();
            }
        }),
        description(CloudServicesView.access$500().getString("word.description"), new ColumnPixelData(180, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudService)element).getDescription();
            }
        });

        private String label;
        private ColumnLabelProvider provider;
        private ColumnPixelData pixelData;

        private ViewColumn(String label, ColumnPixelData pixelData, ColumnLabelProvider provider) {
            this.label = label;
            this.pixelData = pixelData;
            this.provider = provider;
        }

        public String getLabel() {
            return this.label;
        }

        public ColumnPixelData getPixelData() {
            return this.pixelData;
        }

        public ColumnLabelProvider getProvider() {
            return this.provider;
        }
    }
}

