/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.IElement;
import com.clustercontrol.cloud.presenter.INode;
import com.clustercontrol.cloud.presenter.IScope;
import com.clustercontrol.cloud.ui.views.FilterlingViewPart;
import com.clustercontrol.cloud.ui.views.IAROrientedView;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.ISelectionListener;

public abstract class FilterlingViewPartByScopeTree<R extends IElement, E extends IElement, M>
extends FilterlingViewPart<IAccountResource.IRegion, R, E, M>
implements ISelectionListener,
IAROrientedView {
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private String zoneName;
    private String facilityId;
    private IAccountResource currentAccountResource;
    private IAccountResource nextAccountResource;
    protected Map<IAccountResource.IRegion, String> resultMap = new HashMap<IAccountResource.IRegion, String>();

    @Override
    protected boolean prepareFilterConditiion(String viweId, ISelection selection) {
        if (!viweId.equals("com.clustercontrol.cloud.ui.views.ScopeView")) {
            return false;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection sselection = (IStructuredSelection)selection;
        if (sselection.isEmpty()) {
            return false;
        }
        try {
            IAccountResource accountResource = null;
            Object selected = sselection.getFirstElement();
            if (selected instanceof IScope) {
                IScope scope = (IScope)selected;
                switch (scope.getScopeType()) {
                    case region: {
                        accountResource = Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(IScope.ScopeType.region.getAccountResourceId(scope));
                        this.setNextState(accountResource != null ? accountResource.getRegion(IScope.ScopeType.region.getRegion(scope)) : null);
                        this.zoneName = null;
                        this.facilityId = null;
                        break;
                    }
                    case zone: {
                        accountResource = Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(IScope.ScopeType.region.getAccountResourceId(scope.getParent()));
                        this.setNextState(accountResource != null ? accountResource.getRegion(IScope.ScopeType.region.getRegion(scope.getParent())) : null);
                        this.zoneName = scope.getFacilityId().replace(accountResource.getAccountResourceId() + "_", "");
                        this.facilityId = null;
                        break;
                    }
                    case root: {
                        this.setNextState(null);
                        this.zoneName = null;
                        this.facilityId = null;
                        break;
                    }
                    case account_resource_scope: {
                        accountResource = Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(IScope.ScopeType.account_resource_scope.getAccountResourceId(scope));
                        this.setNextState(null);
                        this.zoneName = null;
                        this.facilityId = null;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            } else if (selected instanceof INode) {
                INode node = (INode)selected;
                accountResource = Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(IScope.ScopeType.region.getAccountResourceId(node.getParent().getParent()));
                this.setNextState(accountResource.getRegion(IScope.ScopeType.region.getRegion(node.getParent().getParent())));
                this.zoneName = node.getParent().getFacilityId().replace(accountResource.getAccountResourceId() + "_", "");
                this.facilityId = node.getFacilityId();
            }
            this.nextAccountResource = accountResource;
            if (this.nextAccountResource != null && !AccountControlUtil.isInitializedActiveUser(this.nextAccountResource.getAccountResourceId()).booleanValue()) {
                AccountControlUtil.selectActiveUser(this.getSite().getPage().findView("com.clustercontrol.cloud.ui.views.ScopeView"));
            }
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    protected String getHeaderByFacilityId(IAccountResource.IRegion region, String facilityId) {
        return this.bundle_messages.getString("word.facility_id") + this.bundle_messages.getString("caption.title_separator") + facilityId;
    }

    protected String getHeaderByAvailabilityZone(IAccountResource.IRegion region, String availabilityZone) {
        return this.bundle_messages.getString("word.region") + this.bundle_messages.getString("caption.title_separator") + region.getRegionName() + "\t" + this.bundle_messages.getString("word.zone") + this.bundle_messages.getString("caption.title_separator") + availabilityZone;
    }

    protected String getHeaderByRegion(IAccountResource.IRegion region) {
        return this.bundle_messages.getString("word.region") + this.bundle_messages.getString("caption.title_separator") + region.getRegionName();
    }

    protected String getEmptyHeader() {
        return "";
    }

    @Override
    protected void startGetManagerData(IAccountResource.IRegion region) {
        this.getLeftFooter().setText(this.bundle_messages.getString("caption.accessing_to", new String[]{region.getRegionName()}));
    }

    @Override
    protected boolean isMatch(E element) {
        return !(this.getCurrentState() == null || !this.isMatchRegion((IAccountResource.IRegion)this.getCurrentState(), element) || this.zoneName != null && !this.isMatchAvailabilityZone(this.zoneName, element) || this.facilityId != null && !this.isMatchFacilityId(this.facilityId, element));
    }

    protected abstract boolean isMatchRegion(IAccountResource.IRegion var1, E var2);

    protected abstract boolean isMatchAvailabilityZone(String var1, E var2);

    protected abstract boolean isMatchFacilityId(String var1, E var2);

    protected abstract Label getHeaderLabel();

    protected abstract Label getLeftFooter();

    protected abstract Label getRightFooter();

    @Override
    protected void failedPrepareFilterConditiion(Exception exception) {
        super.failedPrepareFilterConditiion(exception);
        this.getHeaderLabel().setText("");
        if (exception instanceof CloudModelException) {
            this.getLeftFooter().setText(((CloudModelException)exception).getMessage());
        } else {
            this.getLeftFooter().setText(this.bundle_messages.getString("word.fail"));
        }
        this.getRightFooter().setText(this.bundle_messages.getString("word.view_item_count") + this.bundle_messages.getString("caption.title_separator") + this.getCurrentElements().size());
    }

    @Override
    protected void successGetManagerData(IAccountResource.IRegion targetState, List<M> managerElements) {
        super.successGetManagerData(targetState, managerElements);
        this.resultMap.put(targetState, this.bundle_messages.getString("word.success"));
    }

    @Override
    protected void failedGetManagerData(IAccountResource.IRegion targetState, Exception exception) {
        super.failedGetManagerData(targetState, exception);
        this.resultMap.put(targetState, this.bundle_messages.getString("word.fail"));
    }

    @Override
    protected void updateStatus() {
        if (this.getCurrentState() != null) {
            if (this.getActiveFacilityId() != null) {
                this.getHeaderLabel().setText(this.getHeaderByFacilityId((IAccountResource.IRegion)this.getCurrentState(), this.getActiveFacilityId()));
            } else if (this.getActiveZone() != null) {
                this.getHeaderLabel().setText(this.getHeaderByAvailabilityZone((IAccountResource.IRegion)this.getCurrentState(), this.getActiveZone()));
            } else {
                this.getHeaderLabel().setText(this.getHeaderByRegion((IAccountResource.IRegion)this.getCurrentState()));
            }
        } else {
            this.getHeaderLabel().setText(this.getEmptyHeader());
        }
        this.getLeftFooter().setText(this.resultMap.get(this.getCurrentState()) == null ? "" : this.resultMap.get(this.getCurrentState()));
        this.getRightFooter().setText(this.bundle_messages.getString("word.view_item_count") + this.bundle_messages.getString("caption.title_separator") + this.getCurrentElements().size());
    }

    @Override
    protected void nextState() {
        IAccountResource oldAccountResource = this.currentAccountResource;
        super.nextState();
        this.currentAccountResource = this.nextAccountResource;
        if (oldAccountResource != this.currentAccountResource) {
            this.firePropertyChange(0);
        }
    }

    @Override
    protected void updateStatus(Exception exception) {
        if (this.getCurrentState() != null) {
            if (this.getActiveFacilityId() != null) {
                this.getHeaderLabel().setText(this.getHeaderByFacilityId((IAccountResource.IRegion)this.getCurrentState(), this.getActiveFacilityId()));
            } else if (this.getActiveZone() != null) {
                this.getHeaderLabel().setText(this.getHeaderByAvailabilityZone((IAccountResource.IRegion)this.getCurrentState(), this.getActiveZone()));
            } else {
                this.getHeaderLabel().setText(this.getHeaderByRegion((IAccountResource.IRegion)this.getCurrentState()));
            }
        } else {
            this.getHeaderLabel().setText(this.getEmptyHeader());
        }
        this.getLeftFooter().setText(this.resultMap.get(this.getCurrentState()) == null ? "" : this.resultMap.get(this.getCurrentState()));
        this.getRightFooter().setText(this.bundle_messages.getString("word.view_item_count") + this.bundle_messages.getString("caption.title_separator") + this.getCurrentElements().size());
    }

    public IAccountResource.IRegion getActiveRegion() {
        return (IAccountResource.IRegion)this.getCurrentState();
    }

    public String getActiveZone() {
        return this.zoneName;
    }

    public String getActiveFacilityId() {
        return this.facilityId;
    }

    @Override
    public void update() {
        ISelection selection = this.getSite().getPage().getSelection("com.clustercontrol.cloud.ui.views.ScopeView");
        this.update(new FilterlingViewPart.ConcreteDataHolder("com.clustercontrol.cloud.ui.views.ScopeView", selection), true);
    }

    @Override
    public IAccountResource getCurrentAccountResource() {
        return this.currentAccountResource;
    }
}

