/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.cloud.ui.dialogs.CreateTemplateJobDialog;
import com.clustercontrol.cloud.ui.views.TemplatesView;
import com.clustercontrol.cloud.ui.views.actions.AbstractViewAction;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;

public class CreateTemplateJobAction
extends AbstractViewAction {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.CreateTemplateJobAction";
    private MessageManager messages = MessageManager.getInstance("messages");
    private String msgCreateTemplateJobConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.template_job", "word.create"});
    private String msgCreateTemplateJobResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.template_job", "word.create"});

    @Override
    protected void invoke(IAction action) throws InvocationException {
        CreateTemplateJobDialog dialog = new CreateTemplateJobDialog(this.viewPart.getSite().getShell());
        dialog.setRoleId(AccountControlUtil.getRoleId(((TemplatesView)this.viewPart).getAccountResource().getAccountResourceId()));
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgCreateTemplateJobConfirm)) {
                try {
                    CreateTemplateJobDialog.DialogOutput output = dialog.getOutput();
                    TemplateJobUtil.TemplateJobnet jobnet = new TemplateJobUtil.TemplateJobnet();
                    jobnet.setJobnetId(output.getJobnetId());
                    jobnet.setJobnetName(output.getJobnetName());
                    jobnet.setOsType(output.getOsType());
                    jobnet.setJobs(output.getTemplateJobList());
                    TemplateJobUtil.registerJob(((TemplatesView)this.viewPart).getAccountResource().getAccountResourceId(), jobnet);
                }
                catch (Exception e) {
                    throw new InvocationException(e);
                }
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgCreateTemplateJobResult);
            } else {
                return;
            }
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        if (((TemplatesView)this.viewPart).getAccountResource() != null) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }
}

