/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.plugin.action.IActionPluginProvider;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.ui.views.IAROrientedView;
import com.clustercontrol.cloud.ui.views.actions.AbstractViewAction;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;

public abstract class PluginBaseAction
extends AbstractViewAction
implements IPropertyListener {
    protected IActionPluginProvider actionPluginProvider;

    @Override
    public void init(IViewPart view) {
        super.init(view);
        assert (view instanceof IAROrientedView);
        view.addPropertyListener((IPropertyListener)this);
    }

    @Override
    protected void invoke(IAction action) throws InvocationException {
        this.actionPluginProvider.getAction(this.getPluginId()).run(action);
    }

    protected abstract String getPluginId();

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        if (this.actionPluginProvider != null && this.actionPluginProvider.isSupported(this.getPluginId()).booleanValue()) {
            this.actionPluginProvider.getAction(this.getPluginId()).selectionChanged(action, selection);
        } else {
            action.setEnabled(false);
        }
    }

    @Override
    public void propertyChanged(Object source, int propId) {
        if (0 != propId) {
            return;
        }
        IAccountResource accountResource = ((IAROrientedView)this.viewPart).getCurrentAccountResource();
        if (accountResource != null) {
            String cloudTypeId = Activator.getDefault().getCloudResourceManager().getCloudServiceManager().getCloudService(accountResource.getCloudServiceId()).getCloudTypeId();
            if ((this.actionPluginProvider == null || !cloudTypeId.equals(this.actionPluginProvider.getCloudTypeId())) && Activator.getDefault().getActionPluginManager().isPlugined(cloudTypeId).booleanValue()) {
                this.actionPluginProvider = Activator.getDefault().getActionPluginManager().getActionPluginProvider(cloudTypeId);
                if (this.actionPluginProvider.isSupported(this.getPluginId()).booleanValue()) {
                    this.actionPluginProvider.getAction(this.getPluginId()).init(this.viewPart);
                }
            }
        } else {
            this.actionPluginProvider = null;
        }
        this.viewPart.getSite().getSelectionProvider().setSelection(this.viewPart.getSite().getSelectionProvider().getSelection());
    }
}

