/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud;

import java.io.File;
import java.net.URI;
import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import com.clustercontrol.cloud.plugin.action.ActionPluginManager;
import com.clustercontrol.cloud.plugin.action.IActionPluginManager;
import com.clustercontrol.cloud.presenter.CloudResourceManager;
import com.clustercontrol.cloud.presenter.EndpointManager;
import com.clustercontrol.cloud.presenter.ICloudResourceManager;
import com.clustercontrol.cloud.presenter.IEndpointManager;

public class Activator extends AbstractUIPlugin {
	public static String ID = "com.clustercontrol.cloud.base";

	// The shared instance
	private static Activator plugin;
	private static String pluginPath;
	private CloudResourceManager cloudResourceManager;
	private static EndpointManager endpointManager = new EndpointManager();
	private ActionPluginManager actionPluginManager;
	private Boolean enterprisePluginedFlg = false;

	public Activator() {
		super();
		plugin = this;
	}

	@Override
	protected void initializeImageRegistry(ImageRegistry registry) {
		registerImage(registry, "user", "user.png");
		registerImage(registry, "account", "account.png");
		registerImage(registry, "aws-box", "aws-box.png");
	}

	private void registerImage(ImageRegistry registry, String key, String fileName) {
		try {
			URL url = new URL(getDefault().getBundle().getEntry("/"), "icons/" + fileName);
			ImageDescriptor desc = ImageDescriptor.createFromURL(url);
			registry.put(key, desc);
		}
		catch (Exception e) {
		}
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}
	
	public ICloudResourceManager getCloudResourceManager() {
		if (cloudResourceManager == null) {
			cloudResourceManager = new CloudResourceManager(endpointManager);
		}
		return cloudResourceManager;
	}
	
	public void releaseCloudManager() {
		cloudResourceManager = null;
	}

	public static IEndpointManager getEndpointManager() {
		return endpointManager;
	}

	public IActionPluginManager getActionPluginManager(){
		if(actionPluginManager == null){
			actionPluginManager = new ActionPluginManager();
		}
		return actionPluginManager;
	}
	
	public static String getPluginPath() {
		if (pluginPath == null) {
			// プラグインがインストールされているパスを取得。
			URL entry = Activator.getDefault().getBundle().getEntry("/");
			try {
				String url = FileLocator.resolve(entry).toString();
				// URI クラスは、空白を拒否するので、"%20" へエンコード。
				url = url.replaceAll(" ", "%20");
				pluginPath = new File(new URI(url)).getAbsolutePath();
			}
			catch (Exception e) {
				e.printStackTrace();
				throw new IllegalStateException(e);
			}			
		}

		return pluginPath;
	}

	public Boolean isEnterprisePlugined() {
		return enterprisePluginedFlg;
	}

	public void setEnterprisePluginedFlg(Boolean enterprisePluginedflg) {
		this.enterprisePluginedFlg = enterprisePluginedflg;
	}
}
