/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.plugin.action;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.presenter.CloudModelException;

public class ActionPluginManager implements IActionPluginManager {
	Map<String, IActionPluginProvider> providers = null;
	
	private void init(){
		providers = new HashMap<String, IActionPluginProvider>();
		
		IExtensionRegistry registry = Platform.getExtensionRegistry();

		// 拡張ポイントを取得
		IExtensionPoint point = registry.getExtensionPoint(Activator.getDefault().getBundle().getSymbolicName() + ".actionPlugin");

		for(IExtension extension: point.getExtensions()){
			for(IConfigurationElement element: extension.getConfigurationElements()){
				IActionPluginProvider pluginProvider = null;
	
				// 要素名がaction_pluginだった場合、ExtensionTypeの情報を取得
				if(element.getName().equals("action_plugin")){
					try {
						pluginProvider = (IActionPluginProvider) element.createExecutableExtension("plugin_action_provider_class");
					} catch (CoreException e) {
						throw new CloudModelException(e);
					}
				}
				
				if(pluginProvider != null){
					assert pluginProvider.getCloudTypeId() != null: "CloudTypeId is null.";
					assert !pluginProvider.getCloudTypeId().isEmpty() : "CloudTypeId is empty.";

					
					providers.put(pluginProvider.getCloudTypeId(), pluginProvider);
				}
			}
		}
	}
	
	@Override
	public IActionPluginProvider getActionPluginProvider(String cloudTypeId) {
		checkInit();
		return providers.get(cloudTypeId);
	}

	@Override
	public Boolean isPlugined(String cloudTypeId) {
		checkInit();
		return providers.containsKey(cloudTypeId);
	}
	
	private void checkInit(){
		if(providers == null){
			init();
		}
	}
}
