/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TableViewerSorter;
import com.clustercontrol.cloud.presenter.CloudInstanceManager;
import com.clustercontrol.cloud.presenter.CollectionObserver2;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.IAccountResource.IRegion;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudInstanceManager;
import com.clustercontrol.cloud.presenter.ICloudUser;
import com.clustercontrol.cloud.presenter.PropertyId2;
import com.clustercontrol.util.LoginManager;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudInstance;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;


/**
 */
public class InstancesView extends FilterlingViewPartByScopeTree<ICloudInstanceManager, ICloudInstance, CloudInstance> implements ISelectionListener {
	public static final String Id = InstancesView.class.getName();

	private static ThreadPoolExecutor threadPool = new ThreadPoolExecutor(3, 3, 60, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
	private static MessageManager bundle_messages = MessageManager.getInstance("messages");

	private Label lblHeader;
	private FooterComposite footerComposite;
	private Table table;
	private TableViewer tableViewer;

	private ISelectionProvider provider = new ISelectionProvider() {
		private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();

		ISelection theSelection = StructuredSelection.EMPTY;

		public void addSelectionChangedListener(ISelectionChangedListener listener) {
			listeners.add(listener);
		}

		public ISelection getSelection() {
			return theSelection;
		}

		public void removeSelectionChangedListener(ISelectionChangedListener listener) {
			listeners.remove(listener);
		}

		public void setSelection(ISelection selection) {
			theSelection = selection;
			SelectionChangedEvent e = new SelectionChangedEvent(this, selection);
			for (ISelectionChangedListener l: listeners) {
				l.selectionChanged(e);
			}
		}
	};

	public InstancesView() {
 		super();
		LoginManager.login();  // ログインしていない場合は、ビュー表示前に必ずログインダイアログを出すようにする
	}

	@Override
	protected void internalCreatePartControl(Composite arg0) {
		Composite composite = new Composite(arg0, SWT.NONE);
		GridLayout gl_composite = new GridLayout(1, true);
		gl_composite.horizontalSpacing = 0;
		gl_composite.marginHeight = 0;
		gl_composite.marginWidth = 0;
		gl_composite.verticalSpacing = 0;
		composite.setLayout(gl_composite);

		lblHeader = new Label(composite, SWT.NONE);
		lblHeader.setSize(lblHeader.getSize().x, 80);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		lblHeader.setLayoutData(gridData);

		Composite composite_1 = new Composite(composite, SWT.NONE);
		TableColumnLayout tcl_composite_1 = new TableColumnLayout();
		composite_1.setLayout(tcl_composite_1);

		tableViewer = new TableViewer(composite_1, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		for(final ViewColumn column: ViewColumn.values()){
			TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
			TableColumn tableColumn = tableViewerColumn.getColumn();
			tcl_composite_1.setColumnData(tableColumn, column.getPixelData());
			tableColumn.setText(column.getLabel());
			tableViewerColumn.setLabelProvider(column.getProvider());
			tableColumn.addSelectionListener(new SelectionAdapter(){
				@Override
				public void widgetSelected(SelectionEvent e) {
					tableViewer.setSorter(new TableViewerSorter(tableViewer, column.getProvider()));
				}
			});
		}

		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		composite_1.setLayoutData(gridData);

		footerComposite = new FooterComposite(composite, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		footerComposite.setSize(lblHeader.getSize().x, 80);
		footerComposite.setLayoutData(gridData);

		tableViewer.setContentProvider(new IStructuredContentProvider() {
			@Override
			public Object[] getElements(Object inputElement) {
				return ((List<?>)inputElement).toArray();
			}
			@Override
			public void dispose() {
			}
			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			}
		});

		getSite().getPage().addSelectionListener(this);
//		getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(ScopeView.Id, this);

		tableViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				List<Object> selection = new ArrayList<Object>();
//				if (getCurrentState() != null) {
//					selection.add(getCurrentState());
//				}
				
				if (event.getSelection() instanceof IStructuredSelection) {
					Iterator<?> iter = ((IStructuredSelection)event.getSelection()).iterator();
					while (iter.hasNext()) {
						selection.add(iter.next());
					}
				}
				provider.setSelection(new StructuredSelection(selection.toArray()));
			}
		});

		getSite().setSelectionProvider(provider);

		getSite().getWorkbenchWindow().getShell().getDisplay().asyncExec(
				new Runnable() {
					@Override
					public void run() {
						IViewPart view = getSite().getPage().findView(ScopeView.Id);
						view.getSite().getPage().activate(view);
						view.getSite().getSelectionProvider().setSelection(view.getSite().getSelectionProvider().getSelection());
						getSite().getPage().activate(InstancesView.this);
					}
				});
		
		update();
	}
	@Override
	protected void updateStatus() {
//		StructuredSelection selection = null;
//		if (getCurrentState() != null) {
//			selection = new StructuredSelection(new Object[]{getCurrentState()});
//		}
//		else {
//			selection = new StructuredSelection();
//		}
//		provider.setSelection(selection);
		
		super.updateStatus();
	}
	
	@Override
	protected ICloudInstanceManager getRootElement(IRegion region) {
		return region.getCloudService(ICloudComputeService.class).getInstanceManager();
	}
	@Override
	protected List<ICloudInstance> getElements(ICloudInstanceManager root) {
		return Arrays.asList(root.getCloudInstances());
	}
	@Override
	protected PropertyId2<CollectionObserver2<ICloudInstance>> getPropertyId() {
		return ICloudInstanceManager.p2.cloudInstances;
	}
	@Override
	protected boolean isMatchRegion(IRegion region, ICloudInstance element) {
		return element.getCloudInstanceManager().getRegion() == region;
	}
	@Override
	protected boolean isMatchAvailabilityZone(String zoneName, ICloudInstance element) {
		return zoneName.equals(element.getZone());
	}
	@Override
	protected boolean isMatchFacilityId(String facilityId, ICloudInstance element) {
		return facilityId.equals(element.getFacilityId());
	}
	@Override
	protected Label getHeaderLabel() {
		return lblHeader;
	}
	@Override
	protected Label getLeftFooter() {
		return footerComposite.getLeftControl();
	}
	@Override
	protected Label getRightFooter() {
		return footerComposite.getRightControl();
	}
	@Override
	protected StructuredViewer getViewer() {
		return tableViewer;
	}
	@Override
	protected List<CloudInstance> getManagerElements(CloudEndpoint endpoint, IRegion region) throws InvalidRole_Exception, InvalidUserPass_Exception, CloudManagerFault_Exception {
		IAccountResource accountResource = region.getAccountResource();
		ICloudUser cloudUser = null;
		cloudUser = accountResource.getActiveUser();
		String roleId = cloudUser.getRoleId();
		String regionId = region.getRegion();
		return endpoint.getInstancesByRegion(roleId, regionId);
	}
	@Override
	protected void setManagerElements(ICloudInstanceManager rootElement, List<CloudInstance> ManagerElements) {
		((CloudInstanceManager)rootElement).internalUpdate(ManagerElements);
	}
	@Override
	protected boolean isInitialized(ICloudInstanceManager rootElement) {
		return ((CloudInstanceManager)rootElement).isInitialized();
	}
	@Override
	protected ThreadPoolExecutor getExecutor() {
		return threadPool;
	}
	

	private enum ViewColumn{
		facility_id(
			bundle_messages.getString("word.facility_id"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudInstance)element).getFacilityId();
				}
			}
		),
		facility_name(
			bundle_messages.getString("word.facility_name"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudInstance)element).getFacilityName();
				}
			}
		),
		instance_id(
			bundle_messages.getString("word.instance_id"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudInstance)element).getInstanceId();
				}
			}
		),
		instance_name(
			bundle_messages.getString("word.instance_name"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudInstance)element).getInstanceName();
				}
			}
		),
		platform(
			bundle_messages.getString("word.platform"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudInstance)element).getPlatform();
				}
			}
		),
		cloud_type_id(
			bundle_messages.getString("word.cloud_type_id"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudInstance)element).getCloudTypeId();
				}
			}
		),
		region(
			bundle_messages.getString("word.region"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudInstance)element).getCloudInstanceManager().getRegion().getRegionName();
				}
			}
		),
		zone(
			bundle_messages.getString("word.zone"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudInstance)element).getZone();
				}
			}
		),
		state(
			bundle_messages.getString("word.state"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudInstance)element).getState();
				}
			}
		),
		regist_state(
			bundle_messages.getString("word.regist_state"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudInstance)element).getRegistState();
				}
			}
		),
		type(
			bundle_messages.getString("word.type"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudInstance)element).getFlavor();
				}
			}
		),
		reg_user(
			bundle_messages.getString("word.reg_user"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudInstance)element).getRegUser();
				}
			}
		),
		reg_date(
			bundle_messages.getString("word.reg_date"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					if(((ICloudInstance)element).getRegDate() != null){
						return format.format(((ICloudInstance)element).getRegDate());
					}
					return "";
				}
			}
		),
		update_user(
			bundle_messages.getString("word.update_user"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudInstance)element).getUpdateUser();
				}
			}
		),
		update_date(
			bundle_messages.getString("word.update_date"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					if(((ICloudInstance)element).getUpdateDate() != null){
						return format.format(((ICloudInstance)element).getUpdateDate());
					}
					return "";
				}
			}
		);

		private String label;
		private ColumnLabelProvider provider;
		private ColumnPixelData pixelData;
		private static SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
		
		ViewColumn(String label, ColumnPixelData pixelData, ColumnLabelProvider provider){
			this.label = label;
			this.pixelData = pixelData;
			this.provider = provider;
		}

		public String getLabel() {
			return label;
		}

		public ColumnPixelData getPixelData() {
			return pixelData;
		}

		public ColumnLabelProvider getProvider() {
			return provider;
		}
	}

	@Override
	public void dispose() {
		getSite().getPage().removeSelectionListener(this);
		getSite().setSelectionProvider(null);
		super.dispose();
	}
}