/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.aws.base.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;

import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.ui.dialogs.CreateInstanceBackupDialog;
import com.clustercontrol.cloud.presenter.CreateInstanceBackupRequest;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;

public class BackupInstanceAction extends SingleSelectionActionEx {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String msgCreateBackupConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.instance_backup", "word.create"});
	private String msgCreateBackupResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.instance_backup", "word.create"});


	@Override
	protected void invoke(IAction action) throws InvocationException {
		ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();

		CreateInstanceBackupDialog dialog = new CreateInstanceBackupDialog(this.viewPart.getSite().getShell(), instance);
		if(dialog.open() == Window.OK){
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgCreateBackupConfirm)){

				CreateInstanceBackupRequest request = new CreateInstanceBackupRequest();
				request.setInstanceId(instance.getInstanceId());
				request.setName(dialog.getImageName());
				request.setDescription(dialog.getDescription());
				
				request.setNoReboot(dialog.getNoReboot());
				request.setWithVolumes(dialog.getWithEBSVolume());
				
				request.setDetail(null);
				
				instance.getCloudInstanceManager().getCloudComputeService().getInstanceBackupManager().backupCloudInstance(request);

				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgCreateBackupResult);
			} else {
				return;
			}
		}
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		super.selectionChanged(action, selection);
		ICloudInstance instance = (ICloudInstance)((IStructuredSelection)selection).getFirstElement();
		if(instance == null || instance.getFacilityId() == null || "".equals(instance.getFacilityId()) || instance.getRegistState().equals(ICloudInstance.RegistStateType.deleted.name())){
			action.setEnabled(false);
		}
	}
}