/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.aws.base.ui.views.actions;

import java.util.Iterator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;

import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.ui.dialogs.DetachStorageFromInstanceDialog;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;

public class DetachStorageFromInstanceAction extends SingleSelectionActionEx {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String msgDetachStorageConfirm = messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.storage", "word.detach"});
	private String msgDetachStorageResult = messages.getString("message.some_command_has_been_accepted", new Object[]{"word.storage", "word.detach"});

	@Override
	protected void invoke(IAction action) throws InvocationException {
		ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		
		DetachStorageFromInstanceDialog dialog = new DetachStorageFromInstanceDialog(this.viewPart.getSite().getShell(), instance);

		if(dialog.open() == Window.OK){
			StringBuffer sb = new StringBuffer();
			
			int i = 0;
			
			Iterator<String> iter = dialog.getVolumes().iterator();
			while (iter.hasNext()) {
				sb.append(iter.next());
				if(iter.hasNext()) sb.append(", ");
				i++;
				if(i > 10){
					sb.append("\n");
					i = 0;
				}
			}
	
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgDetachStorageConfirm +"\n"+sb)){

				for(String vol: dialog.getVolumes()){
					instance.detachStorage(vol);
				}

				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgDetachStorageResult);
	
			} else {
				return;
			}
		}
	}
	
	protected boolean canEnabled(IStructuredSelection selection) {
		ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		if (instance.getRegistState().equals(ICloudInstance.RegistStateType.deleted.name())) {
			return false;
		}
		return true;
	}
}