/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.aws.base.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;

import com.clustercontrol.cloud.aws.base.Activator;
import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.ui.dialogs.ShowWindowsPasswordDialog;
import com.clustercontrol.cloud.commons.util.CloudClientConstants;
import com.clustercontrol.cloud.commons.util.KeyCodec;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.aws.AWSOptionEndpoint;

public class GetWindowsPassAction extends SingleSelectionActionEx {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String strPrivateKeyFile = messages.getString("caption.private_key_file");
	private String msgPrivateKeyFileDifferent = messages.getString("message.private_key_file_different");
	private String msgGetWindowsPassConfirm = messages.getString("message.confirm_that_perform_some_action", new Object[]{"caption.get_password"});

	@Override
	protected boolean canEnabled(IStructuredSelection selection) {
		ICloudInstance instance = (ICloudInstance)selection.getFirstElement();
		if (CloudClientConstants.ACTION_CONSTANTS_GET_WINDOWS_PASSWORD_TARGET_PLATFORM.equals(instance.getPlatform())) {
			return true;
		}
		return false;
	}

	@Override
	protected void invoke(IAction action) throws InvocationException {
		ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();

		if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgGetWindowsPassConfirm)){
			
			AWSOptionEndpoint endpoint = Activator.getEndpointManager().getEndpoint(AWSOptionEndpoint.class);
			
			String password = null;
			try {
				password = endpoint.getWindowsPassword(instance.getCloudInstanceManager().getRegion().getAccountResource().getActiveUser().getRoleId(), instance.getRegion(), instance.getInstanceId());
			}
			catch (Exception e) {
				throw new InvocationException(e);
			}
			
			FileDialog dialog = new FileDialog(viewPart.getSite().getShell());
			String [] exts = {CloudClientConstants.ACTION_CONSTANTS_GET_WINDOWS_PASSWORD_CONSTRAINT_FILE_TYPE};
			String [] filterNames = {strPrivateKeyFile + "(" + CloudClientConstants.ACTION_CONSTANTS_GET_WINDOWS_PASSWORD_CONSTRAINT_FILE_TYPE + ")"};
			dialog.setFilterExtensions(exts);
			dialog.setFilterNames(filterNames);
			String file = dialog.open();
			
			if(file == null){
				return;
			}
			
			try {
				KeyCodec codec = new KeyCodec();
				codec.setPrivateKeyFile(file);
				String decryptedPassword = new String(codec.decryptWithPrivateKey(KeyCodec.getBase64Binary(password)));

				if(decryptedPassword == null || decryptedPassword.isEmpty()){
					MessageDialog.openError(null, Messages.getString("failed"), msgPrivateKeyFileDifferent);
					return;
				}

				ShowWindowsPasswordDialog swpDialog = new ShowWindowsPasswordDialog(viewPart.getSite().getShell());
				swpDialog.setText(decryptedPassword);
				swpDialog.open();
			} catch (Exception e) {
				throw new InvocationException(e);
			}
		}
	}
}