/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.bean.CloudEndpoint;
import com.clustercontrol.cloud.dao.CloudEndpointDao;
import com.clustercontrol.cloud.dao.CloudRegionDao;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Transient;

public class CloudRegion
implements Serializable {
    private static final long serialVersionUID = 6316558729382606000L;
    private Map<String, CloudEndpoint> endpoints = new HashMap<String, CloudEndpoint>();
    private CloudRegionDao dao;

    public CloudRegion() {
        this.dao = new CloudRegionDao();
    }

    public CloudRegion(CloudRegionDao dao) {
        this.dao = dao;
        for (CloudEndpointDao d : dao.getEndpoints()) {
            this.endpoints.put(d.getEndpointType(), new CloudEndpoint(d));
        }
    }

    public String getRegion() {
        return this.dao.getRegion();
    }

    public void setRegion(String region) {
        this.dao.setRegion(region);
    }

    public String getCloudServiceId() {
        return this.dao.getCloudServiceId();
    }

    public void setCloudServiceId(String cloudServiceId) {
        this.dao.setCloudServiceId(cloudServiceId);
    }

    public String getDescription() {
        return this.dao.getDescription();
    }

    public void setDescription(String description) {
        this.dao.setDescription(description);
    }

    public String getRegionName() {
        return this.dao.getRegionName();
    }

    public void setRegionName(String regionName) {
        this.dao.setRegionName(regionName);
    }

    @Transient
    public CloudEndpoint getEndpoint(String type) {
        return this.endpoints.get(type);
    }
}

