/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.validation;

import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.validation.ContainerValidator;
import com.clustercontrol.cloud.validation.CustomEntityValidator;
import com.clustercontrol.cloud.validation.EntityValidator;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.cloud.validation.ValidationUtil;
import com.clustercontrol.cloud.validation.Validator;
import com.clustercontrol.cloud.validation.annotation.CustomEntityValidation;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.ValidatedBy;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EntityValidatorImpl
implements EntityValidator {
    private Map<Class<?>, EntityValidator.EntityValidationContext> validationContextMap = new HashMap();
    private static Method initMethod;
    private static Method validateMethod;

    @Override
    public void validate(Object entity, String group) throws ValidationFault {
        EntityValidator.EntityValidationContext evc = this.getEntityContext(entity.getClass());
        if (evc != null) {
            evc.validate(entity, group, ValidationUtil.getMessages());
            CustomEntityValidator<?> cv = evc.getCustomEntityValidator();
            if (cv != null) {
                try {
                    this.getValidateMethod().invoke(cv, entity, group, ValidationUtil.getMessages(), evc);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof ValidationFault) {
                        throw (ValidationFault)e.getCause();
                    }
                    if (e.getCause() instanceof IllegalStateException) {
                        throw (IllegalStateException)e.getCause();
                    }
                    throw new IllegalStateException(e.getCause());
                }
            }
        }
    }

    private EntityValidator.EntityValidationContext getEntityContext(Class<?> type) {
        EntityValidator.EntityValidationContext validationContext = this.validationContextMap.get(type);
        if (validationContext == null) {
            Logger logger = Logger.getLogger(EntityValidatorImpl.class);
            logger.debug((Object)("checking : " + type.getName()));
            EntityValidationContextImpl vc = null;
            CustomEntityValidation c = type.getAnnotation(CustomEntityValidation.class);
            if (c != null) {
                vc = new EntityValidationContextImpl();
                vc.setType(type);
                CustomEntityValidator<?> cv = null;
                try {
                    Class<CustomEntityValidator<?>> cvClazz = c.value();
                    cv = cvClazz.newInstance();
                }
                catch (Exception e) {
                    if (e instanceof IllegalStateException) {
                        throw (IllegalStateException)e;
                    }
                    throw new IllegalStateException(e);
                }
                vc.setCustomValidator(cv);
            }
            for (Method method : type.getMethods()) {
                logger.debug((Object)("methodName : " + method.getName()));
                boolean match = false;
                String elementId = null;
                String propName = null;
                Class<?> returnType = null;
                Annotation[] annos = method.getAnnotations();
                ElementId eid = null;
                ArrayList<Validator> list = new ArrayList<Validator>();
                ArrayList<ContainerValidator> containerList = new ArrayList<ContainerValidator>();
                for (Annotation anno : annos) {
                    logger.debug((Object)("annotation : " + anno.annotationType().getName()));
                    ValidatedBy vb = anno.annotationType().getAnnotation(ValidatedBy.class);
                    if (vb != null) {
                        if (!match) {
                            if (Modifier.isStatic(method.getModifiers())) {
                                throw new IllegalStateException();
                            }
                            if (method.isSynthetic()) {
                                throw new IllegalStateException();
                            }
                            if (method.getParameterTypes().length != 0) {
                                throw new IllegalStateException();
                            }
                            if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) {
                                throw new IllegalStateException();
                            }
                            returnType = method.getReturnType();
                            if (Void.class.isAssignableFrom(returnType) || Void.TYPE.isAssignableFrom(returnType)) {
                                throw new IllegalStateException();
                            }
                            StringBuilder elementIdBuilder = new StringBuilder();
                            elementIdBuilder.append(Character.toLowerCase(type.getSimpleName().charAt(0)) + type.getSimpleName().substring(1));
                            elementIdBuilder.append('.');
                            propName = method.getName().substring("get".length());
                            propName = Character.toLowerCase(propName.charAt(0)) + propName.substring(1);
                            elementIdBuilder.append(propName);
                            elementId = elementIdBuilder.toString();
                            match = true;
                        }
                        Class<?> validatorClass = vb.value();
                        logger.debug((Object)("validator : " + validatorClass.getName()));
                        try {
                            Validator propValidator = (Validator)validatorClass.newInstance();
                            this.getInitMethod().invoke((Object)propValidator, anno);
                            if (propValidator.getElementId() == null || propValidator.getElementId().equals("")) {
                                propValidator.setElementId(elementId);
                            }
                            if (propValidator instanceof ContainerValidator) {
                                containerList.add((ContainerValidator)propValidator);
                                continue;
                            }
                            list.add(propValidator);
                            continue;
                        }
                        catch (Exception e) {
                            if (e instanceof IllegalStateException) {
                                throw (IllegalStateException)e;
                            }
                            throw new IllegalStateException(e);
                        }
                    }
                    if (anno.annotationType() != ElementId.class) continue;
                    eid = (ElementId)ElementId.class.cast(anno);
                }
                if (list.isEmpty() && containerList.isEmpty()) continue;
                if (eid != null) {
                    for (Validator v : list) {
                        v.setElementId(eid.value());
                    }
                    for (ContainerValidator v : containerList) {
                        v.setElementId(eid.value());
                    }
                }
                if (vc == null) {
                    vc = new EntityValidationContextImpl();
                    vc.setType(type);
                }
                PropValidatorInfoImpl pvi = new PropValidatorInfoImpl();
                pvi.setGetMethod(method);
                pvi.setElementId(elementId);
                pvi.setType(returnType);
                pvi.setPropName(propName);
                pvi.setValidators(list.toArray(new Validator[0]));
                pvi.setContainerValidators(containerList.toArray(new ContainerValidator[0]));
                vc.putPropValidator(propName, pvi);
            }
            if (vc != null) {
                this.validationContextMap.put(type, vc);
            }
            validationContext = vc;
        }
        return validationContext;
    }

    private Method getInitMethod() {
        if (initMethod == null) {
            try {
                initMethod = Validator.class.getDeclaredMethod("init", Annotation.class);
            }
            catch (Exception e) {
                if (e instanceof IllegalStateException) {
                    throw (IllegalStateException)e;
                }
                throw new IllegalStateException(e);
            }
        }
        return initMethod;
    }

    private Method getValidateMethod() {
        if (validateMethod == null) {
            try {
                validateMethod = CustomEntityValidator.class.getDeclaredMethod("validate", Object.class, String.class, IMessagesHolder.class, EntityValidator.EntityValidationContext.class);
            }
            catch (Exception e) {
                if (e instanceof IllegalStateException) {
                    throw (IllegalStateException)e;
                }
                throw new IllegalStateException(e);
            }
        }
        return validateMethod;
    }

    private static class EntityValidationContextImpl
    implements EntityValidator.EntityValidationContext {
        private Class<?> type;
        private Map<String, EntityValidator.PropValidatorInfo> validatorMap = new HashMap<String, EntityValidator.PropValidatorInfo>();
        private CustomEntityValidator<?> customValidator;

        private EntityValidationContextImpl() {
        }

        @Override
        public Class<?> \uff54ype() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        @Override
        public CustomEntityValidator<?> getCustomEntityValidator() {
            return this.customValidator;
        }

        public void setCustomValidator(CustomEntityValidator<?> customValidator) {
            this.customValidator = customValidator;
        }

        @Override
        public void validate(Object entity, String group, IMessagesHolder messages) throws ValidationFault {
            for (EntityValidator.PropValidatorInfo info : this.validatorMap.values()) {
                info.validate(entity, group, messages);
            }
        }

        @Override
        public EntityValidator.PropValidatorInfo getPropValidator(String propName) {
            return this.validatorMap.get(propName);
        }

        @Override
        public Map<String, EntityValidator.PropValidatorInfo> getPropValidatorMap() {
            return Collections.unmodifiableMap(this.validatorMap);
        }

        public void putPropValidator(String propName, EntityValidator.PropValidatorInfo validator) {
            this.validatorMap.put(propName, validator);
        }
    }

    private static class PropValidatorInfoImpl
    implements EntityValidator.PropValidatorInfo {
        private static Method validateMethod;
        private String propName;
        private Method getMethod;
        private String elementId;
        private TypeKind typeKind;
        private Validator<? extends Annotation, ?>[] validators;
        private ContainerValidator<? extends Annotation, ?>[] containerValidators;

        private PropValidatorInfoImpl() {
        }

        @Override
        public String propName() {
            return this.propName;
        }

        public void setPropName(String propName) {
            this.propName = propName;
        }

        @Override
        public Method getMethod() {
            return this.getMethod;
        }

        public void setGetMethod(Method getMethod) {
            this.getMethod = getMethod;
        }

        public void setType(Class<?> returnType) {
            this.typeKind = List.class.isAssignableFrom(returnType) ? TypeKind.List : (returnType.isArray() ? TypeKind.Array : TypeKind.Simple);
        }

        @Override
        public void validate(Object entity, String group, IMessagesHolder messages) throws ValidationFault {
            Object property = null;
            try {
                property = this.getMethod().invoke(entity, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof ValidationFault) {
                    throw (ValidationFault)e.getCause();
                }
                if (e.getCause() instanceof IllegalStateException) {
                    throw (IllegalStateException)e.getCause();
                }
                throw new IllegalStateException(e.getCause());
            }
            switch (this.typeKind) {
                case Array: 
                case List: {
                    try {
                        for (Validator<? extends Annotation, ?> validator : this.containerValidators) {
                            this.getValidateMethod().invoke(validator, property, group, messages);
                        }
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (InvocationTargetException e) {
                        if (e.getCause() instanceof ValidationFault) {
                            throw (ValidationFault)e.getCause();
                        }
                        if (e.getCause() instanceof IllegalStateException) {
                            throw (IllegalStateException)e.getCause();
                        }
                        throw new IllegalStateException(e.getCause());
                    }
                }
            }
            block20: for (Validator<? extends Annotation, ?> validator : this.validators) {
                try {
                    switch (this.typeKind) {
                        case List: {
                            if (property == null) continue block20;
                            for (Object element : (List)property) {
                                this.getValidateMethod().invoke(validator, element, group, messages);
                            }
                            continue block20;
                        }
                        case Array: {
                            if (property == null) continue block20;
                            for (Object element : (Object[])property) {
                                this.getValidateMethod().invoke(validator, element, group, messages);
                            }
                            continue block20;
                        }
                        default: {
                            this.getValidateMethod().invoke(validator, property, group, messages);
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof ValidationFault) {
                        throw (ValidationFault)e.getCause();
                    }
                    if (e.getCause() instanceof IllegalStateException) {
                        throw (IllegalStateException)e.getCause();
                    }
                    throw new IllegalStateException(e.getCause());
                }
            }
        }

        public void setValidators(Validator<?, ?>[] validators) {
            this.validators = validators;
        }

        public void setContainerValidators(ContainerValidator<?, ?>[] containerValidators) {
            this.containerValidators = containerValidators;
        }

        private Method getValidateMethod() {
            if (validateMethod == null) {
                try {
                    validateMethod = Validator.class.getDeclaredMethod("validate", Object.class, String.class, IMessagesHolder.class);
                }
                catch (Exception e) {
                    if (e instanceof IllegalStateException) {
                        throw (IllegalStateException)e;
                    }
                    throw new IllegalStateException(e);
                }
            }
            return validateMethod;
        }

        @Override
        public String elementId() {
            return this.elementId;
        }

        public void setElementId(String elementId) {
            this.elementId = elementId;
        }

        private static enum TypeKind {
            Simple,
            Array,
            List;

        }
    }
}

