/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.services.autoscaling.model.BlockDeviceMapping;
import com.amazonaws.services.autoscaling.model.InstanceMonitoring;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchConfiguration {
    private String launchConfigurationName;
    private String launchConfigurationARN;
    private String imageId;
    private String keyName;
    private List<String> securityGroups;
    private String userData;
    private String instanceType;
    private String kernelId;
    private String ramdiskId;
    private List<BlockDeviceMapping> blockDeviceMappings;
    private InstanceMonitoring instanceMonitoring;
    private String spotPrice;
    private String iamInstanceProfile;
    private Date createdTime;

    public String getLaunchConfigurationName() {
        return this.launchConfigurationName;
    }

    public void setLaunchConfigurationName(String launchConfigurationName) {
        this.launchConfigurationName = launchConfigurationName;
    }

    public LaunchConfiguration withLaunchConfigurationName(String launchConfigurationName) {
        this.launchConfigurationName = launchConfigurationName;
        return this;
    }

    public String getLaunchConfigurationARN() {
        return this.launchConfigurationARN;
    }

    public void setLaunchConfigurationARN(String launchConfigurationARN) {
        this.launchConfigurationARN = launchConfigurationARN;
    }

    public LaunchConfiguration withLaunchConfigurationARN(String launchConfigurationARN) {
        this.launchConfigurationARN = launchConfigurationARN;
        return this;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public LaunchConfiguration withImageId(String imageId) {
        this.imageId = imageId;
        return this;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public LaunchConfiguration withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public List<String> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList<String>();
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        ArrayList<String> securityGroupsCopy = new ArrayList<String>(securityGroups.size());
        securityGroupsCopy.addAll(securityGroups);
        this.securityGroups = securityGroupsCopy;
    }

    public LaunchConfiguration withSecurityGroups(String ... securityGroups) {
        if (this.getSecurityGroups() == null) {
            this.setSecurityGroups(new ArrayList<String>(securityGroups.length));
        }
        for (String value : securityGroups) {
            this.getSecurityGroups().add(value);
        }
        return this;
    }

    public LaunchConfiguration withSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
        } else {
            ArrayList<String> securityGroupsCopy = new ArrayList<String>(securityGroups.size());
            securityGroupsCopy.addAll(securityGroups);
            this.securityGroups = securityGroupsCopy;
        }
        return this;
    }

    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public LaunchConfiguration withUserData(String userData) {
        this.userData = userData;
        return this;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public LaunchConfiguration withInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return this;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public LaunchConfiguration withKernelId(String kernelId) {
        this.kernelId = kernelId;
        return this;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public LaunchConfiguration withRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
        return this;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        ArrayList<BlockDeviceMapping> blockDeviceMappingsCopy = new ArrayList<BlockDeviceMapping>(blockDeviceMappings.size());
        blockDeviceMappingsCopy.addAll(blockDeviceMappings);
        this.blockDeviceMappings = blockDeviceMappingsCopy;
    }

    public LaunchConfiguration withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        if (this.getBlockDeviceMappings() == null) {
            this.setBlockDeviceMappings(new ArrayList<BlockDeviceMapping>(blockDeviceMappings.length));
        }
        for (BlockDeviceMapping value : blockDeviceMappings) {
            this.getBlockDeviceMappings().add(value);
        }
        return this;
    }

    public LaunchConfiguration withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
        } else {
            ArrayList<BlockDeviceMapping> blockDeviceMappingsCopy = new ArrayList<BlockDeviceMapping>(blockDeviceMappings.size());
            blockDeviceMappingsCopy.addAll(blockDeviceMappings);
            this.blockDeviceMappings = blockDeviceMappingsCopy;
        }
        return this;
    }

    public InstanceMonitoring getInstanceMonitoring() {
        return this.instanceMonitoring;
    }

    public void setInstanceMonitoring(InstanceMonitoring instanceMonitoring) {
        this.instanceMonitoring = instanceMonitoring;
    }

    public LaunchConfiguration withInstanceMonitoring(InstanceMonitoring instanceMonitoring) {
        this.instanceMonitoring = instanceMonitoring;
        return this;
    }

    public String getSpotPrice() {
        return this.spotPrice;
    }

    public void setSpotPrice(String spotPrice) {
        this.spotPrice = spotPrice;
    }

    public LaunchConfiguration withSpotPrice(String spotPrice) {
        this.spotPrice = spotPrice;
        return this;
    }

    public String getIamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public void setIamInstanceProfile(String iamInstanceProfile) {
        this.iamInstanceProfile = iamInstanceProfile;
    }

    public LaunchConfiguration withIamInstanceProfile(String iamInstanceProfile) {
        this.iamInstanceProfile = iamInstanceProfile;
        return this;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public LaunchConfiguration withCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.launchConfigurationName != null) {
            sb.append("LaunchConfigurationName: " + this.launchConfigurationName + ", ");
        }
        if (this.launchConfigurationARN != null) {
            sb.append("LaunchConfigurationARN: " + this.launchConfigurationARN + ", ");
        }
        if (this.imageId != null) {
            sb.append("ImageId: " + this.imageId + ", ");
        }
        if (this.keyName != null) {
            sb.append("KeyName: " + this.keyName + ", ");
        }
        if (this.securityGroups != null) {
            sb.append("SecurityGroups: " + this.securityGroups + ", ");
        }
        if (this.userData != null) {
            sb.append("UserData: " + this.userData + ", ");
        }
        if (this.instanceType != null) {
            sb.append("InstanceType: " + this.instanceType + ", ");
        }
        if (this.kernelId != null) {
            sb.append("KernelId: " + this.kernelId + ", ");
        }
        if (this.ramdiskId != null) {
            sb.append("RamdiskId: " + this.ramdiskId + ", ");
        }
        if (this.blockDeviceMappings != null) {
            sb.append("BlockDeviceMappings: " + this.blockDeviceMappings + ", ");
        }
        if (this.instanceMonitoring != null) {
            sb.append("InstanceMonitoring: " + this.instanceMonitoring + ", ");
        }
        if (this.spotPrice != null) {
            sb.append("SpotPrice: " + this.spotPrice + ", ");
        }
        if (this.iamInstanceProfile != null) {
            sb.append("IamInstanceProfile: " + this.iamInstanceProfile + ", ");
        }
        if (this.createdTime != null) {
            sb.append("CreatedTime: " + this.createdTime + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLaunchConfigurationName() == null ? 0 : this.getLaunchConfigurationName().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchConfigurationARN() == null ? 0 : this.getLaunchConfigurationARN().hashCode());
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getKeyName() == null ? 0 : this.getKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : ((Object)this.getSecurityGroups()).hashCode());
        hashCode = 31 * hashCode + (this.getUserData() == null ? 0 : this.getUserData().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getKernelId() == null ? 0 : this.getKernelId().hashCode());
        hashCode = 31 * hashCode + (this.getRamdiskId() == null ? 0 : this.getRamdiskId().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : ((Object)this.getBlockDeviceMappings()).hashCode());
        hashCode = 31 * hashCode + (this.getInstanceMonitoring() == null ? 0 : this.getInstanceMonitoring().hashCode());
        hashCode = 31 * hashCode + (this.getSpotPrice() == null ? 0 : this.getSpotPrice().hashCode());
        hashCode = 31 * hashCode + (this.getIamInstanceProfile() == null ? 0 : this.getIamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchConfiguration)) {
            return false;
        }
        LaunchConfiguration other = (LaunchConfiguration)obj;
        if (other.getLaunchConfigurationName() == null ^ this.getLaunchConfigurationName() == null) {
            return false;
        }
        if (other.getLaunchConfigurationName() != null && !other.getLaunchConfigurationName().equals(this.getLaunchConfigurationName())) {
            return false;
        }
        if (other.getLaunchConfigurationARN() == null ^ this.getLaunchConfigurationARN() == null) {
            return false;
        }
        if (other.getLaunchConfigurationARN() != null && !other.getLaunchConfigurationARN().equals(this.getLaunchConfigurationARN())) {
            return false;
        }
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getKeyName() == null ^ this.getKeyName() == null) {
            return false;
        }
        if (other.getKeyName() != null && !other.getKeyName().equals(this.getKeyName())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !((Object)other.getSecurityGroups()).equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getUserData() == null ^ this.getUserData() == null) {
            return false;
        }
        if (other.getUserData() != null && !other.getUserData().equals(this.getUserData())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getKernelId() == null ^ this.getKernelId() == null) {
            return false;
        }
        if (other.getKernelId() != null && !other.getKernelId().equals(this.getKernelId())) {
            return false;
        }
        if (other.getRamdiskId() == null ^ this.getRamdiskId() == null) {
            return false;
        }
        if (other.getRamdiskId() != null && !other.getRamdiskId().equals(this.getRamdiskId())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !((Object)other.getBlockDeviceMappings()).equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getInstanceMonitoring() == null ^ this.getInstanceMonitoring() == null) {
            return false;
        }
        if (other.getInstanceMonitoring() != null && !other.getInstanceMonitoring().equals(this.getInstanceMonitoring())) {
            return false;
        }
        if (other.getSpotPrice() == null ^ this.getSpotPrice() == null) {
            return false;
        }
        if (other.getSpotPrice() != null && !other.getSpotPrice().equals(this.getSpotPrice())) {
            return false;
        }
        if (other.getIamInstanceProfile() == null ^ this.getIamInstanceProfile() == null) {
            return false;
        }
        if (other.getIamInstanceProfile() != null && !other.getIamInstanceProfile().equals(this.getIamInstanceProfile())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        return other.getCreatedTime() == null || other.getCreatedTime().equals(this.getCreatedTime());
    }
}

