/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.elasticache.AmazonElastiCacheAsync;
import com.amazonaws.services.elasticache.AmazonElastiCacheClient;
import com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest;
import com.amazonaws.services.elasticache.model.CacheCluster;
import com.amazonaws.services.elasticache.model.CacheParameterGroup;
import com.amazonaws.services.elasticache.model.CacheSecurityGroup;
import com.amazonaws.services.elasticache.model.CreateCacheClusterRequest;
import com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheClustersResult;
import com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsResult;
import com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheParametersResult;
import com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsResult;
import com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest;
import com.amazonaws.services.elasticache.model.DescribeEventsRequest;
import com.amazonaws.services.elasticache.model.DescribeEventsResult;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsResult;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesResult;
import com.amazonaws.services.elasticache.model.EngineDefaults;
import com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest;
import com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupResult;
import com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest;
import com.amazonaws.services.elasticache.model.RebootCacheClusterRequest;
import com.amazonaws.services.elasticache.model.ReservedCacheNode;
import com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.ResetCacheParameterGroupResult;
import com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonElastiCacheAsyncClient
extends AmazonElastiCacheClient
implements AmazonElastiCacheAsync {
    private ExecutorService executorService;

    public AmazonElastiCacheAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonElastiCacheAsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public AmazonElastiCacheAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonElastiCacheAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonElastiCacheAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonElastiCacheAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AmazonElastiCacheAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonElastiCacheAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<ModifyCacheParameterGroupResult> modifyCacheParameterGroupAsync(final ModifyCacheParameterGroupRequest modifyCacheParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyCacheParameterGroupResult>(){

            @Override
            public ModifyCacheParameterGroupResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.modifyCacheParameterGroup(modifyCacheParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<ModifyCacheParameterGroupResult> modifyCacheParameterGroupAsync(final ModifyCacheParameterGroupRequest modifyCacheParameterGroupRequest, final AsyncHandler<ModifyCacheParameterGroupRequest, ModifyCacheParameterGroupResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyCacheParameterGroupResult>(){

            @Override
            public ModifyCacheParameterGroupResult call() throws Exception {
                ModifyCacheParameterGroupResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.modifyCacheParameterGroup(modifyCacheParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyCacheParameterGroupRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> authorizeCacheSecurityGroupIngressAsync(final AuthorizeCacheSecurityGroupIngressRequest authorizeCacheSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.authorizeCacheSecurityGroupIngress(authorizeCacheSecurityGroupIngressRequest);
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> authorizeCacheSecurityGroupIngressAsync(final AuthorizeCacheSecurityGroupIngressRequest authorizeCacheSecurityGroupIngressRequest, final AsyncHandler<AuthorizeCacheSecurityGroupIngressRequest, CacheSecurityGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                CacheSecurityGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.authorizeCacheSecurityGroupIngress(authorizeCacheSecurityGroupIngressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(authorizeCacheSecurityGroupIngressRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CacheCluster> rebootCacheClusterAsync(final RebootCacheClusterRequest rebootCacheClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.rebootCacheCluster(rebootCacheClusterRequest);
            }
        });
    }

    @Override
    public Future<CacheCluster> rebootCacheClusterAsync(final RebootCacheClusterRequest rebootCacheClusterRequest, final AsyncHandler<RebootCacheClusterRequest, CacheCluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                CacheCluster result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.rebootCacheCluster(rebootCacheClusterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(rebootCacheClusterRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedCacheNodesOfferingsResult> describeReservedCacheNodesOfferingsAsync(final DescribeReservedCacheNodesOfferingsRequest describeReservedCacheNodesOfferingsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedCacheNodesOfferingsResult>(){

            @Override
            public DescribeReservedCacheNodesOfferingsResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeReservedCacheNodesOfferings(describeReservedCacheNodesOfferingsRequest);
            }
        });
    }

    @Override
    public Future<DescribeReservedCacheNodesOfferingsResult> describeReservedCacheNodesOfferingsAsync(final DescribeReservedCacheNodesOfferingsRequest describeReservedCacheNodesOfferingsRequest, final AsyncHandler<DescribeReservedCacheNodesOfferingsRequest, DescribeReservedCacheNodesOfferingsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedCacheNodesOfferingsResult>(){

            @Override
            public DescribeReservedCacheNodesOfferingsResult call() throws Exception {
                DescribeReservedCacheNodesOfferingsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeReservedCacheNodesOfferings(describeReservedCacheNodesOfferingsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeReservedCacheNodesOfferingsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CacheCluster> deleteCacheClusterAsync(final DeleteCacheClusterRequest deleteCacheClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.deleteCacheCluster(deleteCacheClusterRequest);
            }
        });
    }

    @Override
    public Future<CacheCluster> deleteCacheClusterAsync(final DeleteCacheClusterRequest deleteCacheClusterRequest, final AsyncHandler<DeleteCacheClusterRequest, CacheCluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                CacheCluster result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.deleteCacheCluster(deleteCacheClusterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteCacheClusterRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CacheCluster> createCacheClusterAsync(final CreateCacheClusterRequest createCacheClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.createCacheCluster(createCacheClusterRequest);
            }
        });
    }

    @Override
    public Future<CacheCluster> createCacheClusterAsync(final CreateCacheClusterRequest createCacheClusterRequest, final AsyncHandler<CreateCacheClusterRequest, CacheCluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                CacheCluster result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.createCacheCluster(createCacheClusterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createCacheClusterRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> revokeCacheSecurityGroupIngressAsync(final RevokeCacheSecurityGroupIngressRequest revokeCacheSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.revokeCacheSecurityGroupIngress(revokeCacheSecurityGroupIngressRequest);
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> revokeCacheSecurityGroupIngressAsync(final RevokeCacheSecurityGroupIngressRequest revokeCacheSecurityGroupIngressRequest, final AsyncHandler<RevokeCacheSecurityGroupIngressRequest, CacheSecurityGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                CacheSecurityGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.revokeCacheSecurityGroupIngress(revokeCacheSecurityGroupIngressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(revokeCacheSecurityGroupIngressRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CacheParameterGroup> createCacheParameterGroupAsync(final CreateCacheParameterGroupRequest createCacheParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheParameterGroup>(){

            @Override
            public CacheParameterGroup call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.createCacheParameterGroup(createCacheParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<CacheParameterGroup> createCacheParameterGroupAsync(final CreateCacheParameterGroupRequest createCacheParameterGroupRequest, final AsyncHandler<CreateCacheParameterGroupRequest, CacheParameterGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheParameterGroup>(){

            @Override
            public CacheParameterGroup call() throws Exception {
                CacheParameterGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.createCacheParameterGroup(createCacheParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createCacheParameterGroupRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(final DescribeEventsRequest describeEventsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeEvents(describeEventsRequest);
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(final DescribeEventsRequest describeEventsRequest, final AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                DescribeEventsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeEvents(describeEventsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeEventsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedCacheNodesResult> describeReservedCacheNodesAsync(final DescribeReservedCacheNodesRequest describeReservedCacheNodesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedCacheNodesResult>(){

            @Override
            public DescribeReservedCacheNodesResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeReservedCacheNodes(describeReservedCacheNodesRequest);
            }
        });
    }

    @Override
    public Future<DescribeReservedCacheNodesResult> describeReservedCacheNodesAsync(final DescribeReservedCacheNodesRequest describeReservedCacheNodesRequest, final AsyncHandler<DescribeReservedCacheNodesRequest, DescribeReservedCacheNodesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedCacheNodesResult>(){

            @Override
            public DescribeReservedCacheNodesResult call() throws Exception {
                DescribeReservedCacheNodesResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeReservedCacheNodes(describeReservedCacheNodesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeReservedCacheNodesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheParameterGroupsResult> describeCacheParameterGroupsAsync(final DescribeCacheParameterGroupsRequest describeCacheParameterGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheParameterGroupsResult>(){

            @Override
            public DescribeCacheParameterGroupsResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeCacheParameterGroups(describeCacheParameterGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeCacheParameterGroupsResult> describeCacheParameterGroupsAsync(final DescribeCacheParameterGroupsRequest describeCacheParameterGroupsRequest, final AsyncHandler<DescribeCacheParameterGroupsRequest, DescribeCacheParameterGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheParameterGroupsResult>(){

            @Override
            public DescribeCacheParameterGroupsResult call() throws Exception {
                DescribeCacheParameterGroupsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeCacheParameterGroups(describeCacheParameterGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeCacheParameterGroupsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteCacheParameterGroupAsync(final DeleteCacheParameterGroupRequest deleteCacheParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElastiCacheAsyncClient.this.deleteCacheParameterGroup(deleteCacheParameterGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteCacheParameterGroupAsync(final DeleteCacheParameterGroupRequest deleteCacheParameterGroupRequest, final AsyncHandler<DeleteCacheParameterGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonElastiCacheAsyncClient.this.deleteCacheParameterGroup(deleteCacheParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteCacheParameterGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteCacheSecurityGroupAsync(final DeleteCacheSecurityGroupRequest deleteCacheSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElastiCacheAsyncClient.this.deleteCacheSecurityGroup(deleteCacheSecurityGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteCacheSecurityGroupAsync(final DeleteCacheSecurityGroupRequest deleteCacheSecurityGroupRequest, final AsyncHandler<DeleteCacheSecurityGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonElastiCacheAsyncClient.this.deleteCacheSecurityGroup(deleteCacheSecurityGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteCacheSecurityGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ReservedCacheNode> purchaseReservedCacheNodesOfferingAsync(final PurchaseReservedCacheNodesOfferingRequest purchaseReservedCacheNodesOfferingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReservedCacheNode>(){

            @Override
            public ReservedCacheNode call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.purchaseReservedCacheNodesOffering(purchaseReservedCacheNodesOfferingRequest);
            }
        });
    }

    @Override
    public Future<ReservedCacheNode> purchaseReservedCacheNodesOfferingAsync(final PurchaseReservedCacheNodesOfferingRequest purchaseReservedCacheNodesOfferingRequest, final AsyncHandler<PurchaseReservedCacheNodesOfferingRequest, ReservedCacheNode> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReservedCacheNode>(){

            @Override
            public ReservedCacheNode call() throws Exception {
                ReservedCacheNode result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.purchaseReservedCacheNodesOffering(purchaseReservedCacheNodesOfferingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(purchaseReservedCacheNodesOfferingRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheClustersResult> describeCacheClustersAsync(final DescribeCacheClustersRequest describeCacheClustersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheClustersResult>(){

            @Override
            public DescribeCacheClustersResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeCacheClusters(describeCacheClustersRequest);
            }
        });
    }

    @Override
    public Future<DescribeCacheClustersResult> describeCacheClustersAsync(final DescribeCacheClustersRequest describeCacheClustersRequest, final AsyncHandler<DescribeCacheClustersRequest, DescribeCacheClustersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheClustersResult>(){

            @Override
            public DescribeCacheClustersResult call() throws Exception {
                DescribeCacheClustersResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeCacheClusters(describeCacheClustersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeCacheClustersRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CacheCluster> modifyCacheClusterAsync(final ModifyCacheClusterRequest modifyCacheClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.modifyCacheCluster(modifyCacheClusterRequest);
            }
        });
    }

    @Override
    public Future<CacheCluster> modifyCacheClusterAsync(final ModifyCacheClusterRequest modifyCacheClusterRequest, final AsyncHandler<ModifyCacheClusterRequest, CacheCluster> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                CacheCluster result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.modifyCacheCluster(modifyCacheClusterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyCacheClusterRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheSecurityGroupsResult> describeCacheSecurityGroupsAsync(final DescribeCacheSecurityGroupsRequest describeCacheSecurityGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheSecurityGroupsResult>(){

            @Override
            public DescribeCacheSecurityGroupsResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeCacheSecurityGroups(describeCacheSecurityGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeCacheSecurityGroupsResult> describeCacheSecurityGroupsAsync(final DescribeCacheSecurityGroupsRequest describeCacheSecurityGroupsRequest, final AsyncHandler<DescribeCacheSecurityGroupsRequest, DescribeCacheSecurityGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheSecurityGroupsResult>(){

            @Override
            public DescribeCacheSecurityGroupsResult call() throws Exception {
                DescribeCacheSecurityGroupsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeCacheSecurityGroups(describeCacheSecurityGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeCacheSecurityGroupsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> createCacheSecurityGroupAsync(final CreateCacheSecurityGroupRequest createCacheSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.createCacheSecurityGroup(createCacheSecurityGroupRequest);
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> createCacheSecurityGroupAsync(final CreateCacheSecurityGroupRequest createCacheSecurityGroupRequest, final AsyncHandler<CreateCacheSecurityGroupRequest, CacheSecurityGroup> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                CacheSecurityGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.createCacheSecurityGroup(createCacheSecurityGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createCacheSecurityGroupRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheParametersResult> describeCacheParametersAsync(final DescribeCacheParametersRequest describeCacheParametersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheParametersResult>(){

            @Override
            public DescribeCacheParametersResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeCacheParameters(describeCacheParametersRequest);
            }
        });
    }

    @Override
    public Future<DescribeCacheParametersResult> describeCacheParametersAsync(final DescribeCacheParametersRequest describeCacheParametersRequest, final AsyncHandler<DescribeCacheParametersRequest, DescribeCacheParametersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheParametersResult>(){

            @Override
            public DescribeCacheParametersResult call() throws Exception {
                DescribeCacheParametersResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeCacheParameters(describeCacheParametersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeCacheParametersRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultParametersAsync(final DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EngineDefaults>(){

            @Override
            public EngineDefaults call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeEngineDefaultParameters(describeEngineDefaultParametersRequest);
            }
        });
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultParametersAsync(final DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest, final AsyncHandler<DescribeEngineDefaultParametersRequest, EngineDefaults> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EngineDefaults>(){

            @Override
            public EngineDefaults call() throws Exception {
                EngineDefaults result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeEngineDefaultParameters(describeEngineDefaultParametersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeEngineDefaultParametersRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ResetCacheParameterGroupResult> resetCacheParameterGroupAsync(final ResetCacheParameterGroupRequest resetCacheParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ResetCacheParameterGroupResult>(){

            @Override
            public ResetCacheParameterGroupResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.resetCacheParameterGroup(resetCacheParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<ResetCacheParameterGroupResult> resetCacheParameterGroupAsync(final ResetCacheParameterGroupRequest resetCacheParameterGroupRequest, final AsyncHandler<ResetCacheParameterGroupRequest, ResetCacheParameterGroupResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ResetCacheParameterGroupResult>(){

            @Override
            public ResetCacheParameterGroupResult call() throws Exception {
                ResetCacheParameterGroupResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.resetCacheParameterGroup(resetCacheParameterGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(resetCacheParameterGroupRequest, result);
                return result;
            }
        });
    }
}

