/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.util;

import com.clustercontrol.ws.aws.IpPermission;
import com.clustercontrol.ws.aws.SecurityGroup;
import com.clustercontrol.ws.aws.UserIdGroupPair;
import java.util.ArrayList;

public class SecurityGroupUtil {
    public static SecurityGroup convertToSecrurityGroup(com.amazonaws.services.ec2.model.SecurityGroup awsSg) {
        SecurityGroup sg = new SecurityGroup();
        sg.setOwnerId(awsSg.getOwnerId());
        sg.setGroupId(awsSg.getGroupId());
        sg.setGroupName(awsSg.getGroupName());
        sg.setDescription(awsSg.getDescription());
        sg.setVpcId(awsSg.getVpcId());
        ArrayList<IpPermission> ipPermissions = new ArrayList<IpPermission>();
        for (com.amazonaws.services.ec2.model.IpPermission awsIpPermission : awsSg.getIpPermissions()) {
            IpPermission ipPermission = SecurityGroupUtil.convertToIpPermission(awsIpPermission);
            ipPermissions.add(ipPermission);
        }
        sg.setIpPermissions(ipPermissions);
        ArrayList<IpPermission> ipPermissionsEgress = new ArrayList<IpPermission>();
        for (com.amazonaws.services.ec2.model.IpPermission awsIpPermission : awsSg.getIpPermissionsEgress()) {
            IpPermission ipPermission = SecurityGroupUtil.convertToIpPermission(awsIpPermission);
            ipPermissionsEgress.add(ipPermission);
        }
        sg.setIpPermissionsEgress(ipPermissionsEgress);
        return sg;
    }

    public static IpPermission convertToIpPermission(com.amazonaws.services.ec2.model.IpPermission awsIpPermission) {
        IpPermission ipPermission = new IpPermission();
        ipPermission.setFromPort(awsIpPermission.getFromPort());
        ipPermission.setToPort(awsIpPermission.getToPort());
        ipPermission.setIpProtocol(awsIpPermission.getIpProtocol());
        ipPermission.setIpRanges(awsIpPermission.getIpRanges());
        ArrayList<UserIdGroupPair> userIdGroupPairs = new ArrayList<UserIdGroupPair>();
        for (com.amazonaws.services.ec2.model.UserIdGroupPair uig : awsIpPermission.getUserIdGroupPairs()) {
            UserIdGroupPair pair = new UserIdGroupPair();
            pair.setGroupId(uig.getGroupId());
            pair.setGroupName(uig.getGroupName());
            pair.setUserId(uig.getUserId());
        }
        ipPermission.setUserIdGroupPairs(userIdGroupPairs);
        return ipPermission;
    }
}

