/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import java.util.List;

import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.Size;

/**
 * ストレージバックアップ情報を保持するクラス。 
 * {@link com.clustercontrol.ws.cloud.CloudEndpoint#addInstanceBackup(CreateInstanceBackupRequest2 request) addInstanceBackup 関数} にて使用される。
 *
 */
public class CreateInstanceBackupRequest2 extends CloudRequest {	
	private String name;
	private String instanceId;
	private String description;
	private Boolean noReboot;
	private List<String> storageIds;
	private String detail;

	public CreateInstanceBackupRequest2() {
	}

	/**
	 * インスタンス Id を取得する。
	 * 
	 * @return インスタンス Id
	 */
	@ElementId("instanceId")
	@Size(max = 64)
	@NotNull
	public String getInstanceId() {
		return instanceId;
	}
	/**
	 * インスタンス Id を指定する。
	 * 
	 * @param instanceId　インスタンス Id
	 */
	public void setInstanceId(String instanceId) {
		this.instanceId = instanceId;
	}
	/**
	 * イメージ名 を取得する。
	 * 
	 * @return インスタンス Id
	 */
	@ElementId("instanceBackupName")
	@Size(max = 128)
	@NotNull
	public String getName() {
		return name;
	}
	/**
	 * イメージ名 を指定する。
	 * 
	 * @param imageName イメージ名
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * 説明 を取得する。
	 * 
	 * @return 説明
	 */
	@ElementId("description")
	@Size(max = 256)
	public String getDescription() {
		return description;
	}
	/**
	 * 説明 を指定する。
	 * 
	 * @param description 説明
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	public String getDetail() {
		return detail;
	}

	public void setDetail(String detail) {
		this.detail = detail;
	}

	public Boolean getNoReboot() {
		return noReboot;
	}

	public void setNoReboot(Boolean noReboot) {
		this.noReboot = noReboot;
	}

	public List<String> getStorageIds() {
		return storageIds;
	}

	public void setStorageIds(List<String> storageIds) {
		this.storageIds = storageIds;
	}
}